/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.converter.Converter;
import net.sourceforge.jeuclid.converter.ConverterPlugin;

public class ImageIOConverter
implements ConverterPlugin {
    private final ImageWriter writer;
    private final boolean removeAlpha;

    ImageIOConverter(ImageWriter iw, boolean remAlpha) {
        this.writer = iw;
        this.removeAlpha = remAlpha;
    }

    public Dimension convert(MathBase base, OutputStream outStream) throws IOException {
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(outStream);
        this.writer.setOutput(ios);
        BufferedImage image = Converter.getConverter().render(base);
        if (this.removeAlpha && image.getColorModel().hasAlpha()) {
            this.writer.write(this.removeAlpha(image));
        } else {
            this.writer.write(image);
        }
        ios.close();
        Graphics2D temp = (Graphics2D)image.getGraphics();
        return new Dimension((int)Math.ceil(base.getWidth(temp)), (int)Math.ceil(base.getHeight(temp)));
    }

    private BufferedImage removeAlpha(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage noAlpha = new BufferedImage(width, height, 1);
        Graphics2D g = noAlpha.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.drawImage((Image)image, 0, 0, null);
        return noAlpha;
    }
}

