/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.ant;

import java.io.File;
import java.io.IOException;
import net.sourceforge.jeuclid.Converter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class MathMLConverter
extends MatchingTask {
    private static final String CURRENT_DIR = "./";
    private static final String EXTENSION_SEP = ".";
    private File mdestDir;
    private File mbaseDir;
    private File minFile;
    private File moutFile;
    private String moutType = "image/png";
    private boolean mforce;

    public void execute() {
        if (this.mbaseDir == null) {
            this.mbaseDir = this.getProject().resolveFile(CURRENT_DIR);
        }
        if (this.minFile != null && this.moutFile != null) {
            try {
                Converter.convert(this.minFile, this.moutFile, this.moutType);
            }
            catch (IOException io) {
                throw new BuildException((Throwable)io);
            }
            return;
        }
        if (this.mdestDir == null) {
            String msg = "m_destDir attributes must be set!";
            throw new BuildException("m_destDir attributes must be set!");
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.mbaseDir);
        this.log("Transforming into " + this.mdestDir, 2);
        String[] list = scanner.getIncludedFiles();
        for (int i = 0; i < list.length; ++i) {
            this.process(this.mbaseDir, list[i], this.mdestDir);
        }
        String[] dirs = scanner.getIncludedDirectories();
        for (int j = 0; j < dirs.length; ++j) {
            list = new File(this.mbaseDir, dirs[j]).list();
            for (int i = 0; i < list.length; ++i) {
                this.process(this.mbaseDir, list[i], this.mdestDir);
            }
        }
    }

    public void setForce(boolean force) {
        this.mforce = force;
    }

    public void setBasedir(File dir) {
        this.mbaseDir = dir;
    }

    public void setDestdir(File dir) {
        this.mdestDir = dir;
    }

    public void setOut(File outFile) {
        this.moutFile = outFile;
    }

    public void setIn(File inFile) {
        this.minFile = inFile;
    }

    public void setType(String mimetype) {
        this.moutType = mimetype;
    }

    private void ensureDirectoryFor(File targetFile) {
        File directory = new File(targetFile.getParent());
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    private void process(File baseDir, String xmlFile, File destDir) {
        File outFile = null;
        File inFile = null;
        String suffix = EXTENSION_SEP + Converter.getSuffixForMimeType(this.moutType);
        try {
            inFile = new File(baseDir, xmlFile);
            int dotPos = xmlFile.lastIndexOf(46);
            outFile = dotPos > 0 ? new File(destDir, xmlFile.substring(0, xmlFile.lastIndexOf(46)) + suffix) : new File(destDir, xmlFile + suffix);
            if (this.mforce || inFile.lastModified() > outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                Converter.convert(inFile, outFile, this.moutType);
            }
        }
        catch (IOException ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            throw new BuildException((Throwable)ex);
        }
    }
}

