/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.BytesByReference;
import com.inet.odbc.OdbcConnection;
import com.inet.odbc.OdbcLibrary;
import com.inet.odbc.OdbcStatement;
import com.inet.odbc.OdbcUtils;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import java.sql.SQLException;

class ColumnDescription {
    static final short UNKNOWN_TYPE = 9999;
    private OdbcStatement statement;
    private short index;
    private short odbcType = (short)9999;
    private int columnLength = -1;
    private String label;
    private String name;

    ColumnDescription(short index, OdbcStatement statement) {
        this.index = index;
        this.statement = statement;
    }

    short getIndex() {
        return this.index;
    }

    short getOdbcType() throws SQLException {
        if (this.odbcType == 9999) {
            this.odbcType = (short)this.getIntValue((short)1002);
        }
        return this.odbcType;
    }

    short getJdbcType() throws SQLException {
        return OdbcUtils.getJdbcType(this.getOdbcType());
    }

    String getTypeString() throws SQLException {
        return this.getStringValue((short)14);
    }

    int getColumnLength() throws SQLException {
        if (this.columnLength < 0) {
            this.columnLength = this.getIntValue((short)1003);
        }
        return this.columnLength;
    }

    String getLabel() throws SQLException {
        if (this.label == null) {
            this.label = this.getStringValue((short)18);
        }
        return this.label;
    }

    String getName() throws SQLException {
        if (this.name == null) {
            this.name = this.getStringValue((short)1011);
        }
        return this.name;
    }

    boolean isAutoIncrement() throws SQLException {
        return this.getIntValue((short)11) != 0;
    }

    boolean isCaseSensitive() throws SQLException {
        return this.getIntValue((short)12) != 0;
    }

    boolean isSearchable() throws SQLException {
        return this.getIntValue((short)13) != 0;
    }

    boolean isCurrency() throws SQLException {
        return this.getIntValue((short)9) != 0;
    }

    public int isNullable() throws SQLException {
        return this.getIntValue((short)1008);
    }

    public boolean isSigned() throws SQLException {
        return this.getIntValue((short)8) != 0;
    }

    public int getColumnDisplaySize() throws SQLException {
        return this.getIntValue((short)6);
    }

    public String getSchemaName() throws SQLException {
        return this.getStringValue((short)16);
    }

    public int getPrecision() throws SQLException {
        return this.getIntValue((short)1005);
    }

    public int getScale() throws SQLException {
        return this.getIntValue((short)1006);
    }

    public String getTableName() throws SQLException {
        return this.getStringValue((short)15);
    }

    public String getCatalogName() throws SQLException {
        return this.getStringValue((short)17);
    }

    public boolean isReadOnly() throws SQLException {
        return this.getIntValue((short)10) == 0;
    }

    public boolean isWritable() throws SQLException {
        return this.getIntValue((short)10) == 2;
    }

    public boolean isDefinitelyWritable() throws SQLException {
        return this.getIntValue((short)10) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIntValue(short type) throws SQLException {
        OdbcConnection con = this.statement.getConnection();
        Object object = con.getLock();
        synchronized (object) {
            IntByReference ref = con.getIntRef();
            this.statement.checkSqlReturn(OdbcLibrary.ODBC.SQLColAttribute(this.statement.getHStmt(), this.index, type, null, (short)0, null, ref));
            return ref.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringValue(short type) throws SQLException {
        OdbcConnection con = this.statement.getConnection();
        Object object = con.getLock();
        synchronized (object) {
            BytesByReference value = con.getBytesMaxSqlLengthRef();
            ShortByReference length = new ShortByReference();
            this.statement.checkSqlReturn(OdbcLibrary.ODBC.SQLColAttribute(this.statement.getHStmt(), this.index, type, value, (short)512, length, null));
            byte[] bytes = value.getValue(length.getValue());
            return this.statement.getConnection().toString(bytes, bytes.length);
        }
    }
}

