/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.StringListGroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.util.ArrayList;
import java.util.List;

public abstract class EmailGroupFieldDefinition
extends StringListGroupFieldDefinition {
    public EmailGroupFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_string_list", prio);
    }

    public EmailGroupFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, fieldKey, displayType, prio);
    }

    @Override
    public FieldValue getFieldValue(UserGroupInfo userGroup) {
        String string = "";
        UserGroupField userGroupField = UserGroupManager.getRecoveryEnabledInstance().getField(this.getFieldKey());
        if (userGroup != null) {
            string = (String)userGroup.getValue(userGroupField);
        }
        if (string == null) {
            string = (String)userGroupField.getDefaultValue();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(EmailAddressHelper.get().getValidEmailAddressesFrom(string));
        FieldValue fieldValue = new FieldValue(new Json().toJson(arrayList));
        fieldValue.setVisibleInPreview(arrayList.size() > 0);
        return fieldValue;
    }

    @Override
    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        String string = this.a(value);
        super.save(userGroup, userGroupUpdateData, string);
    }

    @Override
    public void validate(Object value) throws ClientMessageException {
        String string = this.a(value);
        super.validate(string);
    }

    private String a(Object object) {
        List list = (List)object;
        return EmailAddressHelper.get().convertEmailAddressesToString(list, false);
    }

    @Override
    public boolean isAvailable(UserGroupInfo userGroup) {
        return SystemPermissionChecker.checkAccess(UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
    }
}

