/*
 * Decompiled with CFR 0.152.
 */
package com.inet.thread;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.http.servlet.SessionStore;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.thread.CountedReadWriteLock;
import com.inet.thread.ServerLock;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class ThreadUtils {
    private static final HashMap<Object, Semaphore> a = new HashMap();
    private static final HashMap<Object, CountedLock> b = new HashMap();
    private static final Object c = new Object();
    private static final ThreadMXBean d = ManagementFactory.getThreadMXBean();
    private static final boolean CPU_TIME = d.isCurrentThreadCpuTimeSupported();

    public static boolean stopThread(Thread thread) {
        if (thread != null && thread != Thread.currentThread()) {
            Logger logger = LogManager.getApplicationLogger();
            if (logger.isDebug()) {
                logger.debug("wait until '" + thread.getName() + "' thread dies from thread '" + Thread.currentThread().getName() + "'");
            }
            for (int i2 = 0; i2 < 1000; ++i2) {
                thread.interrupt();
                try {
                    thread.join(10L);
                    if (thread.isAlive()) continue;
                    if (logger.isDebug()) {
                        logger.debug("'" + thread.getName() + "' thread ended");
                    }
                    return true;
                }
                catch (InterruptedException interruptedException) {
                    logger.error(interruptedException);
                }
            }
            if (thread.isAlive()) {
                logger.error("thread '" + thread.getName() + "' is alive");
                try {
                    ThreadInfo threadInfo = d.getThreadInfo(thread.getId(), Integer.MAX_VALUE);
                    logger.error(threadInfo.toString());
                }
                catch (Throwable throwable) {
                    logger.error(throwable);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Semaphore getSemaphore(Object key) {
        HashMap<Object, Semaphore> hashMap = a;
        synchronized (hashMap) {
            Semaphore semaphore = a.get(key);
            if (semaphore == null) {
                semaphore = new Semaphore(key);
                a.put(key, semaphore);
            }
            ++semaphore.b;
            return semaphore;
        }
    }

    public static void checkInterruption() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    @Nonnull
    public static ServerLock getLock(Object key) {
        CountedLock countedLock = ThreadUtils.a(key);
        countedLock.lock();
        return () -> countedLock.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static CountedLock a(Object object) {
        CountedLock countedLock;
        HashMap<Object, CountedLock> hashMap = b;
        synchronized (hashMap) {
            countedLock = b.get(object);
            if (countedLock == null) {
                countedLock = new CountedLock(object);
                b.put(object, countedLock);
            }
            ++countedLock.b;
        }
        return countedLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ServerLock tryLock(Object key) {
        CountedLock countedLock = ThreadUtils.a(key);
        if (countedLock.tryLock()) {
            return () -> countedLock.close();
        }
        HashMap<Object, CountedLock> hashMap = b;
        synchronized (hashMap) {
            if (--countedLock.b == 0) {
                b.remove(key);
            }
        }
        return null;
    }

    @Nonnull
    public static ServerLock getReadLock(Object key) {
        return ThreadUtils.getReadLock(key, 0L);
    }

    @Nonnull
    public static ServerLock getReadLock(Object key, long timeout) {
        CountedReadWriteLock countedReadWriteLock = CountedReadWriteLock.getReadWriteLock(key, false, timeout);
        return () -> countedReadWriteLock.unlock(false);
    }

    @Nonnull
    public static ServerLock getWriteLock(Object key) {
        return ThreadUtils.getWriteLock(key, 0L);
    }

    @Nonnull
    public static ServerLock getWriteLock(Object key, long timeout) {
        CountedReadWriteLock countedReadWriteLock = CountedReadWriteLock.getReadWriteLock(key, true, timeout);
        return () -> countedReadWriteLock.unlock(true);
    }

    @Nullable
    public static ServerLock tryReadLock(Object key) {
        return ThreadUtils.a(key, false);
    }

    @Nullable
    public static ServerLock tryWriteLock(Object key) {
        return ThreadUtils.a(key, true);
    }

    @Nullable
    private static ServerLock a(Object object, boolean bl) {
        CountedReadWriteLock countedReadWriteLock = CountedReadWriteLock.tryReadWriteLockInstance(object, bl);
        if (countedReadWriteLock != null) {
            return () -> countedReadWriteLock.unlock(bl);
        }
        return null;
    }

    public static void threadDump(OutputStream out) throws IOException {
        ThreadUtils.threadDump(new UTF8StreamWriter(out));
    }

    public static void threadDump(Writer out) throws IOException {
        ThreadUtils.threadDump(out, (threadInfo, thread) -> true);
    }

    public static void threadDump(Writer out, BiFunction<ThreadInfo, @Nullable Thread, Boolean> filter) throws IOException {
        ThreadInfo[] threadInfoArray = d.dumpAllThreads(true, true);
        Thread[] threadArray = ThreadUtils.b();
        for (ThreadInfo threadInfo : threadInfoArray) {
            Thread thread = null;
            for (Thread thread2 : threadArray) {
                if (thread2.getId() != threadInfo.getThreadId()) continue;
                thread = thread2;
                break;
            }
            if (!filter.apply(threadInfo, thread).booleanValue()) continue;
            out.write(ThreadUtils.a(threadInfo, thread));
        }
    }

    private static String a(ThreadInfo threadInfo, @Nullable Thread thread) {
        LockInfo[] lockInfoArray;
        int n2;
        long l2;
        StringBuilder stringBuilder = new StringBuilder("\"" + threadInfo.getThreadName() + "\" #" + threadInfo.getThreadId());
        if (thread != null) {
            stringBuilder.append(' ').append(thread.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(thread)));
            if (thread.isDaemon()) {
                stringBuilder.append(" daemon");
            }
            stringBuilder.append(" prio=" + thread.getPriority());
        }
        long l3 = l2 = CPU_TIME ? d.getThreadCpuTime(threadInfo.getThreadId()) : -1L;
        if (l2 >= 0L) {
            stringBuilder.append(" cpu=").append(l2 /= 1000000L).append("ms");
        } else {
            l2 = 0L;
        }
        long l4 = threadInfo.getBlockedTime();
        long l5 = threadInfo.getWaitedTime();
        if (l4 >= 0L || l5 >= 0L) {
            stringBuilder.append(" elapsed=").append((double)(l2 + l4 + l5) / 1000.0).append("s");
        }
        stringBuilder.append(' ').append((Object)threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            stringBuilder.append(" on " + threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            stringBuilder.append(" owned by \"" + threadInfo.getLockOwnerName() + "\" Id=" + threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            stringBuilder.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            stringBuilder.append(" (in native)");
        }
        stringBuilder.append('\n');
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
            lockInfoArray = stackTraceElementArray[n2];
            stringBuilder.append("\tat " + lockInfoArray.toString());
            stringBuilder.append('\n');
            if (n2 == 0 && threadInfo.getLockInfo() != null) {
                Thread.State state = threadInfo.getThreadState();
                switch (state) {
                    case BLOCKED: {
                        stringBuilder.append("\t-  blocked on " + String.valueOf(threadInfo.getLockInfo()));
                        stringBuilder.append('\n');
                        break;
                    }
                    case WAITING: {
                        stringBuilder.append("\t-  waiting on " + String.valueOf(threadInfo.getLockInfo()));
                        stringBuilder.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        stringBuilder.append("\t-  timed waiting on " + String.valueOf(threadInfo.getLockInfo()));
                        stringBuilder.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo object : threadInfo.getLockedMonitors()) {
                if (object.getLockedStackDepth() != n2) continue;
                stringBuilder.append("\t-  locked " + String.valueOf(object));
                stringBuilder.append('\n');
            }
        }
        if (n2 < stackTraceElementArray.length) {
            stringBuilder.append("\t...");
            stringBuilder.append('\n');
        }
        if ((lockInfoArray = threadInfo.getLockedSynchronizers()).length > 0) {
            stringBuilder.append("\n\tNumber of locked synchronizers = " + lockInfoArray.length);
            stringBuilder.append('\n');
            for (LockInfo lockInfo : lockInfoArray) {
                stringBuilder.append("\t- " + String.valueOf(lockInfo));
                stringBuilder.append('\n');
            }
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    @Nonnull
    private static ThreadGroup a() {
        ThreadGroup threadGroup;
        ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
        while ((threadGroup = threadGroup2.getParent()) != null) {
            threadGroup2 = threadGroup;
        }
        return threadGroup2;
    }

    private static Thread[] b() {
        Thread[] threadArray;
        ThreadGroup threadGroup = ThreadUtils.a();
        int n2 = d.getThreadCount();
        int n3 = 0;
        while ((n3 = threadGroup.enumerate(threadArray = new Thread[n2 *= 2], true)) == n2) {
        }
        return Arrays.copyOf(threadArray, n3);
    }

    public static boolean isGuiThread() {
        return SessionStore.getHttpSession(false) != null || SessionStore.getHttpServletRequest() != null;
    }

    public static String getCallerName(int deep) {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[deep + 1];
        return stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName();
    }

    public static Class<?> getCallerClass(int deep) {
        StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        return stackWalker.walk(stream -> ((StackWalker.StackFrame)stream.skip(deep + 1).findFirst().get()).getDeclaringClass());
    }

    public static boolean hasLock(Object key) {
        CountedLock countedLock = ThreadUtils.a(key);
        try {
            boolean bl = countedLock.isHeldByCurrentThread();
            return bl;
        }
        finally {
            countedLock.a();
        }
    }

    public static long getCpuTime() {
        return CPU_TIME ? d.getCurrentThreadCpuTime() : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerLock getMultipleLocks(Collection<?> keys) {
        int n2 = 10;
        Object object = null;
        block7: while (n2 > 0) {
            --n2;
            final ArrayList<ServerLock> arrayList = new ArrayList<ServerLock>();
            try {
                Object object2 = c;
                synchronized (object2) {
                    for (Object object3 : keys) {
                        ServerLock serverLock = ThreadUtils.tryLock(object3);
                        if (serverLock != null) {
                            arrayList.add(serverLock);
                            continue;
                        }
                        object = object3;
                        for (ServerLock serverLock2 : arrayList) {
                            serverLock2.close();
                        }
                        c.wait(500L);
                        continue block7;
                    }
                }
                return new ServerLock(){

                    @Override
                    public void close() {
                        for (ServerLock serverLock : arrayList) {
                            serverLock.close();
                        }
                    }
                };
            }
            catch (Throwable throwable) {
                for (ServerLock serverLock : arrayList) {
                    serverLock.close();
                }
                throw (RuntimeException)ErrorCode.throwAny(throwable);
            }
        }
        try {
            ThreadUtils.threadDump(LogManager.getLogStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new IllegalStateException("Cannot acquire all locks of: " + keys.toString() + " failed for: " + String.valueOf(object));
    }

    static {
        try {
            if (CPU_TIME) {
                d.setThreadCpuTimeEnabled(true);
            }
            if (d.isThreadContentionMonitoringSupported()) {
                d.setThreadContentionMonitoringEnabled(true);
            }
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error(throwable);
        }
    }

    public static class Semaphore
    implements Closeable {
        private Object a;
        private int b;

        Semaphore(Object key) {
            this.a = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            HashMap<Object, Semaphore> hashMap = a;
            synchronized (hashMap) {
                if (--this.b == 0) {
                    a.remove(this.a);
                }
            }
        }
    }

    public static class CountedLock
    extends ReentrantLock
    implements Closeable {
        private Object a;
        private int b;

        private CountedLock(Object key) {
            super(false);
            this.a = key;
        }

        @Override
        public void close() {
            super.unlock();
            this.a();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a() {
            HashMap<Object, CountedLock> hashMap = b;
            synchronized (hashMap) {
                if (--this.b == 0) {
                    b.remove(this.a);
                }
            }
        }

        @Override
        public void unlock() {
            this.close();
        }
    }
}

