/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.utils;

import com.inet.search.utils.ShortenedLineHolder;
import com.inet.search.utils.UmlautsUtils;
import com.inet.shared.search.PositiveIntRange;
import java.util.List;

public class ShortenLineUtils {
    public static final String SPACE_MAKER = "\u2017";
    public static final char CHAR_SPACE_MAKER = '\u2017';
    public static final char ELLIPSIS_CHARACTER = '\u2026';

    public static String shortenIfNecessary(String textLine, boolean mayLeaveMoreCharactersThanAllowed, int maxNumberOfCharactersInResultLine) {
        if (textLine != null && textLine.length() > maxNumberOfCharactersInResultLine) {
            int n2;
            int n3 = n2 = mayLeaveMoreCharactersThanAllowed ? textLine.indexOf(32, maxNumberOfCharactersInResultLine) : textLine.lastIndexOf(32, maxNumberOfCharactersInResultLine);
            if (n2 == -1) {
                n2 = maxNumberOfCharactersInResultLine;
            }
            return textLine.substring(0, n2) + "\u2026";
        }
        return textLine;
    }

    public static ShortenedLineHolder shortenResultLine(String resultLine, List<String> matchedValues, int maxNumberOfCharactersInResultLine) {
        int n2;
        boolean bl;
        int n3;
        if (resultLine.length() <= maxNumberOfCharactersInResultLine) {
            return new ShortenedLineHolder(resultLine, null);
        }
        String string = UmlautsUtils.replaceUmlauts(resultLine);
        string = UmlautsUtils.flattenToAscii(string);
        string = string.toLowerCase();
        int n4 = 0;
        int n5 = 0;
        for (String string2 : matchedValues) {
            string2 = UmlautsUtils.replaceUmlauts(string2);
            n3 = ShortenLineUtils.getStartIndex(string, string2 = UmlautsUtils.flattenToAscii(string2));
            if (n3 < 0) continue;
            n4 = n4 == 0 ? n3 : Math.min(n4, n3);
            n5 = Math.max(n5, n3 + string2.length());
        }
        if (n5 == 0) {
            n5 = maxNumberOfCharactersInResultLine - 1;
        }
        boolean bl2 = bl = (n2 = n5 - n4) >= maxNumberOfCharactersInResultLine;
        if (bl) {
            n3 = n2 - maxNumberOfCharactersInResultLine;
            int n6 = (n4 += n3) + maxNumberOfCharactersInResultLine;
            int n7 = Math.min(string.length() - n6, 3);
            n6 = (n4 += n7) + maxNumberOfCharactersInResultLine;
            n5 = Math.min(n6, string.length());
        } else {
            PositiveIntRange positiveIntRange = new PositiveIntRange(n4, n5);
            PositiveIntRange positiveIntRange2 = ShortenLineUtils.a(string, positiveIntRange, maxNumberOfCharactersInResultLine);
            n4 = positiveIntRange2.getLeft();
            n5 = positiveIntRange2.getRight();
        }
        StringBuilder stringBuilder = new StringBuilder();
        resultLine = ShortenLineUtils.replaceWithPlaceMakers(resultLine);
        if (n4 != 0) {
            stringBuilder.append('\u2026');
        }
        stringBuilder.append(resultLine.substring(n4, n5));
        if (resultLine.length() != n5) {
            stringBuilder.append('\u2026');
        }
        String string3 = stringBuilder.toString().replace(SPACE_MAKER, "");
        return new ShortenedLineHolder(string3, new PositiveIntRange(n4, n5));
    }

    protected static int getStartIndex(String line, String matchedValue) {
        int n2 = line.indexOf(matchedValue);
        if (n2 == -1) {
            return -1;
        }
        if (n2 != 0) {
            while (n2 != -1 && !ShortenLineUtils.a(line.charAt(n2 - 1))) {
                int n3 = n2 + 1;
                if (n3 >= line.length()) {
                    return 0;
                }
                n2 = line.indexOf(matchedValue, n3);
            }
        }
        return n2;
    }

    private static boolean a(char c2) {
        String string = "\n\r\t\u00a0 .!?_<>\u00a7$%&,:#'\u00b4`^|+*~\"/\\()[]={};@-";
        return string.contains(String.valueOf(c2));
    }

    private static PositiveIntRange a(String string, PositiveIntRange positiveIntRange, int n2) {
        int n3;
        int n4;
        int n5 = n2 - positiveIntRange.getLength();
        if (n5 <= 0) {
            return positiveIntRange;
        }
        int n6 = positiveIntRange.getLeft();
        int n7 = string.length() - positiveIntRange.getRight();
        int n8 = n5 / 2;
        if (n6 <= n8) {
            n4 = 0;
            int n9 = positiveIntRange.getLeft() - n4;
            n3 = ShortenLineUtils.a(string, positiveIntRange.getRight(), n5 -= n9);
        } else if (n7 <= n8) {
            n3 = string.length();
            int n10 = string.length() - positiveIntRange.getRight();
            n4 = ShortenLineUtils.b(string, positiveIntRange.getLeft(), n5 -= n10);
        } else {
            n4 = ShortenLineUtils.b(string, positiveIntRange.getLeft(), n8);
            int n11 = positiveIntRange.getLeft() - n4;
            n3 = ShortenLineUtils.a(string, positiveIntRange.getRight(), n5 -= n11);
        }
        return new PositiveIntRange(n4, n3);
    }

    private static int a(String string, int n2, int n3) {
        boolean bl;
        int n4;
        int n5 = n2 + n3;
        int n6 = n4 = n5 > string.length() ? string.length() : n5;
        if (n4 == string.length() || ShortenLineUtils.a(string.charAt(n4))) {
            return n4;
        }
        String string2 = string.substring(n2, n4);
        int n7 = ShortenLineUtils.b(string2);
        boolean bl2 = n7 == -1;
        boolean bl3 = n7 == 0;
        boolean bl4 = bl = n7 > (n4 - n2) / 2;
        if (bl2 || bl3 || !bl) {
            return n4;
        }
        return n2 + n7;
    }

    private static int b(String string, int n2, int n3) {
        boolean bl;
        int n4;
        int n5 = n2 - n3;
        int n6 = n4 = n5 < 0 ? 0 : n5;
        if (n4 == 0 || ShortenLineUtils.a(string.charAt(n4 - 1))) {
            return n4;
        }
        String string2 = string.substring(n4, n2);
        int n7 = ShortenLineUtils.a(string2);
        boolean bl2 = n7 == -1;
        boolean bl3 = n7 == string2.length() - 1;
        boolean bl4 = bl = n7 < (n2 - n4) / 2;
        if (bl2 || bl3 || !bl) {
            return n4;
        }
        return n2 - n7;
    }

    private static int a(String string) {
        String string2 = "\n\r\t\u00a0 .!?_<>\u00a7$%&,:#'\u00b4`^|+*~\"/\\()[]={};@-";
        int n2 = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            String string3 = String.valueOf(string2.charAt(i2));
            int n3 = string.indexOf(string3);
            if (n3 == -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n2 == Integer.MAX_VALUE ? -1 : n2;
    }

    private static int b(String string) {
        String string2 = "\n\r\t\u00a0 .!?_<>\u00a7$%&,:#'\u00b4`^|+*~\"/\\()[]={};@-";
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            String string3 = String.valueOf(string2.charAt(i2));
            int n3 = string.lastIndexOf(string3);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public static String replaceWithPlaceMakers(String line) {
        line = line.replaceAll("\u00e4", "\u00e4\u2017").replaceAll("\u00f6", "\u00f6\u2017").replaceAll("\u00fc", "\u00fc\u2017").replaceAll("\u00df", "\u00df\u2017").replaceAll("\u00c4", "\u00c4\u2017").replaceAll("\u00dc", "\u00dc\u2017").replaceAll("\u00d6", "\u00d6\u2017");
        return line;
    }
}

