/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import com.inet.annotations.InternalApi;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import javax.annotation.Nonnull;

@InternalApi
public class FastByteArrayOutputStream
extends OutputStream {
    private LinkedList<byte[]> a;
    private byte @Nonnull [] b;
    private int c;
    private int d;

    public FastByteArrayOutputStream() {
        this(8192);
    }

    public FastByteArrayOutputStream(int blockSize) {
        this.b = new byte[blockSize];
    }

    public int size() {
        return this.d + this.c;
    }

    @Override
    public void close() {
    }

    public byte @Nonnull [] toByteArray() {
        byte[] byArray = new byte[this.size()];
        int n2 = 0;
        if (this.a != null) {
            for (byte[] byArray2 : this.a) {
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
            }
        }
        System.arraycopy(this.b, 0, byArray, n2, this.c);
        return byArray;
    }

    @Nonnull
    public String toString() {
        return new String(this.toByteArray());
    }

    @Nonnull
    public String toString(@Nonnull Charset charset) {
        return new String(this.toByteArray(), charset);
    }

    @Override
    public void write(int datum) {
        if (this.c == this.b.length) {
            this.addBuffer(1);
        }
        this.b[this.c++] = (byte)datum;
    }

    @Override
    public void write(byte[] b2) {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        if (offset < 0 || offset + length > data.length || length < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.b.length;
        if (this.c + length > n2) {
            int n3;
            do {
                if (this.c == n2) {
                    this.addBuffer(length);
                    n2 = this.b.length;
                }
                if (length < (n3 = n2 - this.c)) {
                    n3 = length;
                }
                System.arraycopy(data, offset, this.b, this.c, n3);
                offset += n3;
                this.c += n3;
            } while ((length -= n3) > 0);
        } else {
            System.arraycopy(data, offset, this.b, this.c, length);
            this.c += length;
        }
    }

    public void writeTo(@Nonnull OutputStream out) throws IOException {
        if (this.a != null) {
            for (byte[] byArray : this.a) {
                out.write(byArray, 0, byArray.length);
            }
        }
        out.write(this.b, 0, this.c);
    }

    protected void addBuffer(int minNeeded) {
        if (this.a == null) {
            this.a = new LinkedList();
        }
        this.a.addLast(this.b);
        this.d += this.b.length;
        int n2 = this.b.length << 1;
        if (n2 < minNeeded) {
            n2 = minNeeded;
        }
        this.b = new byte[n2];
        this.c = 0;
    }

    public void reset() {
        this.c = 0;
        this.d = 0;
        this.a = null;
    }
}

