/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.layout;

import com.inet.font.CharMetricsProvider;
import com.inet.font.EudcFontHandler;
import com.inet.font.FontPool;
import com.inet.font.layout.FontLayout;
import com.inet.lib.list.CharIntMapCE;
import com.inet.shared.utils.MemoryStream;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public class JavaFontLayout
extends FontLayout
implements CharMetricsProvider {
    private static final FontRenderContext a = new FontRenderContext(null, false, true);
    private static final FontRenderContext b = new FontRenderContext(null, false, false);
    private final boolean c;
    private transient Font d;
    private final int e;
    private final int f;
    private final int g;
    private boolean h;
    private int i;
    private static final int START_OF_SYMBOLIC_CHAR_INTERVAL = 61440;
    private final CharIntMapCE j = new CharIntMapCE(63, -1);
    private final char[] k = new char[1];

    public JavaFontLayout(Font font, String name, int sizeTwips) {
        this(font, name, sizeTwips, true);
    }

    public JavaFontLayout(Font font, String name, int sizeTwips, boolean isFractional) {
        super(name, font.getStyle(), sizeTwips);
        this.d = font;
        FontMetrics fontMetrics = FontPool.getFontMetrics(font);
        this.f = fontMetrics.getDescent() * 15;
        this.g = fontMetrics.getLeading() * 15;
        this.e = fontMetrics.getAscent() * 15;
        this.h = JavaFontLayout.a(name);
        if (this.h) {
            this.i = 61440;
        }
        this.c = isFractional;
        float f2 = font.getItalicAngle();
        if (f2 > 0.0f) {
            int n2 = (int)Math.ceil((float)this.e * f2 / 2.0f);
            if ((this.getStyle() & 2) > 0 && f2 == font.deriveFont(0).getItalicAngle()) {
                n2 += this.getItalicIndent();
            }
            this.setItalicIndent(n2);
        }
    }

    @Override
    public final int charWidth(int c2) {
        int n2 = this.j.get(c2);
        if (n2 == -1) {
            if (EudcFontHandler.hasEudcFont() && EudcFontHandler.canBeDisplyedByEUDC(c2)) {
                n2 = EudcFontHandler.getCharWidth(c2, this.getSizeTwips());
            } else {
                this.k[0] = (char)(c2 | this.i);
                n2 = (int)(this.getFont().getStringBounds(this.k, 0, 1, this.a()).getWidth() * 15.0 + 0.5);
            }
            this.j.put((char)c2, n2);
        }
        return n2;
    }

    @Override
    public int getWidth(char c2) {
        return this.charWidth(c2) * 1000 / this.getSizeTwips();
    }

    @Override
    public final int getAscent() {
        return this.e;
    }

    @Override
    public final int getDescent() {
        return this.f;
    }

    @Override
    public final int getLeading() {
        int n2 = this.getExtraLeading();
        if (n2 != 0) {
            return this.g + (this.e + this.f) * n2 / 100;
        }
        return this.g;
    }

    public String toString() {
        return super.toString() + ";" + String.valueOf(this.getFont()) + ";" + String.valueOf(this.j);
    }

    @Override
    public int stringWidthSpecial(String text) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        return (int)(new TextLayout(text, this.getFont(), this.a()).getAdvance() * 15.0f + 0.5f);
    }

    private FontRenderContext a() {
        return this.c ? a : b;
    }

    public static FontRenderContext getFontRenderContext() {
        return a;
    }

    public Font getFont() {
        if (this.d == null) {
            this.d = new Font(this.getName(), this.getStyle(), this.getSizePoints());
        }
        return this.d;
    }

    public MemoryStream getWidthsStream() {
        int n2 = this.getSizeTwips();
        MemoryStream memoryStream = new MemoryStream();
        int n3 = 0;
        for (int i2 = 0; i2 <= 223; ++i2) {
            char c2 = (char)(32 + i2);
            int n4 = this.charWidth(c2) * 1000 / n2;
            if (n4 < 0) {
                n4 = 0;
            }
            memoryStream.write(32);
            memoryStream.writeIntAsString(n4);
            if (n3 == 15) {
                n3 = 0;
                memoryStream.write(10);
                continue;
            }
            ++n3;
        }
        return memoryStream;
    }

    private static boolean a(String string) {
        return string.toLowerCase().equals("webdings") || string.toLowerCase().startsWith("wingdings") || string.toLowerCase().equals("symbol") || string.toLowerCase().startsWith("bookshelf symbol");
    }

    @Override
    public boolean isSymbolCodePage() {
        return this.h;
    }

    @Override
    public boolean canDisplay(char ch) {
        if (this.d.canDisplay(ch)) {
            return true;
        }
        return EudcFontHandler.hasEudcFont() && EudcFontHandler.canBeDisplyedByEUDC(ch);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JavaFontLayout) {
            JavaFontLayout javaFontLayout = (JavaFontLayout)obj;
            return javaFontLayout.getSizeTwips() == this.getSizeTwips() && javaFontLayout.getStyle() == this.getStyle() && javaFontLayout.getName().equals(this.getName());
        }
        return false;
    }
}

