/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.converter.ConverterPlugin;
import org.freehep.graphics2d.VectorGraphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeHepConverter
implements ConverterPlugin {
    private final Constructor<?> streamConst;

    FreeHepConverter(Class<?> converterClass) throws NoSuchMethodException {
        this.streamConst = converterClass.getConstructor(OutputStream.class, Dimension.class);
    }

    @Override
    public Dimension convert(MathBase base, OutputStream outStream) throws IOException {
        Properties p = new Properties();
        try {
            VectorGraphics temp = (VectorGraphics)this.streamConst.newInstance(new ByteArrayOutputStream(), new Dimension(1, 1));
            Dimension size = new Dimension((int)Math.ceil(base.getWidth((Graphics2D)temp)), (int)Math.ceil(base.getHeight((Graphics2D)temp)));
            VectorGraphics g = (VectorGraphics)this.streamConst.newInstance(outStream, size);
            g.setProperties(p);
            g.startExport();
            base.paint((Graphics2D)g);
            g.endExport();
            return size;
        }
        catch (InstantiationException e) {
            throw new IOException();
        }
        catch (IllegalAccessException e) {
            throw new IOException();
        }
        catch (InvocationTargetException e) {
            throw new IOException();
        }
    }
}

