/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElementFactory;
import net.sourceforge.jeuclid.elements.generic.DocumentElement;
import net.sourceforge.jeuclid.elements.presentation.table.Maligngroup;
import net.sourceforge.jeuclid.elements.presentation.table.Malignmark;
import net.sourceforge.jeuclid.elements.presentation.table.Mlabeledtr;
import net.sourceforge.jeuclid.elements.presentation.table.Mtd;
import net.sourceforge.jeuclid.elements.support.attributes.DOMAttributeMap;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMBuilder {
    private DocumentElement rootElement;
    private MathBase mbase;

    public DOMBuilder(Node node, MathBase mathBase) {
        Element documentElement;
        if (node instanceof Document) {
            documentElement = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            documentElement = (Element)node;
        } else if (node instanceof DocumentFragment) {
            Node child = node.getFirstChild();
            if (!(child instanceof Element)) {
                throw new IllegalArgumentException("Expected DocumentFragment with Element child");
            }
            documentElement = (Element)child;
        } else {
            throw new IllegalArgumentException("Unsupported node: " + node + ". Expected either Document, Element or DocumentFragment");
        }
        this.mbase = mathBase;
        this.rootElement = new DocumentElement(this.mbase);
        mathBase.setRootElement(this.rootElement);
        this.traverse(documentElement, this.rootElement, null);
        this.rootElement.fireChangeForSubTree();
    }

    public DocumentElement getMathRootElement() {
        return this.rootElement;
    }

    private void traverse(Node node, Node parent, Mtd alignmentScope) {
        if (node.getNodeType() != 1) {
            return;
        }
        String tagname = node.getNodeName();
        int posSeparator = -1;
        posSeparator = tagname.indexOf(":");
        if (posSeparator >= 0) {
            tagname = tagname.substring(posSeparator + 1);
        }
        DOMAttributeMap attributes = new DOMAttributeMap(node.getAttributes());
        AbstractJEuclidElement element = (AbstractJEuclidElement)JEuclidElementFactory.elementFromName(tagname, attributes, this.mbase);
        if (tagname.equals("mtd")) {
            alignmentScope = (Mtd)element;
        } else if (tagname.equals("mstyle")) {
            if (attributes.hasAttribute("scriptsizemultiplier")) {
                float scrm = Float.valueOf(attributes.getString("scriptsizemultiplier", String.valueOf(element.getScriptSizeMultiplier()))).floatValue();
                element.setScriptSizeMultiplier(scrm);
            }
        } else if (tagname.equals("maligngroup")) {
            if (alignmentScope != null) {
                alignmentScope.addAlignGroupElement((Maligngroup)element);
            }
        } else if (tagname.equals("malignmark") && alignmentScope != null) {
            alignmentScope.addAlignMarkElement((Malignmark)element);
        }
        if (parent instanceof Mlabeledtr) {
            if (((Mlabeledtr)parent).labelIgnored) {
                parent.appendChild(element);
            } else {
                ((Mlabeledtr)parent).labelIgnored = true;
            }
        } else {
            parent.appendChild(element);
        }
        NodeList childs = node.getChildNodes();
        Mtd prevScope = null;
        if (tagname.equals("mtd")) {
            prevScope = alignmentScope;
            alignmentScope = (Mtd)element;
        }
        for (int i = 0; i < childs.getLength(); ++i) {
            String entityValue;
            Node childNode = childs.item(i);
            short childNodeType = childNode.getNodeType();
            if (childNodeType == 1) {
                this.traverse(childNode, element, alignmentScope);
                continue;
            }
            if (childNodeType == 3) {
                element.addText(childNode.getNodeValue());
                continue;
            }
            if (childNodeType != 5 || !childNode.hasChildNodes() || (entityValue = childNode.getFirstChild().getNodeValue()) == null) continue;
            element.addText(entityValue);
        }
        if (prevScope != null) {
            alignmentScope = prevScope;
        }
    }
}

