/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.application.currenttime;

import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner.CombinedFile;
import com.inet.http.PluginServlet;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.IModule;

/**
 * Server plugin to register the extension
 */
@PluginInfo( //
                id = "application.currenttime", //
                dependencies = "remotegui", //
                group = "samples", //
                version = "25.10.217", //
                icon = "com/inet/application/currenttime/icon_48.png" //
)
public class SampleApplicationServerPlugin implements ServerPlugin {

    // Under this unique! name your application specific javascript content is served.
    static final String APPLICATION_SPECIFIC_JS = "sampleapplication.app.js";

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        // register the module, this is required
        spm.register( IModule.class, new SampleApplicationModule() );
        spm.register( PluginServlet.class, new SampleApplicationHandler() );

        // register optional additional java script
        CombinedFile combinedFile = new CombinedFile( "application/x-javascript; charset=utf-8" );
        // add at least one javascript resource
        combinedFile.add( getClass(), "sampleapplication.js" );
        spm.register( CombinedFileDescription.class, new CombinedFileDescription( "remotegui", APPLICATION_SPECIFIC_JS, combinedFile ) );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
