package com.inet.samples.session.datasource;

import com.inet.logging.LogManager;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;

import jakarta.servlet.Filter;

/**
 * Server plugin which registers a jakarta.servlet.Filter that accept injected user data to create a session scope datasource. This
 * can be used if the users are already login in a frontend server and you want use the same account in the backend.
 */
@PluginInfo( //
id = "sessiondatasource",// 
dependencies = "reporting", //
group = "samples", //
version = "25.10.217", //
icon = "com/inet/samples/session/datasource/sessiondata_48.png" //
)
public class SessionDatasourcePlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        try {
            spm.register( Filter.class, new UserInjection() );
        } catch( Exception ex ) {
            LogManager.getConfigLogger().error( ex );
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
