/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.ColumnDescription;
import com.inet.odbc.OdbcStatement;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class OdbcResultSetMetaData
implements ResultSetMetaData {
    private final ColumnDescription[] columns;

    OdbcResultSetMetaData(int columnCount, OdbcStatement statement) {
        this.columns = new ColumnDescription[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.columns[i] = new ColumnDescription((short)(i + 1), statement);
        }
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.length;
    }

    ColumnDescription getColumn(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex <= this.columns.length) {
            return this.columns[columnIndex - 1];
        }
        throw new SQLException("Invalid column number (" + columnIndex + "). A number between 1 and " + this.columns.length + " is valid.", "S1002");
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getColumn(column).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumn(column).isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getColumn(column).isSearchable();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getColumn(column).isCurrency();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumn(column).isNullable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumn(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumn(column).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn(column).getLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getColumn(column).getSchemaName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumn(column).getTableName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumn(column).getCatalogName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumn(column).getJdbcType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumn(column).getTypeString();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.getColumn(column).isReadOnly();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.getColumn(column).isWritable();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.getColumn(column).isDefinitelyWritable();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int sqlType = this.getColumnType(column);
        switch (sqlType) {
            case 2: 
            case 3: {
                return BigDecimal.class.getName();
            }
            case -7: {
                return Boolean.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 7: {
                return Float.class.getName();
            }
            case 6: 
            case 8: {
                return Double.class.getName();
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class.getName();
            }
            case 91: {
                return Date.class.getName();
            }
            case 92: {
                return Time.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
        }
        return String.class.getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException(this.getClass().getName() + " does not implements " + iface.getName() + ".", "01000");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }
}

