/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.spi.events;

import com.inet.annotations.JsonData;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.lib.util.NetworkFunctions;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.persistence.spi.PersistenceLogger;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public class NodeCounter
implements PersistenceListener<NodeStateEvent> {
    private MemoryStoreMap<String, String> map = new MemoryStoreMap(300, true);
    private String localHost;
    private final Persistence persistence;
    private DefaultTimerTask timer;
    private final List<PersistenceListener<Boolean>> listeners;

    public NodeCounter(@Nonnull Persistence persistence) {
        this.map.addTimeoutListener((K, V) -> NodeCounter.revalidateLicense());
        this.timer = new DefaultTimerTask(){

            public void runImpl() throws Throwable {
                NodeStateEvent event = new NodeStateEvent();
                NodeCounter.this.localHost = event.node = NetworkFunctions.getLocalHostName();
                NodeCounter.this.map.put((Object)NodeCounter.this.localHost, (Object)NodeCounter.this.localHost);
                NodeCounter.this.persistence.sendEvent((Object)event);
            }
        };
        this.listeners = new CopyOnWriteArrayList<PersistenceListener<Boolean>>();
        this.persistence = persistence;
        DefaultTimer.getInstance().schedule(this.timer, 0L, 60000L);
    }

    public void onShutdown() {
        try {
            this.timer.cancel();
            NodeStateEvent event = new NodeStateEvent();
            event.node = NetworkFunctions.getLocalHostName();
            event.shutdown = true;
            this.persistence.sendEvent((Object)event);
        }
        catch (Exception ex) {
            PersistenceLogger.LOGGER.error((Throwable)ex);
        }
    }

    public int getNodeCount() {
        return this.map.size();
    }

    public void eventReceived(@Nonnull NodeStateEvent event) {
        block4: {
            block3: {
                if (!event.shutdown) break block3;
                if (Objects.equals(this.localHost, event.node)) break block4;
                this.map.remove((Object)event.node);
                NodeCounter.revalidateLicense();
                for (PersistenceListener<Boolean> listener : this.listeners) {
                    listener.eventReceived((Object)false);
                }
                break block4;
            }
            String oldValue = (String)this.map.put((Object)event.node, (Object)event.node);
            if (oldValue == null) {
                this.timer.run();
                for (PersistenceListener<Boolean> listener : this.listeners) {
                    listener.eventReceived((Object)true);
                }
            }
        }
    }

    private static void revalidateLicense() {
        ForkJoinPool.commonPool().execute(() -> {
            LicenseInfo license = ConfigKeyParser.getCurrent();
            if (!license.isValid()) {
                ConfigKeyParser.reset();
            }
        });
    }

    public void addListener(@Nonnull PersistenceListener<Boolean> listener) {
        this.listeners.add(listener);
    }

    @JsonData
    static class NodeStateEvent {
        private String node;
        private boolean shutdown;

        NodeStateEvent() {
        }
    }
}

