/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.lib.io.ChunkedInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@InternalApi
public class LazyZipInputStream
extends ChunkedInputStream {
    private byte[] a = new byte[8192];
    private FastByteArrayOutputStream b = new FastByteArrayOutputStream();
    private ZipOutputStream c = new ZipOutputStream(this.b);
    private Path d;
    private Iterator<?> e;
    private FileInputStream f;

    public LazyZipInputStream(File dir) throws IOException {
        this(dir.toPath());
    }

    public LazyZipInputStream(Path dir) throws IOException {
        this(dir, Files.walk(dir, new FileVisitOption[0]).iterator());
    }

    public LazyZipInputStream(File base, Iterator<File> input) throws IOException {
        this.d = base.toPath();
        this.e = input;
    }

    public LazyZipInputStream(Path base, Iterator<Path> input) throws IOException {
        this.d = base;
        this.e = input;
    }

    @Override
    protected byte[] nextChunk() {
        try {
            if (this.c != null) {
                do {
                    if (this.f == null) {
                        Path path = null;
                        File file = null;
                        while (this.e.hasNext()) {
                            Object obj = this.e.next();
                            if (obj instanceof File) {
                                file = (File)obj;
                                path = file.toPath();
                            } else {
                                path = (Path)obj;
                                file = path.toFile();
                            }
                            if (!file.isDirectory()) break;
                            path = null;
                        }
                        if (path != null) {
                            this.c.putNextEntry(new ZipEntry(this.d.relativize(path).toString()));
                            this.f = new FileInputStream(file);
                            continue;
                        }
                        this.c.close();
                        this.c = null;
                        break;
                    }
                    int n2 = this.f.read(this.a);
                    if (n2 > 0) {
                        this.c.write(this.a, 0, n2);
                        continue;
                    }
                    this.f.close();
                    this.f = null;
                    this.c.closeEntry();
                } while (this.b.size() == 0);
                byte[] byArray = this.b.toByteArray();
                this.b.reset();
                return byArray;
            }
        }
        catch (IOException iOException) {
            ErrorCode.throwAny(iOException);
        }
        return null;
    }
}

