/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import com.inet.annotations.InternalApi;
import com.inet.logging.LogManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

@InternalApi
public class BOMEncodingDetector {
    @Nonnull
    public static Charset detectEncodingFromBOM(@Nonnull InputStream input) {
        try {
            input.mark(4);
            switch (input.read()) {
                case 239: {
                    if (input.read() != 187 || input.read() != 191) break;
                    return StandardCharsets.UTF_8;
                }
                case 254: {
                    if (input.read() != 255) break;
                    return StandardCharsets.UTF_16BE;
                }
                case 255: {
                    if (input.read() != 254) break;
                    input.mark(2);
                    if (input.read() == 0 && input.read() == 0) {
                        return Charset.forName("UTF-32LE");
                    }
                    input.reset();
                    return StandardCharsets.UTF_16LE;
                }
                case 0: {
                    if (input.read() != 0 || input.read() != 254 || input.read() != 255) break;
                    return Charset.forName("UTF-32BE");
                }
            }
            input.reset();
        }
        catch (IOException iOException) {
            LogManager.getApplicationLogger().warn(iOException);
        }
        return StandardCharsets.UTF_8;
    }
}

