/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.unicode;

import com.inet.font.unicode.IUnicodeRange;

public final class UnicodeCharBlock
extends Enum<UnicodeCharBlock>
implements IUnicodeRange {
    public static final /* enum */ UnicodeCharBlock BASIC_LATIN = new UnicodeCharBlock(0, "Basic Latin", 0, 127);
    public static final /* enum */ UnicodeCharBlock LATIN_1_SUPPLEMENT = new UnicodeCharBlock(1, "Latin-1 Supplement", 128, 255);
    public static final /* enum */ UnicodeCharBlock LATIN_EXTENDED_A = new UnicodeCharBlock(2, "Latin Extended-A", 256, 383);
    public static final /* enum */ UnicodeCharBlock LATIN_EXTENDED_B = new UnicodeCharBlock(3, "Latin Extended-B", 384, 591);
    public static final /* enum */ UnicodeCharBlock IPA_EXTENSION = new UnicodeCharBlock(4, "IPA Extensions + Phonetic Supplement", 592, 687);
    public static final /* enum */ UnicodeCharBlock SPACING_MODIFIER_LETTERS = new UnicodeCharBlock(5, "Spacing Modifier Letters", 688, 767);
    public static final /* enum */ UnicodeCharBlock COMBINING_DIACRITICAL_MARKS = new UnicodeCharBlock(6, "Combining Diacritical Marks and Supplement", 768, 879);
    public static final /* enum */ UnicodeCharBlock GREEK = new UnicodeCharBlock(7, "Greek", 880, 1023);
    public static final /* enum */ UnicodeCharBlock CYRILLIC = new UnicodeCharBlock(9, "Cyrillic", 1024, 1279);
    public static final /* enum */ UnicodeCharBlock CYRILLIC_SUPPLEMENT = new UnicodeCharBlock(9, 1, "Cyrillic Supplement", 1280, 1327);
    public static final /* enum */ UnicodeCharBlock ARMENIAN = new UnicodeCharBlock(10, "Armenian", 1328, 1423);
    public static final /* enum */ UnicodeCharBlock HEBREW = new UnicodeCharBlock(11, "Hebrew", 1488, 1514);
    public static final /* enum */ UnicodeCharBlock ARABIC = new UnicodeCharBlock(13, "Arabic", 1536, 1791);
    public static final /* enum */ UnicodeCharBlock SYRIAC = new UnicodeCharBlock(71, "Syriac", 1792, 1871);
    public static final /* enum */ UnicodeCharBlock ARABIC_SUPPLEMENT = new UnicodeCharBlock(13, 1, "Arabic Supplement", 1872, 1919);
    public static final /* enum */ UnicodeCharBlock THAANA = new UnicodeCharBlock(72, "Thaana", 1920, 1983);
    public static final /* enum */ UnicodeCharBlock NKO = new UnicodeCharBlock(14, "NKo", 1984, 2047);
    public static final /* enum */ UnicodeCharBlock DEVANAGARI = new UnicodeCharBlock(15, "Devanagari", 2304, 2431);
    public static final /* enum */ UnicodeCharBlock BENGALI = new UnicodeCharBlock(16, "Bengali", 2432, 2559);
    public static final /* enum */ UnicodeCharBlock GURMUKHI = new UnicodeCharBlock(17, "Gurmukhi", 2560, 2687);
    public static final /* enum */ UnicodeCharBlock GUJARATI = new UnicodeCharBlock(18, "Gujarati", 2688, 2815);
    public static final /* enum */ UnicodeCharBlock ORIYA = new UnicodeCharBlock(19, "Oriya", 2816, 2943);
    public static final /* enum */ UnicodeCharBlock TAMIL = new UnicodeCharBlock(20, "Tamil", 2944, 3071);
    public static final /* enum */ UnicodeCharBlock TELUGU = new UnicodeCharBlock(21, "Telugu", 3072, 3199);
    public static final /* enum */ UnicodeCharBlock KANNADA = new UnicodeCharBlock(22, "Kannada", 3200, 3327);
    public static final /* enum */ UnicodeCharBlock MALAYALAM = new UnicodeCharBlock(23, "Malayalam", 3328, 3455);
    public static final /* enum */ UnicodeCharBlock SINHALA = new UnicodeCharBlock(73, "Sinhala", 3456, 3583);
    public static final /* enum */ UnicodeCharBlock THAI = new UnicodeCharBlock(24, "Thai", 3584, 3711);
    public static final /* enum */ UnicodeCharBlock LAO = new UnicodeCharBlock(25, "Lao", 3712, 3839);
    public static final /* enum */ UnicodeCharBlock TIBETAN = new UnicodeCharBlock(70, "Tibetan", 3840, 4095);
    public static final /* enum */ UnicodeCharBlock MYANMAR = new UnicodeCharBlock(74, "Myanmar", 4096, 4255);
    public static final /* enum */ UnicodeCharBlock GEORGIAN = new UnicodeCharBlock(26, "Georgian and Supplement", 4256, 4351);
    public static final /* enum */ UnicodeCharBlock HANGUL_JAMO = new UnicodeCharBlock(28, "Hangul Jamo", 4352, 4607);
    public static final /* enum */ UnicodeCharBlock ETHIOPIC = new UnicodeCharBlock(75, "Ethiopic", 4608, 4991);
    public static final /* enum */ UnicodeCharBlock ETHIOPIC_SUPPLEMENT = new UnicodeCharBlock(75, 1, "Ethiopic Supplement", 4992, 5023);
    public static final /* enum */ UnicodeCharBlock CHEROKEE = new UnicodeCharBlock(76, "Cherokee", 5024, 5119);
    public static final /* enum */ UnicodeCharBlock CANADIAN_ABORIGIANAL = new UnicodeCharBlock(77, "Unified Canadian Aboriginal Syllabics", 5120, 5759);
    public static final /* enum */ UnicodeCharBlock OGHAM = new UnicodeCharBlock(78, "Ogham", 5760, 5791);
    public static final /* enum */ UnicodeCharBlock RUNIC = new UnicodeCharBlock(79, "Runic", 5792, 5887);
    public static final /* enum */ UnicodeCharBlock TAGALOG = new UnicodeCharBlock(84, "Tagalog Hanunoo Buhid Tagbanwa", 5888, 5919);
    public static final /* enum */ UnicodeCharBlock HANUNOO = new UnicodeCharBlock(84, 1, "Hanunoo", 5920, 5951);
    public static final /* enum */ UnicodeCharBlock BUHID = new UnicodeCharBlock(84, 2, "Buhid", 5952, 5983);
    public static final /* enum */ UnicodeCharBlock TAGBANWA = new UnicodeCharBlock(84, 3, "Tagbanwa", 5984, 6015);
    public static final /* enum */ UnicodeCharBlock KHMER = new UnicodeCharBlock(80, "Khmer", 6016, 6143);
    public static final /* enum */ UnicodeCharBlock MONGOLIAN = new UnicodeCharBlock(81, "Mongolian", 6144, 6319);
    public static final /* enum */ UnicodeCharBlock LIMBU = new UnicodeCharBlock(93, "Limbu", 6400, 6479);
    public static final /* enum */ UnicodeCharBlock TAI_LE = new UnicodeCharBlock(94, "Tai Le", 6480, 6527);
    public static final /* enum */ UnicodeCharBlock NEW_TAI_LUE = new UnicodeCharBlock(95, "New Tai Lue", 6528, 6623);
    public static final /* enum */ UnicodeCharBlock KHMER_SYMBOLS = new UnicodeCharBlock(80, 1, "Khmer Symbols", 6624, 6655);
    public static final /* enum */ UnicodeCharBlock BUGINESE = new UnicodeCharBlock(96, "Buginese", 6656, 6687);
    public static final /* enum */ UnicodeCharBlock BALINESE = new UnicodeCharBlock(27, "Balinese", 6912, 7039);
    public static final /* enum */ UnicodeCharBlock SUNDANESE = new UnicodeCharBlock(112, "Sundanese", 7040, 7103);
    public static final /* enum */ UnicodeCharBlock LEPCHA = new UnicodeCharBlock(113, "Lepcha", 7168, 7247);
    public static final /* enum */ UnicodeCharBlock OL_CHIKI = new UnicodeCharBlock(114, "Ol Chiki", 7248, 7295);
    public static final /* enum */ UnicodeCharBlock PHONETIC_EXT = new UnicodeCharBlock(4, 1, "Phonetic Extensions", 7424, 7551);
    public static final /* enum */ UnicodeCharBlock PHONETIC_EXTENSIONS_SUPPLEMENT = new UnicodeCharBlock(4, 2, "Phonetic Extensions Supplement", 7552, 7615);
    public static final /* enum */ UnicodeCharBlock COMBINING_DIACRITICAL_MARKS_SUPPLEMENT = new UnicodeCharBlock(6, 1, "Combining Diacritical Marks Supplement", 7616, 7679);
    public static final /* enum */ UnicodeCharBlock LATIN_EXT_ADDIT = new UnicodeCharBlock(29, "Latin Extended Additional and Extended-C and Extended-D", 7680, 7935);
    public static final /* enum */ UnicodeCharBlock GREEK_EXT = new UnicodeCharBlock(30, "Greek Extended", 7936, 8191);
    public static final /* enum */ UnicodeCharBlock GENERAL_PUNCT = new UnicodeCharBlock(31, "General Punctuation and Supplemental", 8192, 8303);
    public static final /* enum */ UnicodeCharBlock SUPER_SUBSCRIPTS = new UnicodeCharBlock(32, "Superscripts And Subscripts", 8304, 8351);
    public static final /* enum */ UnicodeCharBlock CURRENCY_SYMBOLS = new UnicodeCharBlock(33, "Currency Symbols", 8352, 8399);
    public static final /* enum */ UnicodeCharBlock COMBINING_DIACR_MARKS_FOR_SYMBOLS = new UnicodeCharBlock(34, "Combining Diacritical Marks For Symbols", 8400, 8447);
    public static final /* enum */ UnicodeCharBlock LETTERLIKE_SYMBOLS = new UnicodeCharBlock(35, "Letterlike Symbols", 8448, 8527);
    public static final /* enum */ UnicodeCharBlock NUMBER_FORMS = new UnicodeCharBlock(36, "Number Forms", 8528, 8591);
    public static final /* enum */ UnicodeCharBlock ARROWS = new UnicodeCharBlock(37, "Arrows and Suppl-A and Suppl-B and Miscell", 8592, 8703);
    public static final /* enum */ UnicodeCharBlock MATHEM_OPERATORS = new UnicodeCharBlock(38, "Mathematical Operators", 8704, 8959);
    public static final /* enum */ UnicodeCharBlock MISCELLANEOUS_TECHN = new UnicodeCharBlock(39, "Miscellaneous Technical", 8960, 9215);
    public static final /* enum */ UnicodeCharBlock CONTROL_PICTURES = new UnicodeCharBlock(40, "Control Pictures", 9216, 9279);
    public static final /* enum */ UnicodeCharBlock OPTICAL_CHAR_RECOGNITION = new UnicodeCharBlock(41, "Optical Character Recognition", 9280, 9311);
    public static final /* enum */ UnicodeCharBlock ENCLOSED_ALPHANUMERICS = new UnicodeCharBlock(42, "Enclosed Alphanumerics", 9312, 9471);
    public static final /* enum */ UnicodeCharBlock BOX_DRAWING = new UnicodeCharBlock(43, "Box Drawing", 9472, 9599);
    public static final /* enum */ UnicodeCharBlock BLOCK_ELEMENTS = new UnicodeCharBlock(44, "Block Elements", 9600, 9631);
    public static final /* enum */ UnicodeCharBlock GEOMETRIC_CHAPES = new UnicodeCharBlock(45, "Geometric Shapes", 9632, 9727);
    public static final /* enum */ UnicodeCharBlock MISCELLANEOUS_SYMBOLS = new UnicodeCharBlock(46, "Miscellaneous Symbols", 9728, 9983);
    public static final /* enum */ UnicodeCharBlock DINGBATS = new UnicodeCharBlock(47, "Dingbats", 9984, 10175);
    public static final /* enum */ UnicodeCharBlock MISC_MATH_SYMBOLS_A = new UnicodeCharBlock(38, 2, "Miscellaneous Mathematical Symbols-A", 10176, 10223);
    public static final /* enum */ UnicodeCharBlock SUPPLEM_ARROWS_A = new UnicodeCharBlock(37, 1, "Supplemental Arrows-A", 10224, 10239);
    public static final /* enum */ UnicodeCharBlock BRAILL = new UnicodeCharBlock(82, "Braille Patterns", 10240, 10495);
    public static final /* enum */ UnicodeCharBlock SUPPLEM_ARROWS_B = new UnicodeCharBlock(37, 2, "Supplemental Arrows-B", 10496, 10623);
    public static final /* enum */ UnicodeCharBlock MISC_MATH_SYMBOLS_B = new UnicodeCharBlock(38, 3, "Miscellaneous Mathematical Symbols-B", 10624, 10751);
    public static final /* enum */ UnicodeCharBlock SUPPL_MATHEM_OPERATORS = new UnicodeCharBlock(38, 1, "Supplemental Mathematical Operators", 10752, 11007);
    public static final /* enum */ UnicodeCharBlock MISC_SYMBOLS_ANDARROWS = new UnicodeCharBlock(37, 3, "Miscellaneous Symbols and Arrows", 11008, 11263);
    public static final /* enum */ UnicodeCharBlock GLAGOLITIC = new UnicodeCharBlock(97, "Glagolitic", 11264, 11359);
    public static final /* enum */ UnicodeCharBlock LATIN_EXT_C = new UnicodeCharBlock(29, 1, "Latin Extended-C", 11360, 11391);
    public static final /* enum */ UnicodeCharBlock COPTIC = new UnicodeCharBlock(8, "Coptic", 11392, 11519);
    public static final /* enum */ UnicodeCharBlock GEORGIAN_SUPPLEMENT = new UnicodeCharBlock(26, 1, "Georgian Supplement", 11520, 11567);
    public static final /* enum */ UnicodeCharBlock TIFINAGH = new UnicodeCharBlock(98, "Tifinagh", 11568, 11647);
    public static final /* enum */ UnicodeCharBlock ETHIOPIC_EXTENDED = new UnicodeCharBlock(75, 2, "Ethiopic Extended", 11648, 11743);
    public static final /* enum */ UnicodeCharBlock CYRILLIC_EXTENDED_A = new UnicodeCharBlock(9, 2, "Cyrillic Extended-A", 11744, 11775);
    public static final /* enum */ UnicodeCharBlock SUPPLEMENTED_PUNCT = new UnicodeCharBlock(31, 1, "Supplemental Punctuation", 11776, 11903);
    public static final /* enum */ UnicodeCharBlock CJK_RADICAlS_SUPPL = new UnicodeCharBlock(59, 1, "CJK Radicals Supplement", 11904, 12031);
    public static final /* enum */ UnicodeCharBlock KANGXI_RADICALS = new UnicodeCharBlock(59, 2, "Kangxi Radicals", 12032, 12255);
    public static final /* enum */ UnicodeCharBlock CJK_DESCR_CHARS = new UnicodeCharBlock(59, 3, "CJK Description characters", 12272, 12287);
    public static final /* enum */ UnicodeCharBlock CJK_SYMBOLS_AND_PUNKTUATION = new UnicodeCharBlock(48, "CJK Symbols And Punctuation", 12288, 12351);
    public static final /* enum */ UnicodeCharBlock HIRAGANA = new UnicodeCharBlock(49, "Hiragana", 12352, 12447);
    public static final /* enum */ UnicodeCharBlock KATAKANA = new UnicodeCharBlock(50, "Katakana", 12448, 12543);
    public static final /* enum */ UnicodeCharBlock BOPOMOFO = new UnicodeCharBlock(51, "Bopomofo", 12544, 12591);
    public static final /* enum */ UnicodeCharBlock HANGUL_COMPAT_JAMO = new UnicodeCharBlock(52, "Hangul Compatibility Jamo", 12592, 12687);
    public static final /* enum */ UnicodeCharBlock KANBUN = new UnicodeCharBlock(59, 6, "Kanbun", 12688, 12703);
    public static final /* enum */ UnicodeCharBlock BOPOMOFO_EXT = new UnicodeCharBlock(51, 1, "Bopomofo Extended", 12704, 12735);
    public static final /* enum */ UnicodeCharBlock CJK_STROKES = new UnicodeCharBlock(61, "CJK Strokes", 12736, 12783);
    public static final /* enum */ UnicodeCharBlock KATAKANA_PHONETIC_EXT = new UnicodeCharBlock(50, 1, "Katakana Phonetic Extensions", 12784, 12799);
    public static final /* enum */ UnicodeCharBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeCharBlock(54, "Enclosed CJK Letters And Months", 12800, 13055);
    public static final /* enum */ UnicodeCharBlock CJK_COMPATIBILITY = new UnicodeCharBlock(55, "CJK Compatibility", 13056, 13311);
    public static final /* enum */ UnicodeCharBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeCharBlock(59, 4, "CJK Unified Ideographs Extension A", 13312, 19903);
    public static final /* enum */ UnicodeCharBlock YIJING = new UnicodeCharBlock(99, "Yijing Hexagram Symbols", 19904, 19967);
    public static final /* enum */ UnicodeCharBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeCharBlock(59, "CJK Unified Ideographs1", 19968, 40959);
    public static final /* enum */ UnicodeCharBlock YI = new UnicodeCharBlock(83, "Yi Syllables", 40960, 42127);
    public static final /* enum */ UnicodeCharBlock YI_RADICALS = new UnicodeCharBlock(83, 1, "Yi Radicals", 42128, 42191);
    public static final /* enum */ UnicodeCharBlock VAI = new UnicodeCharBlock(12, "Vai", 42240, 42559);
    public static final /* enum */ UnicodeCharBlock CYRILLIC_EXTENDED_B = new UnicodeCharBlock(9, 3, "Cyrillic Extended-B", 42560, 42655);
    public static final /* enum */ UnicodeCharBlock MODIFIER_TONE_LETTERS = new UnicodeCharBlock(5, 1, "Modifier Tone Letters", 42752, 42783);
    public static final /* enum */ UnicodeCharBlock LATIN_EXT_D = new UnicodeCharBlock(29, 2, "Latin Extended-D", 42784, 43007);
    public static final /* enum */ UnicodeCharBlock SYLOTI_NAGRI = new UnicodeCharBlock(100, "Syloti Nagri", 43008, 43055);
    public static final /* enum */ UnicodeCharBlock PHAGS_PA = new UnicodeCharBlock(53, "Phags-Pa", 43072, 43135);
    public static final /* enum */ UnicodeCharBlock SAURASHTRA = new UnicodeCharBlock(115, "Saurashtra", 43136, 43231);
    public static final /* enum */ UnicodeCharBlock KAYAH_LI = new UnicodeCharBlock(116, "Kayah Li", 43264, 43311);
    public static final /* enum */ UnicodeCharBlock REJANG = new UnicodeCharBlock(117, "Rejang", 43312, 43359);
    public static final /* enum */ UnicodeCharBlock CHAM = new UnicodeCharBlock(118, "Cham", 43520, 43615);
    public static final /* enum */ UnicodeCharBlock HANGUL_SYLLABLES = new UnicodeCharBlock(56, "Hangul Syllables", 44032, 55215);
    public static final /* enum */ UnicodeCharBlock NON_PLAIN_0 = new UnicodeCharBlock(57, "Non-Plane 0", 55296, 57343);
    public static final /* enum */ UnicodeCharBlock PRIVATE_USE_AREA = new UnicodeCharBlock(60, "Private Use Area xplane 0", 57344, 63743);
    public static final /* enum */ UnicodeCharBlock CJK_COMPAT_IDEOGRAPHS = new UnicodeCharBlock(61, 1, "CJK Compatibility Ideographs", 63744, 64255);
    public static final /* enum */ UnicodeCharBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeCharBlock(62, "Alphabetic Presentation Forms", 64256, 64335);
    public static final /* enum */ UnicodeCharBlock ARABICC_PRESENTATION_FORMS_A = new UnicodeCharBlock(63, "Arabic Presentation Forms-A", 64336, 65023);
    public static final /* enum */ UnicodeCharBlock VARIATION_SELECTORS = new UnicodeCharBlock(91, "Variation Selectors", 65024, 65039);
    public static final /* enum */ UnicodeCharBlock VERTICAL_FORMS = new UnicodeCharBlock(65, "Vertical Forms", 65040, 65055);
    public static final /* enum */ UnicodeCharBlock COMBINING_HALF_MARKS = new UnicodeCharBlock(64, "Combining Half Marks", 65056, 65071);
    public static final /* enum */ UnicodeCharBlock CJK_COMPATIBILITY_FORMS = new UnicodeCharBlock(65, 1, "CJK Compatibility Forms", 65072, 65103);
    public static final /* enum */ UnicodeCharBlock SMALL_FORM_VARIANTS = new UnicodeCharBlock(66, "Small Form Variants", 65104, 65135);
    public static final /* enum */ UnicodeCharBlock ARABICC_PRESENTATION_FORMS_B = new UnicodeCharBlock(67, "Arabic Presentation Forms-B", 65136, 65279);
    public static final /* enum */ UnicodeCharBlock HALFWIDTH_FULLWIDTH_FORMS = new UnicodeCharBlock(68, "Halfwidth And Fullwidth Forms", 65280, 65519);
    public static final /* enum */ UnicodeCharBlock SPECIALS = new UnicodeCharBlock(69, "Specials", 65520, 65533);
    public static final /* enum */ UnicodeCharBlock LINEAR_B = new UnicodeCharBlock(101, "Linear B Syllabary", 65536, 65663);
    public static final /* enum */ UnicodeCharBlock LINEAR_B_IDEOGRAMS = new UnicodeCharBlock(101, 1, "Linear B Ideograms", 65664, 65791);
    public static final /* enum */ UnicodeCharBlock AEGEAN_NUMBERS = new UnicodeCharBlock(101, 2, "Aegean Numbers", 65792, 65855);
    public static final /* enum */ UnicodeCharBlock ANCIENT_GREEK_NUMBERS = new UnicodeCharBlock(102, "Ancient Greek Numbers", 65856, 65935);
    public static final /* enum */ UnicodeCharBlock ANCIENT_SYMBOLS = new UnicodeCharBlock(119, "Ancient Symbols", 65936, 65999);
    public static final /* enum */ UnicodeCharBlock PHAISTOS = new UnicodeCharBlock(120, "Phaistos Disc", 66000, 66047);
    public static final /* enum */ UnicodeCharBlock LYCIAN = new UnicodeCharBlock(121, 1, "Lycian", 66176, 66207);
    public static final /* enum */ UnicodeCharBlock CARIAN = new UnicodeCharBlock(121, 0, "Carian", 66208, 66271);
    public static final /* enum */ UnicodeCharBlock OLD_ITALIC = new UnicodeCharBlock(85, "Old Italic", 66304, 66351);
    public static final /* enum */ UnicodeCharBlock GOTHIC = new UnicodeCharBlock(86, "Gothic", 66352, 66383);
    public static final /* enum */ UnicodeCharBlock UGARITIC = new UnicodeCharBlock(103, "Ugaritic", 66432, 66463);
    public static final /* enum */ UnicodeCharBlock OLD_PERSIAN = new UnicodeCharBlock(104, "Old Persian", 66464, 66527);
    public static final /* enum */ UnicodeCharBlock DESERET = new UnicodeCharBlock(87, "Deseret", 66560, 66639);
    public static final /* enum */ UnicodeCharBlock SHAVIAN = new UnicodeCharBlock(105, "Shavian", 66640, 66687);
    public static final /* enum */ UnicodeCharBlock OSMANIA = new UnicodeCharBlock(106, "Osmanya", 66688, 66735);
    public static final /* enum */ UnicodeCharBlock CYPRIOT_SYLLABARY = new UnicodeCharBlock(107, "Cypriot Syllabary", 67584, 67647);
    public static final /* enum */ UnicodeCharBlock PHOENDIAN = new UnicodeCharBlock(58, "Phoendial", 67840, 67871);
    public static final /* enum */ UnicodeCharBlock LYDIAN = new UnicodeCharBlock(121, 2, "Lydian", 67872, 67903);
    public static final /* enum */ UnicodeCharBlock KHAROSHTHI = new UnicodeCharBlock(108, "Kharoshthi", 68096, 68191);
    public static final /* enum */ UnicodeCharBlock CUNEIFORM = new UnicodeCharBlock(110, "Cunei form and numbers", 73728, 74751);
    public static final /* enum */ UnicodeCharBlock CUNEIFORM_NUMBERS = new UnicodeCharBlock(110, 1, "Cuneiform Numbers and Punctuation", 74752, 74879);
    public static final /* enum */ UnicodeCharBlock MUSICAL = new UnicodeCharBlock(88, "Byzantine and Musical and Ancient", 118784, 119039);
    public static final /* enum */ UnicodeCharBlock MUSICAL_SYMBOLS = new UnicodeCharBlock(88, 1, "Musical Symbols", 119040, 119295);
    public static final /* enum */ UnicodeCharBlock ANCIENT_GREEK_MUSICAL_NOTATION = new UnicodeCharBlock(88, 2, "Ancient Greek Musical Notation", 119296, 119375);
    public static final /* enum */ UnicodeCharBlock TAI_XUAN_JING = new UnicodeCharBlock(109, "Tai Xuan Jing Symbols", 119552, 119647);
    public static final /* enum */ UnicodeCharBlock COUNTING_ROD = new UnicodeCharBlock(111, "Counting Rod Numerals", 119648, 119679);
    public static final /* enum */ UnicodeCharBlock MATHEMATICAL = new UnicodeCharBlock(89, "Mathematical Alphanumeric", 119808, 120831);
    public static final /* enum */ UnicodeCharBlock MAHJONG_TILES = new UnicodeCharBlock(122, 1, "Mahjong Tiles", 126976, 127023);
    public static final /* enum */ UnicodeCharBlock DOMINO_TILES = new UnicodeCharBlock(122, "Domino Tiles", 127024, 127135);
    public static final /* enum */ UnicodeCharBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = new UnicodeCharBlock(59, 5, "CJK Unified Ideographs Extension B", 131072, 173791);
    public static final /* enum */ UnicodeCharBlock CJK_COMPAT_IDEOGRAPHS_SUPPL = new UnicodeCharBlock(61, 2, "CJK Compatibility Ideographs Supplement", 194560, 195103);
    public static final /* enum */ UnicodeCharBlock TAGS = new UnicodeCharBlock(92, "Tags", 917504, 917631);
    public static final /* enum */ UnicodeCharBlock VARIATION_SELECTORS_SUPPL = new UnicodeCharBlock(91, 1, "Variation Selectors Supplement", 917760, 917999);
    public static final /* enum */ UnicodeCharBlock PRIVATE_USE_PLANE_15 = new UnicodeCharBlock(90, "Private use plane 15", 983040, 1048575);
    public static final /* enum */ UnicodeCharBlock PRIVATE_USE_PLANE_16 = new UnicodeCharBlock(90, 1, "Private use plane 16", 0x100000, 1114109);
    public static final /* enum */ UnicodeCharBlock RESERVED1 = new UnicodeCharBlock(123, "Reserved 1", -1, -1);
    public static final /* enum */ UnicodeCharBlock RESERVED2 = new UnicodeCharBlock(124, "Reserved 2", -1, -1);
    public static final /* enum */ UnicodeCharBlock RESERVED3 = new UnicodeCharBlock(125, "Reserved 3", -1, -1);
    public static final /* enum */ UnicodeCharBlock RESERVED4 = new UnicodeCharBlock(126, "Reserved 4", -1, -1);
    public static final /* enum */ UnicodeCharBlock RESERVED5 = new UnicodeCharBlock(127, "Reserved 5", -1, -1);
    private final int b;
    private int c;
    private final int d;
    private final int e;
    private final String f;
    static final int END_OF_PLANE_0 = 65535;
    static final UnicodeCharBlock[] a;
    public static final int SIZE;
    public static final int GROUP_SIZE = 128;
    private static final /* synthetic */ UnicodeCharBlock[] g;

    public static UnicodeCharBlock[] values() {
        return (UnicodeCharBlock[])g.clone();
    }

    public static UnicodeCharBlock valueOf(String name) {
        return Enum.valueOf(UnicodeCharBlock.class, name);
    }

    private UnicodeCharBlock(int blockGroupID, int blockIndexInGroup, String notation, int firstChar, int lastChar) {
        this.b = blockGroupID;
        this.c = blockIndexInGroup;
        this.f = notation;
        this.d = firstChar;
        this.e = lastChar;
    }

    private UnicodeCharBlock(int blockGroupID, String notation, int firstChar, int lastChar) {
        this(blockGroupID, 0, notation, firstChar, lastChar);
    }

    public static UnicodeCharBlock getUnicodeBlock(int ch) {
        for (UnicodeCharBlock unicodeCharBlock : a) {
            if (ch > unicodeCharBlock.e) continue;
            if (ch < unicodeCharBlock.d) break;
            return unicodeCharBlock;
        }
        return RESERVED5;
    }

    public static int getBlockGroupID(char ch) {
        UnicodeCharBlock unicodeCharBlock = UnicodeCharBlock.getUnicodeBlock(ch);
        return unicodeCharBlock.b;
    }

    public int getBlockGroupID() {
        return this.b;
    }

    public int getUniqueBlockID() {
        return this.c << 16 | this.b;
    }

    public static int getUniqueBlockID(int blockGroupID, int blockIndexInGroup) {
        return blockIndexInGroup << 16 | blockGroupID;
    }

    public static UnicodeCharBlock getUnicodeCharBlock(int uniqueID) {
        switch (uniqueID) {
            case 0: {
                return BASIC_LATIN;
            }
            case 1: {
                return LATIN_1_SUPPLEMENT;
            }
            case 2: {
                return LATIN_EXTENDED_A;
            }
            case 3: {
                return LATIN_EXTENDED_B;
            }
            case 4: {
                return IPA_EXTENSION;
            }
            case 5: {
                return SPACING_MODIFIER_LETTERS;
            }
            case 6: {
                return COMBINING_DIACRITICAL_MARKS;
            }
            case 7: {
                return GREEK;
            }
            case 8: {
                return COPTIC;
            }
            case 9: {
                return CYRILLIC;
            }
            case 10: {
                return ARMENIAN;
            }
            case 11: {
                return HEBREW;
            }
            case 12: {
                return VAI;
            }
            case 13: {
                return ARABIC;
            }
            case 14: {
                return NKO;
            }
            case 15: {
                return DEVANAGARI;
            }
            case 16: {
                return BENGALI;
            }
            case 17: {
                return GURMUKHI;
            }
            case 18: {
                return GUJARATI;
            }
            case 19: {
                return ORIYA;
            }
            case 20: {
                return TAMIL;
            }
            case 21: {
                return TELUGU;
            }
            case 22: {
                return KANNADA;
            }
            case 23: {
                return MALAYALAM;
            }
            case 24: {
                return THAI;
            }
            case 25: {
                return LAO;
            }
            case 26: {
                return GEORGIAN;
            }
            case 27: {
                return BALINESE;
            }
            case 28: {
                return HANGUL_JAMO;
            }
            case 29: {
                return LATIN_EXT_ADDIT;
            }
            case 30: {
                return GREEK_EXT;
            }
            case 31: {
                return GENERAL_PUNCT;
            }
            case 32: {
                return SUPER_SUBSCRIPTS;
            }
            case 33: {
                return CURRENCY_SYMBOLS;
            }
            case 34: {
                return COMBINING_DIACR_MARKS_FOR_SYMBOLS;
            }
            case 35: {
                return LETTERLIKE_SYMBOLS;
            }
            case 36: {
                return NUMBER_FORMS;
            }
            case 37: {
                return ARROWS;
            }
            case 38: {
                return MATHEM_OPERATORS;
            }
            case 39: {
                return MISCELLANEOUS_TECHN;
            }
            case 40: {
                return CONTROL_PICTURES;
            }
            case 41: {
                return OPTICAL_CHAR_RECOGNITION;
            }
            case 42: {
                return ENCLOSED_ALPHANUMERICS;
            }
            case 43: {
                return BOX_DRAWING;
            }
            case 44: {
                return BLOCK_ELEMENTS;
            }
            case 45: {
                return GEOMETRIC_CHAPES;
            }
            case 46: {
                return MISCELLANEOUS_SYMBOLS;
            }
            case 47: {
                return DINGBATS;
            }
            case 48: {
                return CJK_SYMBOLS_AND_PUNKTUATION;
            }
            case 49: {
                return HIRAGANA;
            }
            case 50: {
                return KATAKANA;
            }
            case 51: {
                return BOPOMOFO;
            }
            case 52: {
                return HANGUL_COMPAT_JAMO;
            }
            case 53: {
                return PHAGS_PA;
            }
            case 54: {
                return ENCLOSED_CJK_LETTERS_AND_MONTHS;
            }
            case 55: {
                return CJK_COMPATIBILITY;
            }
            case 56: {
                return HANGUL_SYLLABLES;
            }
            case 57: {
                return NON_PLAIN_0;
            }
            case 58: {
                return PHOENDIAN;
            }
            case 59: {
                return CJK_UNIFIED_IDEOGRAPHS;
            }
            case 60: {
                return PRIVATE_USE_AREA;
            }
            case 61: {
                return CJK_STROKES;
            }
            case 62: {
                return ALPHABETIC_PRESENTATION_FORMS;
            }
            case 63: {
                return ARABICC_PRESENTATION_FORMS_A;
            }
            case 64: {
                return COMBINING_HALF_MARKS;
            }
            case 65: {
                return VERTICAL_FORMS;
            }
            case 66: {
                return SMALL_FORM_VARIANTS;
            }
            case 67: {
                return ARABICC_PRESENTATION_FORMS_B;
            }
            case 68: {
                return HALFWIDTH_FULLWIDTH_FORMS;
            }
            case 69: {
                return SPECIALS;
            }
            case 70: {
                return TIBETAN;
            }
            case 71: {
                return SYRIAC;
            }
            case 72: {
                return THAANA;
            }
            case 73: {
                return SINHALA;
            }
            case 74: {
                return MYANMAR;
            }
            case 75: {
                return ETHIOPIC;
            }
            case 76: {
                return CHEROKEE;
            }
            case 77: {
                return CANADIAN_ABORIGIANAL;
            }
            case 78: {
                return OGHAM;
            }
            case 79: {
                return RUNIC;
            }
            case 80: {
                return KHMER;
            }
            case 81: {
                return MONGOLIAN;
            }
            case 82: {
                return BRAILL;
            }
            case 83: {
                return YI;
            }
            case 84: {
                return TAGALOG;
            }
            case 85: {
                return OLD_ITALIC;
            }
            case 86: {
                return GOTHIC;
            }
            case 87: {
                return DESERET;
            }
            case 88: {
                return MUSICAL;
            }
            case 89: {
                return MATHEMATICAL;
            }
            case 90: {
                return PRIVATE_USE_PLANE_15;
            }
            case 91: {
                return VARIATION_SELECTORS;
            }
            case 92: {
                return TAGS;
            }
            case 93: {
                return LIMBU;
            }
            case 94: {
                return TAI_LE;
            }
            case 95: {
                return NEW_TAI_LUE;
            }
            case 96: {
                return BUGINESE;
            }
            case 97: {
                return GLAGOLITIC;
            }
            case 98: {
                return TIFINAGH;
            }
            case 99: {
                return YIJING;
            }
            case 100: {
                return SYLOTI_NAGRI;
            }
            case 101: {
                return LINEAR_B;
            }
            case 102: {
                return ANCIENT_GREEK_NUMBERS;
            }
            case 103: {
                return UGARITIC;
            }
            case 104: {
                return OLD_PERSIAN;
            }
            case 105: {
                return SHAVIAN;
            }
            case 106: {
                return OSMANIA;
            }
            case 107: {
                return CYPRIOT_SYLLABARY;
            }
            case 108: {
                return KHAROSHTHI;
            }
            case 109: {
                return TAI_XUAN_JING;
            }
            case 110: {
                return CUNEIFORM;
            }
            case 111: {
                return COUNTING_ROD;
            }
            case 112: {
                return SUNDANESE;
            }
            case 113: {
                return LEPCHA;
            }
            case 114: {
                return OL_CHIKI;
            }
            case 115: {
                return SAURASHTRA;
            }
            case 116: {
                return KAYAH_LI;
            }
            case 117: {
                return REJANG;
            }
            case 118: {
                return CHAM;
            }
            case 119: {
                return ANCIENT_SYMBOLS;
            }
            case 120: {
                return PHAISTOS;
            }
            case 121: {
                return CARIAN;
            }
            case 122: {
                return DOMINO_TILES;
            }
            case 123: {
                return RESERVED1;
            }
            case 124: {
                return RESERVED2;
            }
            case 125: {
                return RESERVED3;
            }
            case 126: {
                return RESERVED4;
            }
            case 127: {
                return RESERVED5;
            }
            case 65540: {
                return PHONETIC_EXT;
            }
            case 131076: {
                return PHONETIC_EXTENSIONS_SUPPLEMENT;
            }
            case 65541: {
                return MODIFIER_TONE_LETTERS;
            }
            case 65542: {
                return COMBINING_DIACRITICAL_MARKS_SUPPLEMENT;
            }
            case 65545: {
                return CYRILLIC_SUPPLEMENT;
            }
            case 131081: {
                return CYRILLIC_EXTENDED_A;
            }
            case 196617: {
                return CYRILLIC_EXTENDED_B;
            }
            case 65549: {
                return ARABIC_SUPPLEMENT;
            }
            case 65562: {
                return GEORGIAN_SUPPLEMENT;
            }
            case 65565: {
                return LATIN_EXT_C;
            }
            case 131101: {
                return LATIN_EXT_D;
            }
            case 65567: {
                return SUPPLEMENTED_PUNCT;
            }
            case 65573: {
                return SUPPLEM_ARROWS_A;
            }
            case 131109: {
                return SUPPLEM_ARROWS_B;
            }
            case 196645: {
                return MISC_SYMBOLS_ANDARROWS;
            }
            case 65574: {
                return SUPPL_MATHEM_OPERATORS;
            }
            case 131110: {
                return MISC_MATH_SYMBOLS_A;
            }
            case 196646: {
                return MISC_MATH_SYMBOLS_B;
            }
            case 65586: {
                return KATAKANA_PHONETIC_EXT;
            }
            case 65587: {
                return BOPOMOFO_EXT;
            }
            case 65595: {
                return CJK_RADICAlS_SUPPL;
            }
            case 131131: {
                return KANGXI_RADICALS;
            }
            case 196667: {
                return CJK_DESCR_CHARS;
            }
            case 262203: {
                return CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A;
            }
            case 327739: {
                return CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B;
            }
            case 393275: {
                return KANBUN;
            }
            case 65597: {
                return CJK_COMPAT_IDEOGRAPHS;
            }
            case 131133: {
                return CJK_COMPAT_IDEOGRAPHS_SUPPL;
            }
            case 65601: {
                return CJK_COMPATIBILITY_FORMS;
            }
            case 65611: {
                return ETHIOPIC_SUPPLEMENT;
            }
            case 131147: {
                return ETHIOPIC_EXTENDED;
            }
            case 65616: {
                return KHMER_SYMBOLS;
            }
            case 65619: {
                return YI_RADICALS;
            }
            case 65620: {
                return HANUNOO;
            }
            case 131156: {
                return BUHID;
            }
            case 196692: {
                return TAGBANWA;
            }
            case 65624: {
                return MUSICAL_SYMBOLS;
            }
            case 131160: {
                return ANCIENT_GREEK_MUSICAL_NOTATION;
            }
            case 65626: {
                return PRIVATE_USE_PLANE_16;
            }
            case 65627: {
                return VARIATION_SELECTORS_SUPPL;
            }
            case 65637: {
                return LINEAR_B_IDEOGRAMS;
            }
            case 131173: {
                return AEGEAN_NUMBERS;
            }
            case 65646: {
                return CUNEIFORM_NUMBERS;
            }
            case 65657: {
                return LYCIAN;
            }
            case 131193: {
                return LYDIAN;
            }
            case 65658: {
                return MAHJONG_TILES;
            }
        }
        return null;
    }

    public int getFirstChar() {
        return this.d;
    }

    public int getLastChar() {
        return this.e;
    }

    public static int[] getArrayForOrdinalCount() {
        return new int[SIZE];
    }

    public boolean isNonPlane0Block() {
        return this.d > 65535;
    }

    private static /* synthetic */ UnicodeCharBlock[] a() {
        return new UnicodeCharBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSION, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, CYRILLIC_SUPPLEMENT, ARMENIAN, HEBREW, ARABIC, SYRIAC, ARABIC_SUPPLEMENT, THAANA, NKO, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, ETHIOPIC_SUPPLEMENT, CHEROKEE, CANADIAN_ABORIGIANAL, OGHAM, RUNIC, TAGALOG, HANUNOO, BUHID, TAGBANWA, KHMER, MONGOLIAN, LIMBU, TAI_LE, NEW_TAI_LUE, KHMER_SYMBOLS, BUGINESE, BALINESE, SUNDANESE, LEPCHA, OL_CHIKI, PHONETIC_EXT, PHONETIC_EXTENSIONS_SUPPLEMENT, COMBINING_DIACRITICAL_MARKS_SUPPLEMENT, LATIN_EXT_ADDIT, GREEK_EXT, GENERAL_PUNCT, SUPER_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_DIACR_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEM_OPERATORS, MISCELLANEOUS_TECHN, CONTROL_PICTURES, OPTICAL_CHAR_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_CHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, MISC_MATH_SYMBOLS_A, SUPPLEM_ARROWS_A, BRAILL, SUPPLEM_ARROWS_B, MISC_MATH_SYMBOLS_B, SUPPL_MATHEM_OPERATORS, MISC_SYMBOLS_ANDARROWS, GLAGOLITIC, LATIN_EXT_C, COPTIC, GEORGIAN_SUPPLEMENT, TIFINAGH, ETHIOPIC_EXTENDED, CYRILLIC_EXTENDED_A, SUPPLEMENTED_PUNCT, CJK_RADICAlS_SUPPL, KANGXI_RADICALS, CJK_DESCR_CHARS, CJK_SYMBOLS_AND_PUNKTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPAT_JAMO, KANBUN, BOPOMOFO_EXT, CJK_STROKES, KATAKANA_PHONETIC_EXT, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, YIJING, CJK_UNIFIED_IDEOGRAPHS, YI, YI_RADICALS, VAI, CYRILLIC_EXTENDED_B, MODIFIER_TONE_LETTERS, LATIN_EXT_D, SYLOTI_NAGRI, PHAGS_PA, SAURASHTRA, KAYAH_LI, REJANG, CHAM, HANGUL_SYLLABLES, NON_PLAIN_0, PRIVATE_USE_AREA, CJK_COMPAT_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABICC_PRESENTATION_FORMS_A, VARIATION_SELECTORS, VERTICAL_FORMS, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABICC_PRESENTATION_FORMS_B, HALFWIDTH_FULLWIDTH_FORMS, SPECIALS, LINEAR_B, LINEAR_B_IDEOGRAMS, AEGEAN_NUMBERS, ANCIENT_GREEK_NUMBERS, ANCIENT_SYMBOLS, PHAISTOS, LYCIAN, CARIAN, OLD_ITALIC, GOTHIC, UGARITIC, OLD_PERSIAN, DESERET, SHAVIAN, OSMANIA, CYPRIOT_SYLLABARY, PHOENDIAN, LYDIAN, KHAROSHTHI, CUNEIFORM, CUNEIFORM_NUMBERS, MUSICAL, MUSICAL_SYMBOLS, ANCIENT_GREEK_MUSICAL_NOTATION, TAI_XUAN_JING, COUNTING_ROD, MATHEMATICAL, MAHJONG_TILES, DOMINO_TILES, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, CJK_COMPAT_IDEOGRAPHS_SUPPL, TAGS, VARIATION_SELECTORS_SUPPL, PRIVATE_USE_PLANE_15, PRIVATE_USE_PLANE_16, RESERVED1, RESERVED2, RESERVED3, RESERVED4, RESERVED5};
    }

    static {
        g = UnicodeCharBlock.a();
        a = UnicodeCharBlock.values();
        SIZE = a.length;
    }
}

