/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.model;

import com.inet.annotations.JsonData;
import com.inet.classloader.I18nMessages;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.StringFunctions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

@JsonData
public class I18NChooserProperty
extends SelectConfigProperty {
    public static final String DEFAULT_LANGUAGE_KEY = "default";
    public static final String DEFAULT_LANGUAGE = "en";
    private static I18nMessages CONFIG_MSG = new I18nMessages("com.inet.config.structure.core.i18n.ConfigStructure", I18NChooserProperty.class);

    public I18NChooserProperty(int sortid, String key, String label) {
        super(sortid, key, "LanguageChooser", label, (Object)"", "", I18NChooserProperty.getSelectOption());
    }

    public static List<LocalizedKey> getSelectOption() {
        Locale[] localeArray;
        HashSet<LocalizedKey> hashSet = new HashSet<LocalizedKey>();
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            String string = locale.getLanguage();
            if (StringFunctions.isEmpty(string)) continue;
            String string2 = locale.getDisplayLanguage(ClientLocale.getThreadLocale());
            if (DEFAULT_LANGUAGE.equalsIgnoreCase(string)) {
                string2 = CONFIG_MSG.getMsg("i18nchooser.language.default", string2);
                string = DEFAULT_LANGUAGE_KEY;
            }
            hashSet.add(new LocalizedKey(string, string2));
        }
        return new ArrayList<LocalizedKey>(hashSet);
    }

    public static String getDisplayLanguage(String languageKey) {
        Locale[] localeArray;
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            String string = locale.getLanguage();
            if (StringFunctions.isEmpty(string)) continue;
            String string2 = locale.getDisplayLanguage(ClientLocale.getThreadLocale());
            if (DEFAULT_LANGUAGE.equalsIgnoreCase(string) && languageKey.equalsIgnoreCase(DEFAULT_LANGUAGE_KEY)) {
                string2 = CONFIG_MSG.getMsg("i18nchooser.language.default", string2);
                string = DEFAULT_LANGUAGE_KEY;
            }
            if (!string.equalsIgnoreCase(languageKey)) continue;
            return string2;
        }
        return null;
    }
}

