/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader;

import com.inet.lib.core.OS;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.logging.StartupLogger;
import com.inet.plugin.fs.FileResourceFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.plugin.fs.ServletResourceFile;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class BaseLocator {
    private static final AtomicBoolean a = new AtomicBoolean(false);
    private static URL b;
    private static List<String> c;

    @Nonnull
    public static final ResourceFile getBaseDirectory() {
        return BaseLocator.a(LogManager.getConfigLogger());
    }

    @Nonnull
    public static final ResourceFile getBaseDirectoryWithoutInitConfig() {
        return BaseLocator.a(new StartupLogger());
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD", "PATH_TRAVERSAL_IN"}, justification="No client input is used")
    private static final ResourceFile a(@Nonnull Logger logger) {
        block20: {
            try {
                Object object;
                Object object2;
                String string;
                URL uRL = b == null ? (b = BaseLocator.class.getProtectionDomain().getCodeSource().getLocation()) : b;
                logger.debug("BaseLocator - base URL: " + String.valueOf(uRL));
                String string2 = string = uRL != null ? uRL.toString() : null;
                if (string == null || string.contains("WEB-INF/lib")) {
                    object2 = ServletUtils.getServletContext();
                    if (object2 != null) {
                        return new ServletResourceFile((ServletContext)object2, "/");
                    }
                    logger.error(new Exception("Servlet context not set. Without a servlet context plugins can't be loaded in a *.war/*.ear file. If you do not register the com.inet.http.PluginDispatcherServlet in the WEB-INF/web.xml then you must register the servlet context via com.inet.shared.servlet.ServletUtils.setServletContext(ServletContext) before accessing any API."));
                }
                if ("jar".equals(uRL.getProtocol())) {
                    object2 = (JarURLConnection)uRL.openConnection();
                    uRL = ((JarURLConnection)object2).getJarFileURL();
                }
                if (!"file".equals(uRL.getProtocol())) {
                    if (!a.getAndSet(true)) {
                        logger.error("Could not resolve application location in file system. This will disable ad hoc internal layouts and some remote designer features.");
                        logger.error("Resolved location was: " + String.valueOf(uRL));
                    }
                    return BaseLocator.a();
                }
                try {
                    uRL = new URL(uRL.toString());
                    object2 = IOFunctions.getFile(uRL);
                }
                catch (Exception exception) {
                    if (!a.getAndSet(true)) {
                        logger.error("Could not resolve application location. This will disable ad hoc internal layouts and some remote designer features.");
                        logger.error(exception);
                    }
                    return BaseLocator.a();
                }
                if (!((File)object2).exists()) {
                    if (!a.getAndSet(true)) {
                        logger.error("Could not resolve application location in file system, resolved location is invalid. This will disable ad hoc internal layouts and some remote designer features.");
                        logger.error("Resolved location was: " + String.valueOf(object2));
                    }
                    return BaseLocator.a();
                }
                if (((File)object2).getName().endsWith(".class")) {
                    object = ((File)object2).getAbsolutePath();
                    int n2 = ((String)object).length() - BaseLocator.class.getName().length() - ".class".length() - 1;
                    if (((String)(object = ((String)object).substring(0, n2))).endsWith("classes")) {
                        return new FileResourceFile(new File(((String)object).substring(0, n2 - "classes".length())));
                    }
                }
                if (!((File)object2).isDirectory() && !((File)object2).getName().endsWith(".class")) {
                    object = ((File)object2).getParentFile();
                    File file = ((File)object).getParentFile();
                    String string3 = ((File)object).getName();
                    if ("core".equals(string3) || "designer".equals(string3)) {
                        return new FileResourceFile(file);
                    }
                    if ("lib".equalsIgnoreCase(string3) && "WEB-INF".equalsIgnoreCase(file.getName())) {
                        return new FileResourceFile(file.getParentFile());
                    }
                    if ("bin".equals(string3) && ((File)object2).getName().toLowerCase().endsWith(".dll")) {
                        return new FileResourceFile(file);
                    }
                    if (new File(file, "plugins").isDirectory() || new File(file, "lib").isDirectory()) {
                        return new FileResourceFile(file);
                    }
                }
                if (logger.isDebug()) {
                    logger.debug("Resolved location unknown in relation to the base directory: " + String.valueOf(object2) + " - " + String.valueOf(uRL) + " use: " + System.getProperty("user.dir"));
                }
            }
            catch (Exception exception) {
                if (a.getAndSet(true)) break block20;
                logger.error("Could not resolve application location. This will disable ad hoc internal layouts and some remote designer features.");
                logger.error(exception);
            }
        }
        return BaseLocator.a();
    }

    @Nonnull
    private static FileResourceFile a() {
        try {
            return new FileResourceFile(System.getProperty("user.dir"));
        }
        catch (Exception exception) {
            return new FileResourceFile(new File("."));
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="We're doing a security check here. This is user provided, but only used for checking, not storing any files.")
    public static boolean isRestrictedPath(Path path) {
        if (c == null) {
            ArrayList arrayList = new ArrayList();
            if (OS.isWindows()) {
                arrayList.addAll(Arrays.asList(System.getenv("SystemRoot"), System.getenv("ProgramFiles"), System.getenv("ProgramFiles(x86)")));
            } else if (OS.isMac()) {
                arrayList.addAll(Arrays.asList("/System", "/Library", "/bin", "/sbin", "/usr", "/Applications"));
            } else if (OS.isUnix()) {
                arrayList.addAll(Arrays.asList("/bin", "/sbin", "/lib", "/lib64", "/etc", "/var", "/usr", "/boot", "/opt"));
            }
            arrayList.add(BaseLocator.a().getAbsolutePath());
            c = Arrays.asList(arrayList.toArray(new String[0]));
        }
        try {
            path = new File(path.toAbsolutePath().normalize().toString()).getCanonicalFile().toPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String string : c) {
            Path path2;
            try {
                path2 = new File(string).getCanonicalFile().toPath();
            }
            catch (IOException iOException) {
                path2 = Paths.get(string, new String[0]).toAbsolutePath().normalize();
            }
            if (!path.startsWith(path2)) continue;
            return true;
        }
        return false;
    }
}

