/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.base;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class NtlmMessage {
    private static final Charset a = StandardCharsets.UTF_16LE;
    private static final byte[] b = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
    private final int c;
    private String d;
    private String e;
    private String f;

    private NtlmMessage(int type) {
        this.c = type;
    }

    public int getType() {
        return this.c;
    }

    @Nullable
    public String getUser() {
        return this.d;
    }

    public String getDomain() {
        return this.e;
    }

    public String getHostname() {
        return this.f;
    }

    @Nullable
    public static NtlmMessage parseAuthorizationHttpHeader(String authorization) {
        if (authorization == null) {
            return null;
        }
        int n2 = authorization.indexOf(32);
        if (n2 <= 0) {
            return null;
        }
        switch (authorization.substring(0, n2)) {
            case "NTLM": 
            case "Negotiate": {
                break;
            }
            default: {
                return null;
            }
        }
        try {
            Object object = Base64.getDecoder().decode(authorization.substring(n2 + 1));
            n2 = NtlmMessage.a((byte[])object, b);
            if (n2 < 0) {
                return null;
            }
            if (n2 > 0) {
                object = Arrays.copyOfRange((byte[])object, n2, ((Object)object).length);
            }
            return NtlmMessage.parseNtlmMessage((byte[])object);
        }
        catch (Throwable throwable) {
            LoginProcessor.LOGGER.debug(throwable);
            return null;
        }
    }

    @Nullable
    public static NtlmMessage parseNtlmMessage(byte @Nonnull [] msg) {
        byte by = msg[8];
        switch (by) {
            case 1: {
                return NtlmMessage.a(new NtlmMessage(by), msg);
            }
            case 2: {
                return NtlmMessage.b(new NtlmMessage(by), msg);
            }
            case 3: {
                return NtlmMessage.c(new NtlmMessage(by), msg);
            }
        }
        return null;
    }

    private static NtlmMessage a(NtlmMessage ntlmMessage, byte[] byArray) {
        int n2 = NtlmMessage.a(byArray, 16);
        int n3 = NtlmMessage.b(byArray, 20);
        ntlmMessage.e = new String(byArray, n3, n2, StandardCharsets.ISO_8859_1);
        int n4 = NtlmMessage.a(byArray, 24);
        int n5 = NtlmMessage.b(byArray, 28);
        ntlmMessage.f = new String(byArray, n5, n4, StandardCharsets.ISO_8859_1);
        return ntlmMessage;
    }

    private static NtlmMessage b(NtlmMessage ntlmMessage, byte[] byArray) {
        return ntlmMessage;
    }

    private static NtlmMessage c(NtlmMessage ntlmMessage, byte[] byArray) {
        int n2 = NtlmMessage.a(byArray, 28);
        int n3 = NtlmMessage.b(byArray, 32);
        ntlmMessage.e = NtlmMessage.a(byArray, n3, n2);
        n2 = NtlmMessage.a(byArray, 36);
        n3 = NtlmMessage.b(byArray, 40);
        ntlmMessage.d = NtlmMessage.a(byArray, n3, n2);
        n2 = NtlmMessage.a(byArray, 44);
        n3 = NtlmMessage.b(byArray, 48);
        ntlmMessage.f = NtlmMessage.a(byArray, n3, n2);
        return ntlmMessage;
    }

    private static int a(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8);
    }

    private static int b(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) + ((byArray[n2 + 1] & 0xFF) << 8) + ((byArray[n2 + 2] & 0xFF) << 16) + ((byArray[n2 + 3] & 0xFF) << 24);
    }

    @Nonnull
    private static String a(byte[] byArray, int n2, int n3) {
        String string = new String(byArray, n2, n3, a);
        string = string.replace('\u0000', ' ');
        return string;
    }

    private static int a(byte[] byArray, byte[] byArray2) {
        block0: for (int i2 = 0; i2 < byArray.length - byArray2.length; ++i2) {
            for (int i3 = 0; i3 < byArray2.length; ++i3) {
                if (byArray[i2 + i3] != byArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }
}

