/*
 * Decompiled with CFR 0.152.
 */
package com.inet;

import com.inet.logging.LogManager;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.process.ProcessStarter;
import java.awt.GraphicsEnvironment;
import java.security.AccessController;
import java.util.Arrays;
import javax.swing.JOptionPane;

public class Start {
    public static void main(String[] args) throws Exception {
        try {
            String string = args.length == 0 ? null : args[0];
            ServerPluginDescription serverPluginDescription = ServerPluginManager.getInstance().loadCoreServerPluginDescriptionForServerStart(string);
            if (serverPluginDescription == null) {
                System.err.println("ERROR: Core Plugin not found in " + ServerPluginManager.getInstance().getPluginDir());
                System.err.println();
                System.err.println("Syntax: java -cp inetcore.jar " + Start.class.getName() + " <Plugin ID>");
                System.err.flush();
                System.out.flush();
                System.exit(-12);
                return;
            }
            String[] stringArray = args;
            if (serverPluginDescription.getId().equalsIgnoreCase(string)) {
                stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            }
            CoreServerPlugin.Start.setArgs(stringArray);
            CoreServerPlugin coreServerPlugin = (CoreServerPlugin)serverPluginDescription.getServerPlugin();
            String string2 = coreServerPlugin.getDefaultConfig();
            if (!coreServerPlugin.startWithProcessStarter() || !ProcessStarter.start(Start.class, args, string2, serverPluginDescription.getId())) {
                ServerPluginManager.getInstance().init(serverPluginDescription);
            }
        }
        catch (Throwable throwable) {
            System.err.flush();
            System.out.flush();
            Thread.sleep(20L);
            System.err.println("ERROR: fatal error on starting the process." + ServerPluginManager.getDiagnostic());
            Thread.sleep(20L);
            throwable.printStackTrace(System.err);
            LogManager.getConfigLogger().fatal(throwable);
            LogManager.stopSpooler();
            System.err.flush();
            System.out.flush();
            System.exit(-13);
        }
    }

    static {
        try {
            AccessController.doPrivileged(() -> {
                String string = System.getProperty("java.vm.specification.version");
                double d2 = Double.parseDouble(string);
                String string2 = d2 < 17.0 ? "Your Java version " + string + " is too old. Please try a newer version of Java. The minimum version is " + 17 + "\nCurrent Java installation directory: " + System.getProperty("java.home") : (d2 >= 26.0 ? "Your Java version " + string + " is too new and has never been tested with this software. Please update to the latest version of the product or switch to Java version " + 25 + "\nCurrent Java installation directory: " + System.getProperty("java.home") : null);
                if (string2 != null) {
                    if (GraphicsEnvironment.isHeadless()) {
                        System.err.println(string2);
                    } else {
                        JOptionPane.showMessageDialog(null, string2, "Setup Error", 0);
                    }
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
    }
}

