/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.attributes;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AttributesHelper {
    public static final String COLOR_TRANSPARENT = "transparent";
    public static final String VERYVERYTHINMATHSPACE = "0.0555556em";
    public static final String VERYTHINMATHSPACE = "0.111111em";
    public static final String THINMATHSPACE = "0.166667em";
    public static final String MEDIUMMATHSPACE = "0.222222em";
    public static final String THICKMATHSPACE = "0.277778em";
    public static final String VERYTHICKMATHSPACE = "0.333333em";
    public static final String VERYVERYTHICKMATHSPACE = "0.388889em";
    public static final String PT = "pt";
    public static final String INFINITY = "9999999pt";
    private static final int HASHSHORT_ALPHA = 5;
    private static final int HASHSHORT_NO_ALPHA = 4;
    private static final int SHORT_INDEX_RED = 1;
    private static final int SHORT_INDEX_GREEN = 2;
    private static final int SHORT_INDEX_BLUE = 3;
    private static final int HASHLEN_ALPHA = 9;
    private static final int HASHLEN_NO_ALPHA = 7;
    private static final int HEXBASE = 16;
    private static final float MAX_HEXCHAR_AS_FLOAT = 15.0f;
    private static final int MAX_BYTE = 255;
    private static final float MAX_PERCENT_AS_FLOAT = 100.0f;
    private static final float MAX_BYTE_AS_FLOAT = 255.0f;
    private static final String PERCENT_SIGN = "%";
    private static final String COMMA = ",";
    private static final double EM = 0.8388888888888889;
    private static final double EX = 0.5;
    private static final double DPI = 72.0;
    private static final double PERCENT = 0.01;
    private static final double CM_PER_INCH = 2.54;
    private static final double MM_PER_INCH = 25.4;
    private static final double PT_PER_PC = 12.0;
    private static final Map<String, String> SIZETRANSLATIONS = new HashMap<String, String>();
    private static final Map<String, Double> RELATIVE_UNITS = new HashMap<String, Double>();
    private static final Map<String, Double> ABSOLUTE_UNITS = new HashMap<String, Double>();
    private static final Map<String, Color> COLOR_MAPPINGS = new HashMap<String, Color>();
    private static final Log LOGGER = LogFactory.getLog(AbstractJEuclidElement.class);

    private AttributesHelper() {
    }

    public static float convertSizeToPt(String sizeString, JEuclidNode contextElement, String defaultUnit) {
        double retVal;
        if (sizeString == null) {
            return 0.0f;
        }
        String tSize = sizeString.trim().toLowerCase(Locale.ENGLISH);
        String translatesTo = SIZETRANSLATIONS.get(tSize);
        if (translatesTo != null) {
            tSize = translatesTo;
        }
        if (tSize.endsWith(PERCENT_SIGN)) {
            tSize = tSize + " ";
        }
        try {
            double value;
            String unit;
            if (tSize.length() <= 2) {
                unit = defaultUnit;
                value = Double.parseDouble(tSize);
            } else {
                int valueLen = tSize.length() - 2;
                unit = tSize.substring(valueLen);
                value = Double.parseDouble(tSize.substring(0, valueLen));
            }
            if (value == 0.0) {
                retVal = 0.0;
            } else if (RELATIVE_UNITS.containsKey(unit)) {
                retVal = value * (double)contextElement.getFontsizeInPoint() * RELATIVE_UNITS.get(unit);
            } else if (ABSOLUTE_UNITS.containsKey(unit)) {
                retVal = value * ABSOLUTE_UNITS.get(unit);
            } else if (defaultUnit.length() > 0) {
                retVal = AttributesHelper.convertSizeToPt(sizeString + defaultUnit, contextElement, "");
            } else {
                retVal = Double.parseDouble(tSize);
                LOGGER.warn((Object)("Error Parsing attribute: " + sizeString + " assuming " + retVal + PT));
            }
        }
        catch (NumberFormatException nfe) {
            retVal = 1.0;
            LOGGER.warn((Object)("Error Parsing number: " + sizeString + " faling back to " + retVal + PT));
        }
        return (float)retVal;
    }

    public static Color stringToColor(String value, Color defaultValue) {
        if (value == null) {
            return null;
        }
        String lowVal = value.toLowerCase(Locale.ENGLISH);
        Color parsedColor = null;
        if (!COLOR_MAPPINGS.containsKey(lowVal)) {
            if (value.startsWith("#")) {
                parsedColor = AttributesHelper.parseWithHash(value);
            } else if (value.startsWith("rgb(")) {
                parsedColor = AttributesHelper.parseAsRGB(value);
            } else if (value.startsWith("java.awt.Color")) {
                parsedColor = AttributesHelper.parseAsJavaAWTColor(value);
            }
            if (parsedColor == null) {
                parsedColor = defaultValue;
            }
            COLOR_MAPPINGS.put(value, parsedColor);
        } else {
            parsedColor = COLOR_MAPPINGS.get(lowVal);
        }
        return parsedColor;
    }

    private static Color parseAsJavaAWTColor(String value) {
        int poss = value.indexOf("[");
        int pose = value.indexOf("]");
        Color parsedColor = poss != -1 && pose != -1 ? AttributesHelper.parseCommaSeparatedString(value.substring(poss + 1, pose), poss, pose) : null;
        return parsedColor;
    }

    private static Color parseAsRGB(String value) {
        int poss = value.indexOf("(");
        int pose = value.indexOf(")");
        Color parsedColor = poss != -1 && pose != -1 ? AttributesHelper.parseCommaSeparatedString(value.substring(poss + 1, pose), poss, pose) : null;
        return parsedColor;
    }

    private static Color parseCommaSeparatedString(String value, int poss, int pose) {
        Color parsedColor;
        StringTokenizer st = new StringTokenizer(value, COMMA);
        try {
            String str;
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            if (st.hasMoreTokens()) {
                str = st.nextToken().trim();
                red = AttributesHelper.parseFloatOrPercent(str);
            }
            if (st.hasMoreTokens()) {
                str = st.nextToken().trim();
                green = AttributesHelper.parseFloatOrPercent(str);
            }
            if (st.hasMoreTokens()) {
                str = st.nextToken().trim();
                blue = AttributesHelper.parseFloatOrPercent(str);
            }
            parsedColor = new Color(red, green, blue);
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)e);
            parsedColor = null;
        }
        return parsedColor;
    }

    private static float parseFloatOrPercent(String str) {
        float value = str.endsWith(PERCENT_SIGN) ? Float.parseFloat(str.substring(0, str.length() - 1)) / 100.0f : Float.parseFloat(str) / 255.0f;
        if (value < 0.0f || value > 1.0f) {
            throw new NumberFormatException(str + " is out of Range");
        }
        return value;
    }

    private static Color parseWithHash(String value) {
        Color parsedColor;
        block6: {
            parsedColor = null;
            try {
                int len = value.length();
                if (len >= 4 && len <= 5) {
                    float red = (float)Integer.parseInt(value.substring(1, 2), 16) / 15.0f;
                    float green = (float)Integer.parseInt(value.substring(2, 3), 16) / 15.0f;
                    float blue = (float)Integer.parseInt(value.substring(3, 4), 16) / 15.0f;
                    float alpha = 1.0f;
                    if (len == 5) {
                        alpha = (float)Integer.parseInt(value.substring(4), 16) / 15.0f;
                    }
                    parsedColor = new Color(red, green, blue, alpha);
                    break block6;
                }
                if (len == 7 || len == 9) {
                    int red = Integer.parseInt(value.substring(1, 3), 16);
                    int green = Integer.parseInt(value.substring(3, 5), 16);
                    int blue = Integer.parseInt(value.substring(5, 7), 16);
                    int alpha = 255;
                    if (len == 9) {
                        alpha = Integer.parseInt(value.substring(7), 16);
                    }
                    parsedColor = new Color(red, green, blue, alpha);
                    break block6;
                }
                throw new NumberFormatException();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return parsedColor;
    }

    public static String colorTOsRGBString(Color color) {
        if (color == null) {
            return COLOR_TRANSPARENT;
        }
        StringBuffer sbuf = new StringBuffer(10);
        sbuf.append('#');
        String s = Integer.toHexString(color.getRed());
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        s = Integer.toHexString(color.getGreen());
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        s = Integer.toHexString(color.getBlue());
        if (s.length() == 1) {
            sbuf.append('0');
        }
        sbuf.append(s);
        if (color.getAlpha() != 255) {
            s = Integer.toHexString(color.getAlpha());
            if (s.length() == 1) {
                sbuf.append('0');
            }
            sbuf.append(s);
        }
        return sbuf.toString();
    }

    static {
        SIZETRANSLATIONS.put("veryverythinmathspace", VERYVERYTHINMATHSPACE);
        SIZETRANSLATIONS.put("verythinmathspace", VERYTHINMATHSPACE);
        SIZETRANSLATIONS.put("thinmathspace", THINMATHSPACE);
        SIZETRANSLATIONS.put("mediummathspace", MEDIUMMATHSPACE);
        SIZETRANSLATIONS.put("thickmathspace", THICKMATHSPACE);
        SIZETRANSLATIONS.put("verythickmathspace", VERYTHICKMATHSPACE);
        SIZETRANSLATIONS.put("veryverythickmathspace", VERYVERYTHICKMATHSPACE);
        SIZETRANSLATIONS.put("infinity", INFINITY);
        SIZETRANSLATIONS.put("small", "68%");
        SIZETRANSLATIONS.put("normal", "100%");
        SIZETRANSLATIONS.put("big", "147%");
        SIZETRANSLATIONS.put("thin", "0.5");
        SIZETRANSLATIONS.put("medium", "1");
        SIZETRANSLATIONS.put("thick", "2");
        SIZETRANSLATIONS.put("null", "0");
        RELATIVE_UNITS.put("em", 0.8388888888888889);
        RELATIVE_UNITS.put("ex", 0.5);
        RELATIVE_UNITS.put("% ", 0.01);
        ABSOLUTE_UNITS.put("px", 1.0);
        ABSOLUTE_UNITS.put("in", 72.0);
        ABSOLUTE_UNITS.put("cm", 28.346456692913385);
        ABSOLUTE_UNITS.put("mm", 2.834645669291339);
        ABSOLUTE_UNITS.put(PT, 1.0);
        ABSOLUTE_UNITS.put("pc", 12.0);
        COLOR_MAPPINGS.put("aqua", new Color(0, 255, 255));
        COLOR_MAPPINGS.put("black", Color.BLACK);
        COLOR_MAPPINGS.put("blue", Color.BLUE);
        COLOR_MAPPINGS.put("fuchsia", new Color(255, 0, 255));
        COLOR_MAPPINGS.put("gray", Color.GRAY);
        COLOR_MAPPINGS.put("green", Color.GREEN);
        COLOR_MAPPINGS.put("lime", new Color(0, 255, 0));
        COLOR_MAPPINGS.put("maroon", new Color(128, 0, 0));
        COLOR_MAPPINGS.put("navy", new Color(0, 0, 128));
        COLOR_MAPPINGS.put("olive", new Color(128, 128, 0));
        COLOR_MAPPINGS.put("purple", new Color(128, 0, 128));
        COLOR_MAPPINGS.put("red", Color.RED);
        COLOR_MAPPINGS.put("silver", new Color(192, 192, 192));
        COLOR_MAPPINGS.put("teal", new Color(0, 128, 128));
        COLOR_MAPPINGS.put("white", Color.WHITE);
        COLOR_MAPPINGS.put("yellow", Color.YELLOW);
        COLOR_MAPPINGS.put(COLOR_TRANSPARENT, null);
        COLOR_MAPPINGS.put("null", null);
        COLOR_MAPPINGS.put("", null);
    }
}

