/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.table;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.table.Maligngroup;
import net.sourceforge.jeuclid.elements.presentation.table.Malignmark;
import net.sourceforge.jeuclid.elements.presentation.table.Mtd;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;
import net.sourceforge.jeuclid.elements.presentation.token.Mn;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import org.w3c.dom.DOMException;
import org.w3c.dom.NodeList;
import org.w3c.dom.mathml.MathMLLabeledRowElement;
import org.w3c.dom.mathml.MathMLNodeList;
import org.w3c.dom.mathml.MathMLTableElement;
import org.w3c.dom.mathml.MathMLTableRowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mtable
extends AbstractJEuclidElement
implements MathMLTableElement {
    public static final String ATTR_ROWLINES = "rowlines";
    public static final String ATTR_COLUMNLINES = "columnlines";
    public static final String ATTR_ALIGN = "align";
    public static final String ATTR_ALIGNMENTSCOPE = "alignmentscope";
    public static final String ATTR_COLUMNWIDTH = "columnwidth";
    public static final String ATTR_WIDTH = "width";
    public static final String ATTR_ROWSPACING = "rowspacing";
    public static final String ATTR_COLUMNSPACING = "columnspacing";
    public static final String ATTR_FRAME = "frame";
    public static final String ATTR_FRAMESPACING = "framespacing";
    public static final String ATTR_EQUALROWS = "equalrows";
    public static final String ATTR_EQUALCOLUMNS = "equalcolumns";
    public static final String ATTR_DISPLAYSTYLE = "displaystyle";
    public static final String ATTR_SIDE = "side";
    public static final String ATTR_MINLABELSPACING = "minlabelspacing";
    public static final String VALUE_NONE = "none";
    public static final String VALUE_DASHED = "dashed";
    public static final String VALUE_SOLID = "solid";
    public static final String ELEMENT = "mtable";
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 1;
    public static final String ATTR_ROWALIGN = "rowalign";
    public static final String ATTR_COLUMNALIGN = "columnalign";
    public static final String ATTR_GROUPALIGN = "groupalign";
    public static final String DEFAULT_COLUMNSPACING = "0.8em";
    public static final String DEFAULT_ROWSPACING = "1.0ex";
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_BASELINE = 3;
    public static final int ALIGN_AXIS = 4;
    public static final int ALIGN_LEFT = 5;
    public static final int ALIGN_RIGHT = 6;
    public static final int ALIGN_MARK = 11;
    public static final int ALIGN_DECIMALPOINT = 7;
    public static final int WIDTH_AUTO = -1;
    public static final int WIDTH_FIT = -2;
    private static final String DEFAULT_FRAMESPACING = "0.4em 0.5ex";
    private static final int WHOLE_WIDTH = 0;
    private static final int LEFT_WIDTH = 1;
    private static final int RIGHT_WIDTH = 2;

    public Mtable(MathBase base) {
        super(base);
        this.setDefaultMathAttribute(ATTR_ALIGN, "axis");
        this.setDefaultMathAttribute(ATTR_ROWALIGN, "baseline");
        this.setDefaultMathAttribute(ATTR_COLUMNALIGN, "center");
        this.setDefaultMathAttribute(ATTR_GROUPALIGN, "{left}");
        this.setDefaultMathAttribute(ATTR_ALIGNMENTSCOPE, MathBase.TRUE);
        this.setDefaultMathAttribute(ATTR_COLUMNWIDTH, "auto");
        this.setDefaultMathAttribute(ATTR_WIDTH, "auto");
        this.setDefaultMathAttribute(ATTR_ROWSPACING, DEFAULT_ROWSPACING);
        this.setDefaultMathAttribute(ATTR_COLUMNSPACING, DEFAULT_COLUMNSPACING);
        this.setDefaultMathAttribute(ATTR_ROWLINES, VALUE_NONE);
        this.setDefaultMathAttribute(ATTR_COLUMNLINES, VALUE_NONE);
        this.setDefaultMathAttribute(ATTR_FRAME, VALUE_NONE);
        this.setDefaultMathAttribute(ATTR_FRAMESPACING, DEFAULT_FRAMESPACING);
        this.setDefaultMathAttribute(ATTR_EQUALROWS, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_EQUALCOLUMNS, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_DISPLAYSTYLE, MathBase.FALSE);
        this.setDefaultMathAttribute(ATTR_SIDE, "right");
        this.setDefaultMathAttribute(ATTR_MINLABELSPACING, DEFAULT_COLUMNSPACING);
    }

    @Override
    public boolean isChildBlock(JEuclidElement child) {
        return false;
    }

    protected float getFramespacingh() {
        if (LineType.NONE.equals((Object)this.getFrameAsLineType())) {
            return 0.0f;
        }
        String spacing = this.getSpaceArrayEntry(this.getFramespacing(), 0);
        return AttributesHelper.convertSizeToPt(spacing, this, "pt");
    }

    protected float getFramespacingv() {
        if (LineType.NONE.equals((Object)this.getFrameAsLineType())) {
            return 0.0f;
        }
        String spacing = this.getSpaceArrayEntry(this.getFramespacing(), 1);
        return AttributesHelper.convertSizeToPt(spacing, this, "pt");
    }

    @Override
    public void paint(Graphics2D g, float posX, float posY) {
        float x1;
        int i;
        super.paint(g, posX, posY);
        posX += this.getFramespacingh();
        posY += this.getFramespacingv();
        float[] maxrowascentheight = new float[this.getMathElementCount()];
        float[] maxrowdescentheight = new float[this.getMathElementCount()];
        for (i = 0; i < this.getMathElementCount(); ++i) {
            maxrowascentheight[i] = this.getMaxRowAscentHeight(g, i);
            maxrowdescentheight[i] = this.getMaxRowDescentHeight(g, i);
        }
        int maxcolumns = this.getMaxColumnCount();
        boolean isAlignGroupsExist = this.getMaxGroupAlignCount() != 0;
        float[] maxcolumnwidth = new float[maxcolumns];
        for (i = 0; i < maxcolumns; ++i) {
            maxcolumnwidth[i] = this.getMaxColumnWidth(g, i);
        }
        float x = x1 = posX;
        float startY = posY -= this.getAscentHeight(g);
        Vector<Float> rowlines = new Vector<Float>();
        Vector<Float> columnlines = new Vector<Float>(maxcolumns);
        for (i = 0; i < this.getMathElementCount(); ++i) {
            JEuclidElement row = this.getMathElement(i);
            posY += maxrowascentheight[i];
            x = x1;
            for (int j = 0; j < maxcolumns && j < row.getMathElementCount(); ++j) {
                if (isAlignGroupsExist && this.getAlignGroups((Mtd)row.getMathElement(j)).length > 0) {
                    row.getMathElement(j).paint(g, x, posY);
                } else {
                    float xx = x + maxcolumnwidth[j] / 2.0f - row.getMathElement(j).getWidth(g) / 2.0f;
                    row.getMathElement(j).paint(g, xx, posY);
                }
                float currentColSpacing = this.getColumnspacing(j);
                x += maxcolumnwidth[j];
                if (i == 0 && j < maxcolumns - 1) {
                    columnlines.add(Float.valueOf(x + currentColSpacing / 2.0f));
                }
                x += currentColSpacing;
            }
            posY += maxrowdescentheight[i];
            float currentRowSpacing = this.getRowspacing(i);
            if (i < this.getMathElementCount() - 1) {
                rowlines.add(Float.valueOf(posY + currentRowSpacing / 2.0f));
            }
            posY += currentRowSpacing;
        }
        int col = 0;
        Stroke oldStroke = g.getStroke();
        float lineWidth = GraphicsSupport.lineWidth(this);
        float dashWidth = 3.0f * lineWidth;
        BasicStroke solidStroke = new BasicStroke(lineWidth);
        BasicStroke dashedStroke = new BasicStroke(lineWidth, 2, 2, lineWidth, new float[]{dashWidth, dashWidth}, 0.0f);
        Iterator i$ = columnlines.iterator();
        while (i$.hasNext()) {
            float lineX = ((Float)i$.next()).floatValue();
            LineType lt = this.getColumnLine(col);
            ++col;
            if (LineType.SOLID.equals((Object)lt)) {
                g.setStroke(solidStroke);
            } else if (LineType.DASHED.equals((Object)lt)) {
                g.setStroke(dashedStroke);
            }
            if (LineType.NONE.equals((Object)lt)) continue;
            g.draw(new Line2D.Float(lineX, startY, lineX, posY));
        }
        int row = 0;
        Iterator i$2 = rowlines.iterator();
        while (i$2.hasNext()) {
            float lineY = ((Float)i$2.next()).floatValue();
            LineType lt = this.getRowLine(row);
            ++row;
            if (LineType.SOLID.equals((Object)lt)) {
                g.setStroke(solidStroke);
            } else if (LineType.DASHED.equals((Object)lt)) {
                g.setStroke(dashedStroke);
            }
            if (LineType.NONE.equals((Object)lt)) continue;
            g.draw(new Line2D.Float(x1, lineY, x, lineY));
        }
        g.setStroke(oldStroke);
    }

    private float getMaxRowAscentHeight(Graphics2D g, int row) {
        if (row >= this.getMathElementCount()) {
            return 0.0f;
        }
        JEuclidElement child = this.getMathElement(row);
        float height = 0.0f;
        for (int i = 0; i < child.getMathElementCount(); ++i) {
            height = Math.max(height, child.getMathElement(i).getAscentHeight(g));
        }
        return height;
    }

    private float getMaxRowDescentHeight(Graphics2D g, int row) {
        if (row >= this.getMathElementCount()) {
            return 0.0f;
        }
        JEuclidElement child = this.getMathElement(row);
        float height = 0.0f;
        for (int i = 0; i < child.getMathElementCount(); ++i) {
            height = Math.max(height, child.getMathElement(i).getDescentHeight(g));
        }
        return height;
    }

    private float getMaxColumnWidth(Graphics2D g, int column) {
        float width = 0.0f;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            JEuclidElement child = this.getMathElement(i);
            if (column >= child.getMathElementCount()) continue;
            width = Math.max(width, child.getMathElement(column).getWidth(g));
        }
        return width;
    }

    private int getMaxColumnCount() {
        int count = 0;
        for (int i = 0; i < this.getMathElementCount(); ++i) {
            JEuclidElement child = this.getMathElement(i);
            count = Math.max(count, child.getMathElementCount());
        }
        return count;
    }

    @Override
    public float calculateWidth(Graphics2D g) {
        this.calculateAlignmentGroups(g);
        float width = 0.0f;
        int maxcolumns = this.getMaxColumnCount();
        for (int i = 0; i < maxcolumns; ++i) {
            width += this.getMaxColumnWidth(g, i);
            if (i + 1 >= maxcolumns) continue;
            width += this.getColumnspacing(i);
        }
        return width += this.getFramespacingh() * 2.0f;
    }

    private float calculateActualHeight(Graphics2D g) {
        float height = 0.0f;
        int mec = this.getMathElementCount();
        for (int i = 0; i < mec; ++i) {
            height = height + this.getMaxRowAscentHeight(g, i) + this.getMaxRowDescentHeight(g, i);
            if (i + 1 >= mec) continue;
            height += this.getRowspacing(i);
        }
        return height += this.getFramespacingv() * 2.0f;
    }

    @Override
    public float calculateAscentHeight(Graphics2D g) {
        AlignmentType align = AlignmentType.parseAlignmentType(this.getAlign());
        if (AlignmentType.BOTTOM.equals((Object)align)) {
            return this.calculateActualHeight(g);
        }
        if (AlignmentType.TOP.equals((Object)align)) {
            return this.getRowCount() > 0 ? this.getMaxRowAscentHeight(g, 0) : 0.0f;
        }
        if (AlignmentType.AXIS.equals((Object)align)) {
            return (this.calculateActualHeight(g) + 1.0f) / 2.0f;
        }
        return (this.calculateActualHeight(g) + 1.0f) / 2.0f + this.getMiddleShift(g);
    }

    @Override
    public float calculateDescentHeight(Graphics2D g) {
        AlignmentType align = AlignmentType.parseAlignmentType(this.getAlign());
        if (AlignmentType.BOTTOM.equals((Object)align)) {
            return 0.0f;
        }
        if (AlignmentType.TOP.equals((Object)align)) {
            return this.calculateActualHeight(g) - (this.getRowCount() > 0 ? this.getMaxRowAscentHeight(g, 0) : 0.0f);
        }
        if (AlignmentType.AXIS.equals((Object)align)) {
            return (this.calculateActualHeight(g) + 1.0f) / 2.0f;
        }
        float b = this.getMiddleShift(g);
        float c = (this.calculateActualHeight(g) + 1.0f) / 2.0f;
        return c - b;
    }

    public List<AlignmentType> getGroupAlign(Mtd cell) {
        Vector<AlignmentType> result = new Vector<AlignmentType>();
        if (cell == null) {
            return result;
        }
        String cellGroupAlign = cell.getGroupalign();
        String groupAlign = cellGroupAlign == null || cellGroupAlign.length() == 0 ? ((Mtr)cell.getParent()).getGroupalign() : cell.getGroupalign();
        if (groupAlign == null) {
            groupAlign = this.getGroupalign();
        }
        if (groupAlign != null) {
            String[] gAlign;
            for (String value : gAlign = groupAlign.split("\\w")) {
                if (value.length() <= 0) continue;
                result.add(AlignmentType.parseAlignmentType(value));
            }
        }
        return result;
    }

    private int getMaxGroupAlignCount() {
        int result = 0;
        int rowsCount = this.getRowCount();
        int columnsCount = this.getMaxColumnCount();
        int tmpLength = 0;
        for (int column = 0; column < columnsCount; ++column) {
            for (int row = 0; row < rowsCount; ++row) {
                Mtd cell = null;
                try {
                    cell = this.getCell(row, column);
                }
                catch (Exception e) {
                    return 0;
                }
                if (cell == null || result >= (tmpLength = cell.getAlignGroups().size())) continue;
                result = tmpLength;
            }
        }
        return result;
    }

    private int getRowCount() {
        return this.getMathElementCount();
    }

    private Mtd getCell(int row, int column) throws Exception {
        int rowsCount = this.getRowCount();
        int columnsCount = this.getMaxColumnCount();
        Mtd cell = null;
        if (row > rowsCount - 1 || column > columnsCount - 1) {
            return cell;
        }
        JEuclidElement theRow = this.getMathElement(row);
        if (column < theRow.getMathElementCount()) {
            if (theRow.getMathElement(column) instanceof Mtd) {
                cell = (Mtd)theRow.getMathElement(column);
            } else {
                throw new Exception("This table doesn't contain <mtr> and <mtd> tags.");
            }
        }
        return cell;
    }

    private Maligngroup[] getAlignGroups(Mtd cell) {
        Maligngroup[] result;
        List<Maligngroup> list = cell.getAlignGroups();
        if (list.size() == 0) {
            result = new Maligngroup[]{};
        } else {
            result = new Maligngroup[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                result[i] = list.get(i);
            }
        }
        return result;
    }

    protected void calculateAlignmentGroups(Graphics2D g) {
        List<AlignmentType> groupalignvalues;
        Maligngroup[] aligngroups;
        int rowsCount = this.getRowCount();
        int columnsCount = this.getMaxColumnCount();
        int MAX_WIDTH_IN_COLUMN = rowsCount;
        int maxGroupAlignCount = this.getMaxGroupAlignCount();
        if (maxGroupAlignCount == 0) {
            return;
        }
        float[][][][] alignwidths = new float[columnsCount][3][rowsCount + 1][maxGroupAlignCount];
        boolean[][] usesMarks = new boolean[columnsCount][this.getMaxGroupAlignCount()];
        for (int col = 0; col < columnsCount; ++col) {
            for (int row = 0; row < rowsCount; ++row) {
                Mtd cell = null;
                try {
                    cell = this.getCell(row, col);
                }
                catch (Exception e) {
                    cell = null;
                }
                if (cell == null) continue;
                aligngroups = this.getAlignGroups(cell);
                groupalignvalues = this.getGroupAlign(cell);
                if (groupalignvalues.size() == 0) {
                    groupalignvalues = new Vector<AlignmentType>(aligngroups.length);
                    for (Maligngroup element : aligngroups) {
                        groupalignvalues.add(AlignmentType.LEFT);
                    }
                }
                if (aligngroups.length == 0 || aligngroups.length < groupalignvalues.size()) continue;
                for (int alignIndex = 0; alignIndex < groupalignvalues.size(); ++alignIndex) {
                    List<JEuclidElement> elements = Maligngroup.getElementsOfAlignGroup(aligngroups[alignIndex]);
                    alignwidths[col][0][row][alignIndex] = Maligngroup.getElementsWholeWidth(g, elements);
                    if (alignwidths[col][0][MAX_WIDTH_IN_COLUMN][alignIndex] < alignwidths[col][0][row][alignIndex]) {
                        alignwidths[col][0][MAX_WIDTH_IN_COLUMN][alignIndex] = alignwidths[col][0][row][alignIndex];
                    }
                    if (aligngroups[alignIndex].getMark() != null) {
                        float leftPart;
                        usesMarks[col][alignIndex] = true;
                        alignwidths[col][1][row][alignIndex] = leftPart = this.getWidthTillMark(g, elements.iterator());
                        alignwidths[col][2][row][alignIndex] = alignwidths[col][0][row][alignIndex] - leftPart;
                        if (alignwidths[col][1][MAX_WIDTH_IN_COLUMN][alignIndex] < leftPart) {
                            alignwidths[col][1][MAX_WIDTH_IN_COLUMN][alignIndex] = leftPart;
                        }
                        if (!(alignwidths[col][2][MAX_WIDTH_IN_COLUMN][alignIndex] < alignwidths[col][2][row][alignIndex])) continue;
                        alignwidths[col][2][MAX_WIDTH_IN_COLUMN][alignIndex] = alignwidths[col][2][row][alignIndex];
                        continue;
                    }
                    alignwidths[col][1][row][alignIndex] = 0.0f;
                    alignwidths[col][2][row][alignIndex] = alignwidths[col][0][row][alignIndex];
                    if (!groupalignvalues.get(alignIndex).equals((Object)AlignmentType.DECIMALPOINT)) continue;
                    float tillPoint = this.getWidthTillPoint(g, elements.iterator());
                    float pointWidth = this.getPointWidth(g, elements.iterator());
                    alignwidths[col][1][row][alignIndex] = tillPoint;
                    if (alignwidths[col][1][MAX_WIDTH_IN_COLUMN][alignIndex] < tillPoint) {
                        alignwidths[col][1][MAX_WIDTH_IN_COLUMN][alignIndex] = tillPoint;
                    }
                    alignwidths[col][2][row][alignIndex] = alignwidths[col][0][row][alignIndex] - tillPoint - pointWidth;
                    if (!(alignwidths[col][2][MAX_WIDTH_IN_COLUMN][alignIndex] < alignwidths[col][2][row][alignIndex])) continue;
                    alignwidths[col][2][MAX_WIDTH_IN_COLUMN][alignIndex] = alignwidths[col][2][row][alignIndex];
                }
            }
        }
        AlignmentType alignOfTheGroup = AlignmentType.LEFT;
        float currentWidth = 0.0f;
        float maxWidth = 0.0f;
        float leftWidth = 0.0f;
        float leftMaxWidth = 0.0f;
        float rightWidth = 0.0f;
        float rightMaxWidth = 0.0f;
        Maligngroup group = null;
        Maligngroup nextGroup = null;
        for (int col = 0; col < columnsCount; ++col) {
            for (int row = 0; row < rowsCount; ++row) {
                Mtd cell = null;
                try {
                    cell = this.getCell(row, col);
                }
                catch (Exception e) {
                    cell = null;
                }
                if (cell == null) continue;
                aligngroups = this.getAlignGroups(cell);
                groupalignvalues = this.getGroupAlign(cell);
                if (groupalignvalues.size() == 0) {
                    groupalignvalues = new Vector<AlignmentType>(aligngroups.length);
                    for (Maligngroup element : aligngroups) {
                        groupalignvalues.add(AlignmentType.LEFT);
                    }
                }
                if (aligngroups.length == 0 || aligngroups.length < groupalignvalues.size()) continue;
                block17: for (int alignIndex = 0; alignIndex < groupalignvalues.size(); ++alignIndex) {
                    alignOfTheGroup = groupalignvalues.get(alignIndex);
                    currentWidth = alignwidths[col][0][row][alignIndex];
                    maxWidth = alignwidths[col][0][MAX_WIDTH_IN_COLUMN][alignIndex];
                    leftWidth = alignwidths[col][1][row][alignIndex];
                    leftMaxWidth = alignwidths[col][1][MAX_WIDTH_IN_COLUMN][alignIndex];
                    rightWidth = alignwidths[col][2][row][alignIndex];
                    rightMaxWidth = alignwidths[col][2][MAX_WIDTH_IN_COLUMN][alignIndex];
                    group = aligngroups[alignIndex];
                    if (usesMarks[col][alignIndex]) {
                        alignOfTheGroup = AlignmentType.MARK;
                    }
                    if (alignIndex < groupalignvalues.size() - 1) {
                        nextGroup = aligngroups[alignIndex + 1];
                    }
                    switch (alignOfTheGroup) {
                        case RIGHT: {
                            group.width += maxWidth - currentWidth;
                            continue block17;
                        }
                        case LEFT: {
                            if (alignIndex >= groupalignvalues.size() - 1) continue block17;
                            nextGroup.width += maxWidth - currentWidth;
                            continue block17;
                        }
                        case CENTER: {
                            group.width += (maxWidth - currentWidth) / 2.0f;
                            if (alignIndex >= groupalignvalues.size() - 1) continue block17;
                            nextGroup.width += (maxWidth - currentWidth) / 2.0f;
                            continue block17;
                        }
                        case DECIMALPOINT: 
                        case MARK: {
                            group.width += leftMaxWidth - leftWidth;
                            if (alignIndex >= groupalignvalues.size() - 1) continue block17;
                            nextGroup.width += rightMaxWidth - rightWidth;
                            continue block17;
                        }
                        default: {
                            group.width += maxWidth - currentWidth;
                        }
                    }
                }
            }
        }
    }

    private float getWidthTillPoint(Graphics2D g, Iterator elements) {
        float result = 0.0f;
        JEuclidElement element = null;
        while (elements.hasNext()) {
            element = (JEuclidElement)elements.next();
            if (element instanceof Mn) {
                return result + (float)((Mn)element).getWidthTillPoint(g);
            }
            if (!this.containsNumber(element)) {
                result += element.getWidth(g);
                continue;
            }
            result += this.getWidthTillPoint(g, new ChildIterator(this.getChildNodes()));
        }
        return result;
    }

    private boolean containsNumber(JEuclidElement element) {
        return this.containsElement(element, "mn");
    }

    private float getPointWidth(Graphics2D g, Iterator iterator) {
        float result = 0.0f;
        while (iterator.hasNext()) {
            JEuclidElement element = (JEuclidElement)iterator.next();
            if (!(element instanceof Mn)) continue;
            result = ((Mn)element).getPointWidth(g);
            break;
        }
        return result;
    }

    private float getWidthTillMark(Graphics2D g, Iterator elements) {
        float result = 0.0f;
        JEuclidElement element = null;
        while (elements.hasNext()) {
            element = (JEuclidElement)elements.next();
            if (element instanceof Malignmark) {
                return result;
            }
            if (!this.containsMark(element)) {
                result += element.getWidth(g);
                continue;
            }
            result += this.getWidthTillMark(g, new ChildIterator(this.getChildNodes()));
        }
        return result;
    }

    private boolean containsMark(JEuclidElement element) {
        return this.containsElement(element, "malignmark");
    }

    private boolean containsElement(JEuclidElement container, String searchName) {
        if (container.getTagName().equals(searchName)) {
            return true;
        }
        for (int i = 0; i < container.getMathElementCount(); ++i) {
            if (!this.containsElement(container.getMathElement(i), searchName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTagName() {
        return ELEMENT;
    }

    @Override
    public String getRowlines() {
        return this.getMathAttribute(ATTR_ROWLINES);
    }

    @Override
    public void setRowlines(String rowlines) {
        this.setAttribute(ATTR_ROWLINES, rowlines);
    }

    @Override
    public String getColumnlines() {
        return this.getMathAttribute(ATTR_COLUMNLINES);
    }

    @Override
    public void setColumnlines(String columnlines) {
        this.setAttribute(ATTR_COLUMNLINES, columnlines);
    }

    private LineType getRowLine(int row) {
        return LineType.parseLineType(this.getSpaceArrayEntry(this.getRowlines(), row));
    }

    private LineType getColumnLine(int col) {
        return LineType.parseLineType(this.getSpaceArrayEntry(this.getColumnlines(), col));
    }

    private LineType getFrameAsLineType() {
        return LineType.parseLineType(this.getFrame());
    }

    private String getSpaceArrayEntry(String string, int index) {
        String[] array = string.split("\\s");
        int cur = -1;
        String last = "";
        for (String s : array) {
            if (s.length() <= 0) continue;
            if (++cur == index) {
                return s;
            }
            last = s;
        }
        return last;
    }

    @Override
    public String getColumnwidth() {
        return this.getMathAttribute(ATTR_COLUMNWIDTH);
    }

    @Override
    public void setColumnwidth(String columnwidth) {
        this.setAttribute(ATTR_COLUMNWIDTH, columnwidth);
    }

    @Override
    public String getWidth() {
        return this.getMathAttribute(ATTR_WIDTH);
    }

    @Override
    public void setWidth(String width) {
        this.setAttribute(ATTR_WIDTH, width);
    }

    @Override
    public String getAlign() {
        return this.getMathAttribute(ATTR_ALIGN);
    }

    @Override
    public void setAlign(String align) {
        this.setAttribute(ATTR_ALIGN, align);
    }

    @Override
    public String getRowalign() {
        return this.getMathAttribute(ATTR_ROWALIGN);
    }

    @Override
    public void setRowalign(String rowalign) {
        this.setAttribute(ATTR_ROWALIGN, rowalign);
    }

    @Override
    public String getColumnalign() {
        return this.getMathAttribute(ATTR_COLUMNALIGN);
    }

    @Override
    public void setColumnalign(String columnalign) {
        this.setAttribute(ATTR_COLUMNALIGN, columnalign);
    }

    @Override
    public String getGroupalign() {
        return this.getMathAttribute(ATTR_GROUPALIGN);
    }

    @Override
    public void setGroupalign(String groupalign) {
        this.setAttribute(ATTR_GROUPALIGN, groupalign);
    }

    @Override
    public String getAlignmentscope() {
        return this.getMathAttribute(ATTR_ALIGNMENTSCOPE);
    }

    @Override
    public void setAlignmentscope(String alignmentscope) {
        this.setAttribute(ATTR_ALIGNMENTSCOPE, alignmentscope);
    }

    @Override
    public String getRowspacing() {
        return this.getMathAttribute(ATTR_ROWSPACING);
    }

    private float getRowspacing(int row) {
        return AttributesHelper.convertSizeToPt(this.getSpaceArrayEntry(this.getRowspacing(), row), this, "pt");
    }

    @Override
    public void setRowspacing(String rowspacing) {
        this.setAttribute(ATTR_ROWSPACING, rowspacing);
    }

    @Override
    public String getColumnspacing() {
        return this.getMathAttribute(ATTR_COLUMNSPACING);
    }

    private float getColumnspacing(int column) {
        return AttributesHelper.convertSizeToPt(this.getSpaceArrayEntry(this.getColumnspacing(), column), this, "pt");
    }

    @Override
    public void setColumnspacing(String columnspacing) {
        this.setAttribute(ATTR_COLUMNSPACING, columnspacing);
    }

    @Override
    public String getFrame() {
        return this.getMathAttribute(ATTR_FRAME);
    }

    @Override
    public void setFrame(String frame) {
        this.setAttribute(ATTR_FRAME, frame);
    }

    @Override
    public String getFramespacing() {
        return this.getMathAttribute(ATTR_FRAMESPACING);
    }

    @Override
    public void setFramespacing(String framespacing) {
        this.setAttribute(ATTR_FRAMESPACING, framespacing);
    }

    @Override
    public String getEqualrows() {
        return this.getMathAttribute(ATTR_EQUALROWS);
    }

    @Override
    public void setEqualrows(String equalrows) {
        this.setAttribute(ATTR_EQUALROWS, equalrows);
    }

    @Override
    public String getEqualcolumns() {
        return this.getMathAttribute(ATTR_EQUALCOLUMNS);
    }

    @Override
    public void setEqualcolumns(String equalcolumns) {
        this.setAttribute(ATTR_EQUALCOLUMNS, equalcolumns);
    }

    @Override
    public String getDisplaystyle() {
        return this.getMathAttribute(ATTR_DISPLAYSTYLE);
    }

    @Override
    public void setDisplaystyle(String displaystyle) {
        this.setAttribute(ATTR_DISPLAYSTYLE, displaystyle);
    }

    @Override
    public String getSide() {
        return this.getMathAttribute(ATTR_SIDE);
    }

    @Override
    public void setSide(String side) {
        this.setAttribute(ATTR_SIDE, side);
    }

    @Override
    public String getMinlabelspacing() {
        return this.getMathAttribute(ATTR_MINLABELSPACING);
    }

    @Override
    public void setMinlabelspacing(String minlabelspacing) {
        this.setAttribute(ATTR_MINLABELSPACING, minlabelspacing);
    }

    @Override
    public MathMLNodeList getRows() {
        return null;
    }

    public MathMLTableRowElement insertEmptyRow(int index) {
        return null;
    }

    public MathMLLabeledRowElement insertEmptyLabeledRow(int index) {
        return null;
    }

    public MathMLTableRowElement getRow(int index) {
        return null;
    }

    public MathMLTableRowElement insertRow(int index, MathMLTableRowElement newRow) {
        return null;
    }

    public MathMLTableRowElement setRow(int index, MathMLTableRowElement newRow) {
        return null;
    }

    public void deleteRow(int index) {
    }

    public MathMLTableRowElement removeRow(int index) {
        return null;
    }

    @Override
    public void deleteRow(long index) throws DOMException {
    }

    @Override
    public MathMLTableRowElement getRow(long index) {
        return null;
    }

    @Override
    public MathMLLabeledRowElement insertEmptyLabeledRow(long index) throws DOMException {
        return null;
    }

    @Override
    public MathMLTableRowElement insertEmptyRow(long index) throws DOMException {
        return null;
    }

    @Override
    public MathMLTableRowElement insertRow(long index, MathMLTableRowElement newRow) throws DOMException {
        return null;
    }

    @Override
    public MathMLTableRowElement removeRow(long index) throws DOMException {
        return null;
    }

    @Override
    public MathMLTableRowElement setRow(long index, MathMLTableRowElement newRow) throws DOMException {
        return null;
    }

    private class ChildIterator
    implements Iterator {
        private final NodeList nodeList;
        private int pos;

        protected ChildIterator(NodeList nl) {
            this.nodeList = nl;
        }

        public boolean hasNext() {
            return this.pos < this.nodeList.getLength();
        }

        public Object next() {
            ++this.pos;
            return this.nodeList.item(this.pos - 1);
        }

        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AlignmentType {
        TOP,
        BOTTOM,
        CENTER,
        BASELINE,
        AXIS,
        LEFT,
        RIGHT,
        DECIMALPOINT,
        MARK;


        public static AlignmentType parseAlignmentType(String s) {
            AlignmentType retVal = "top".equalsIgnoreCase(s) ? TOP : ("bottom".equalsIgnoreCase(s) ? BOTTOM : ("baseline".equalsIgnoreCase(s) ? BASELINE : ("axis".equalsIgnoreCase(s) ? AXIS : ("left".equalsIgnoreCase(s) ? LEFT : ("right".equalsIgnoreCase(s) ? RIGHT : ("decimalpoint".equalsIgnoreCase(s) ? DECIMALPOINT : CENTER))))));
            return retVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineType {
        NONE,
        SOLID,
        DASHED;


        public static LineType parseLineType(String s) {
            LineType retVal = s.equalsIgnoreCase(Mtable.VALUE_NONE) ? NONE : (s.equalsIgnoreCase(Mtable.VALUE_DASHED) ? DASHED : SOLID);
            return retVal;
        }
    }
}

