/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.AbstractElementWithDelegates;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.general.AbstractRoot;
import net.sourceforge.jeuclid.elements.presentation.general.AbstractRowLike;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.general.Msqrt;
import net.sourceforge.jeuclid.elements.presentation.token.Mspace;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.mathml.MathMLEncloseElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Menclose
extends AbstractElementWithDelegates
implements MathMLEncloseElement {
    public static final char LONGDIV_CHAR = ')';
    public static final String ELEMENT = "menclose";
    public static final String ATTR_NOTATION = "notation";
    private static final Log LOGGER = LogFactory.getLog(Menclose.class);
    private static final Map<String, Constructor<?>> IMPL_CLASSES = new HashMap();

    public Menclose(MathBase base) {
        super(base);
        this.setDefaultMathAttribute(ATTR_NOTATION, "");
    }

    @Override
    public String getNotation() {
        return this.getMathAttribute(ATTR_NOTATION);
    }

    @Override
    public void setNotation(String notation) {
        this.setAttribute(ATTR_NOTATION, notation);
    }

    @Override
    public String getTagName() {
        return ELEMENT;
    }

    @Override
    protected List<JEuclidElement> createDelegates() {
        JEuclidElement lastChild;
        String[] notations = this.getNotation().split(" ");
        Stack notationImpls = new Stack();
        for (String curNotation : notations) {
            Constructor<?> con = IMPL_CLASSES.get(curNotation.toLowerCase(Locale.ENGLISH));
            if (con != null) {
                notationImpls.push(con);
                continue;
            }
            if (curNotation.length() <= 0) continue;
            LOGGER.info((Object)("Unsupported notation for menclose: " + curNotation));
        }
        if (this.getMathElementCount() != 1) {
            lastChild = new Mrow(this.getMathBase());
            for (JEuclidElement child : ElementListSupport.createListOfChildren(this)) {
                lastChild.appendChild(child);
            }
        } else {
            lastChild = this.getMathElement(0);
        }
        while (!notationImpls.isEmpty()) {
            Constructor con = (Constructor)notationImpls.pop();
            try {
                JEuclidElement element = (JEuclidElement)con.newInstance(this.getMathBase());
                element.appendChild(lastChild);
                lastChild = element;
            }
            catch (InstantiationException e) {
                LOGGER.warn((Object)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn((Object)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.warn((Object)e);
            }
        }
        Vector<JEuclidElement> delegates = new Vector<JEuclidElement>(1);
        delegates.add(lastChild);
        return delegates;
    }

    static {
        try {
            IMPL_CLASSES.put("radical", Msqrt.class.getConstructor(MathBase.class));
            IMPL_CLASSES.put("longdiv", Longdiv.class.getConstructor(MathBase.class));
            IMPL_CLASSES.put("updiagonalstrike", Updiagonalstrike.class.getConstructor(MathBase.class));
            IMPL_CLASSES.put("downdiagonalstrike", Downdiagonalstrike.class.getConstructor(MathBase.class));
        }
        catch (NoSuchMethodException e) {
            LOGGER.fatal((Object)e);
        }
    }

    public static class Downdiagonalstrike
    extends AbstractRowLikeNotation {
        public Downdiagonalstrike(MathBase base) {
            super(base);
        }

        public void paint(Graphics2D g, float posX, float posY) {
            super.paint(g, posX, posY);
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(GraphicsSupport.lineWidth(this)));
            g.draw(new Line2D.Float(posX, posY - this.getHeight(g), posX + this.getWidth(g), posY));
            g.setStroke(oldStroke);
        }
    }

    public static class Updiagonalstrike
    extends AbstractRowLikeNotation {
        public Updiagonalstrike(MathBase base) {
            super(base);
        }

        public void paint(Graphics2D g, float posX, float posY) {
            super.paint(g, posX, posY);
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(GraphicsSupport.lineWidth(this)));
            g.draw(new Line2D.Float(posX, posY, posX + this.getWidth(g), posY - this.getHeight(g)));
            g.setStroke(oldStroke);
        }
    }

    public static abstract class AbstractRowLikeNotation
    extends AbstractRowLike {
        public AbstractRowLikeNotation(MathBase base) {
            super(base);
        }

        public String getTagName() {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Longdiv
    extends AbstractRoot {
        public Longdiv(MathBase base) {
            super(base, ')');
        }

        @Override
        protected JEuclidElement getActualIndex() {
            return new Mspace(this.getMathBase());
        }

        @Override
        protected List<JEuclidElement> getContent() {
            return ElementListSupport.createListOfChildren(this);
        }

        @Override
        public String getTagName() {
            return "";
        }
    }
}

