/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.parser.MathBaseFactory;
import net.sourceforge.jeuclid.parser.Parser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathMLParserSupport {
    private static final Log LOGGER = LogFactory.getLog(MathMLParserSupport.class);

    private MathMLParserSupport() {
    }

    public static MathBase createMathBaseFromDocument(Node document, Map<ParameterKey, String> params) throws SAXException, IOException {
        try {
            return MathBaseFactory.getMathBaseFactory().createMathBase(new DOMSource(document), params);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn((Object)e);
            return null;
        }
    }

    public static MathBase createMathBaseFromFile(File inFile, Map<ParameterKey, String> params) throws SAXException, IOException {
        try {
            return MathBaseFactory.getMathBaseFactory().createMathBase(new StreamSource(new FileInputStream(inFile)), params);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn((Object)e);
            return null;
        }
    }

    public static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilder builder = Parser.getParser().getDocumentBuilder();
        return builder;
    }

    public static Document parseInputStreamXML(InputStream inStream) throws SAXException, IOException {
        try {
            return Parser.getParser().parseStreamSourceAsXml(new StreamSource(inStream));
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn((Object)e);
            return null;
        }
    }

    public static Document parseInputStreamODF(InputStream inStream) throws SAXException, IOException {
        try {
            return Parser.getParser().parseStreamSourceAsOdf(new StreamSource(inStream));
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn((Object)e);
            return null;
        }
    }

    public static Document parseFile(File inFile) throws SAXException, IOException {
        try {
            return Parser.getParser().parseStreamSource(new StreamSource(new FileInputStream(inFile)));
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn((Object)e);
            return null;
        }
    }

    public static Document parseString(String content) throws SAXException, ParserConfigurationException, IOException {
        return Parser.getParser().parseStreamSourceAsXml(new StreamSource(new StringReader(content)));
    }
}

