/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.taskplanner.logaction;

import com.inet.classloader.I18nMessages;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultActionFactory;

/**
 * Server plugin for log action taskplanner plugin.<br>
 * This instance is required to register the result action factory for logging.
 */
@PluginInfo( //
id = "taskplanner.logaction", //
dependencies = "taskplanner", //
optionalDependencies = "", //
packages = "", //
group = "samples", // 
version = "25.10.198", //
icon = "com/inet/taskplanner/logaction/taskplanner_logaction_48.png", //
flags = "" //
)
public class TaskPlannerLogActionServerPlugin implements ServerPlugin {

    /**
     * Print output to the TaskPlanner logger.
     */
    public static final Logger       LOGGER = LogManager.getLogger( "Task Planner" );
    /**
     * Localization of messages
     */
    public static final I18nMessages MSG    = new I18nMessages( "com.inet.taskplanner.logaction.structure.i18n.ConfigStructure", TaskPlannerLogActionServerPlugin.class );

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        // Register the own result action factory implementation
        spm.register( ResultActionFactory.class, new LogResultActionFactory() );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }
}
