/*
 * Decompiled with CFR 0.152.
 */
package com.inet.odbc;

import com.inet.odbc.OdbcConnection;
import com.inet.odbc.OdbcLibrary;
import com.inet.odbc.OdbcParam;
import com.inet.odbc.OdbcStatement;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ShortByReference;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class OdbcPreparedStatement
extends OdbcStatement
implements PreparedStatement {
    private final OdbcParam[] params;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OdbcPreparedStatement(OdbcConnection con, Pointer hStmt, String sql) throws SQLException {
        super(con, hStmt);
        try {
            Object object = con.getLock();
            synchronized (object) {
                byte[] sqlBytes = con.toBytes(sql);
                this.checkSqlReturn(OdbcLibrary.ODBC.SQLPrepare(hStmt, sqlBytes, sqlBytes.length / OdbcLibrary.FACTOR));
                ShortByReference countRef = new ShortByReference();
                this.checkSqlReturn(OdbcLibrary.ODBC.SQLNumParams(hStmt, countRef));
                int count = countRef.getValue();
                this.params = new OdbcParam[count];
                for (int i = 0; i < count; ++i) {
                    this.params[i] = new OdbcParam(this);
                }
            }
        }
        catch (SQLException ex) {
            this.close();
            throw ex;
        }
    }

    private int executeImpl() throws SQLException {
        Object object = this.getConnection().getLock();
        synchronized (object) {
            Pointer hStmt = this.getHStmt();
            try {
                this.checkSqlReturn(OdbcLibrary.ODBC.SQLFreeStmt(hStmt, (short)0));
                for (int i = 0; i < this.params.length; ++i) {
                    OdbcParam param = this.params[i];
                    param.set(i + 1);
                }
                short ret = OdbcLibrary.ODBC.SQLExecute(hStmt);
                if (ret == 99) {
                    ShortByReference countRef = new ShortByReference();
                    this.checkSqlReturn(OdbcLibrary.ODBC.SQLParamData(hStmt, countRef));
                    short paramIdx = countRef.getValue();
                    throw new SQLException("Undefined state: contact the support with repo steps and a JDBC log.");
                }
                this.checkSqlReturn(ret);
                return this.getColumnCount();
            }
            catch (SQLException ex) {
                OdbcLibrary.ODBC.SQLFreeStmt(hStmt, (short)0);
                throw ex;
            }
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.executeQuery(this.executeImpl());
    }

    @Override
    public int executeUpdate() throws SQLException {
        return 0;
    }

    private OdbcParam getParam(int parameterIndex) throws SQLException {
        if (parameterIndex <= 0 || parameterIndex > this.params.length) {
            throw new SQLException("Parameter index out of range: " + parameterIndex, "S1093");
        }
        return this.params[parameterIndex - 1];
    }

    private void setString(int parameterIndex, String x, int sqlType) throws SQLException {
        this.getParam(parameterIndex).setValue(x, sqlType);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.getParam(parameterIndex).setValue(null, sqlType);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.getParam(parameterIndex).setValue(x ? 1 : 0, -7);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, -6);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, 5);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, 4);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, -5);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setDouble(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, 8);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, 2);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        int valueType = x == null || x.length() < 255 ? 12 : -1;
        this.setString(parameterIndex, x, valueType);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        int valueType = x == null || x.length <= 255 ? -3 : -4;
        this.getParam(parameterIndex).setValue(x, valueType);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, 91);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, 92);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.getParam(parameterIndex).setValue(x, 93);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.getParam(parameterIndex).setValue(OdbcPreparedStatement.getBytes(x, length), -4);
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
    }

    @Override
    public boolean execute() throws SQLException {
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        int valueType = x == null || x.length() < 255 ? -9 : -16;
        this.setString(parameterIndex, x, valueType);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.getParam(parameterIndex).setValue(OdbcPreparedStatement.getBytes(inputStream, length), 2004);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (int)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBlob(parameterIndex, inputStream, -1L);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
    }

    private static byte[] getBytes(InputStream input, long length) throws SQLException {
        try {
            if (length < 0L) {
                int nRead;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[16384];
                while ((nRead = input.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                return buffer.toByteArray();
            }
            byte[] bytes = new byte[(int)length];
            DataInputStream dataIs = new DataInputStream(input);
            dataIs.readFully(bytes);
            return bytes;
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }
}

