/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.mongodb;

import com.inet.id.GUID;
import com.inet.persistence.mongodb.MongoDbPersistence;
import com.inet.persistence.spi.PersistenceHelper;
import com.inet.persistence.spi.util.BaseLocks;
import com.inet.thread.CountedReadWriteLock;
import com.inet.thread.ServerLock;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;

class MongoDbLocks
extends BaseLocks {
    private static final String KEY = "key";
    private static final String DATE = "date";
    private HashMap<CountedReadWriteLock, DatabaseTimerLock> locks = new HashMap();
    private MongoCollection<Document> collection;

    MongoDbLocks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerLock tryLock(@Nonnull String key) {
        CountedReadWriteLock readWriteLock = CountedReadWriteLock.tryReadWriteLockInstance((Object)key, (boolean)true);
        if (readWriteLock != null) {
            DatabaseTimerLock databaseLock;
            HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = this.locks;
            synchronized (hashMap) {
                databaseLock = this.tryGetDatabaseTimerLock(key, readWriteLock);
            }
            if (databaseLock != null) {
                return () -> {
                    if (readWriteLock.unlock(true)) {
                        databaseLock.unlock();
                    }
                };
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ServerLock tryReadWriteLock(@Nonnull String key, @Nonnull CountedReadWriteLock readWriteLock, boolean writeLock) {
        DatabaseTimerLock databaseLock;
        HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = this.locks;
        synchronized (hashMap) {
            databaseLock = this.locks.get(readWriteLock);
            if (databaseLock == null) {
                try (ServerLock totalLock = this.repeatTryLock("total:" + key);){
                    Bson filter;
                    String subKey;
                    if (totalLock == null) {
                        ServerLock serverLock = null;
                        return serverLock;
                    }
                    if (writeLock) {
                        subKey = key + ":write";
                        filter = Filters.regex((String)KEY, (String)PersistenceHelper.searchPatternToRegex((String)(key + ":*")));
                    } else {
                        subKey = key + ":" + GUID.generateNew().toString();
                        filter = Filters.eq((String)KEY, (Object)(key + ":write"));
                    }
                    FindIterable keys = this.getCollection().find(filter);
                    if (keys.first() == null) {
                        databaseLock = this.tryGetDatabaseTimerLock(subKey, readWriteLock);
                    }
                }
            }
        }
        if (databaseLock != null) {
            DatabaseTimerLock dbLock = databaseLock;
            return () -> {
                if (readWriteLock.unlock(writeLock)) {
                    dbLock.unlock();
                }
            };
        }
        readWriteLock.unlock(writeLock);
        return null;
    }

    private ServerLock repeatTryLock(@Nonnull String key) {
        for (int i = 0; i < 100; ++i) {
            ServerLock totalLock = this.tryLock(key);
            if (totalLock != null) {
                return totalLock;
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return null;
    }

    @Nonnull
    MongoCollection<Document> getCollection() {
        if (this.collection == null) {
            MongoDatabase db = MongoDbPersistence.getDatabase();
            this.collection = db.getCollection("locks");
            this.collection.createIndex(Indexes.ascending((String[])new String[]{KEY}), new IndexOptions().unique(true));
            this.collection.createIndex(Indexes.ascending((String[])new String[]{DATE}), new IndexOptions().expireAfter(Long.valueOf(5L), TimeUnit.MINUTES));
        }
        return this.collection;
    }

    private DatabaseTimerLock tryGetDatabaseTimerLock(String key, CountedReadWriteLock lock) {
        try {
            DatabaseTimerLock databaseLock = this.locks.get(lock);
            if (databaseLock == null) {
                databaseLock = new DatabaseTimerLock(key, lock);
                this.locks.put(lock, databaseLock);
            }
            return databaseLock;
        }
        catch (Exception e) {
            return null;
        }
    }

    private class DatabaseTimerLock {
        private final String key;
        private final CountedReadWriteLock lock;
        private DefaultTimerTask timer = new DefaultTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runImpl() throws Throwable {
                Bson set = Updates.set((String)MongoDbLocks.DATE, (Object)new Date());
                MongoCollection<Document> collection = MongoDbLocks.this.getCollection();
                DatabaseTimerLock databaseTimerLock = DatabaseTimerLock.this;
                synchronized (databaseTimerLock) {
                    collection.updateOne(Filters.eq((String)MongoDbLocks.KEY, (Object)DatabaseTimerLock.this.key), set, new UpdateOptions().upsert(true));
                }
            }
        };

        private DatabaseTimerLock(String key, CountedReadWriteLock lock) throws Exception {
            this.key = key;
            this.lock = lock;
            Document doc = new Document(MongoDbLocks.KEY, (Object)key);
            doc.put(MongoDbLocks.DATE, (Object)new Date());
            MongoDbLocks.this.getCollection().insertOne((Object)doc);
            DefaultTimer.getInstance().scheduleAtFixedRate(this.timer, 60000L, 60000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlock() {
            this.timer.cancel();
            MongoDbLocks.this.getCollection().deleteOne((Bson)new Document(MongoDbLocks.KEY, (Object)this.key));
            HashMap<CountedReadWriteLock, DatabaseTimerLock> hashMap = MongoDbLocks.this.locks;
            synchronized (hashMap) {
                MongoDbLocks.this.locks.remove(this.lock);
            }
        }
    }
}

