/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.operatordict;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.support.operatordict.DictionaryException;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class OperatorDictionary {
    public static final String DICTIONARY_FILE = "/moDictionary.xml";
    public static final String NAME_VERYVERYTHINMATHSPACE = "veryverythinmathspace";
    public static final String NAME_VERYTHINMATHSPACE = "verythinmathspace";
    public static final String NAME_THINMATHSPACE = "thinmathspace";
    public static final String NAME_MEDIUMMATHSPACE = "mediummathspace";
    public static final String NAME_THICKMATHSPACE = "thickmathspace";
    public static final String NAME_VERYTHICKMATHSPACE = "verythickmathspace";
    public static final String NAME_VERYVERYTHICKMATHSPACE = "veryverythickmathspace";
    public static final String NAME_INFINITY = "infinity";
    public static final int VALUE_PREFIX = 100;
    public static final String FORM_PREFIX = "prefix";
    public static final int VALUE_INFIX = 101;
    public static final String FORM_INFIX = "infix";
    public static final int VALUE_POSTFIX = 102;
    public static final String FORM_POSTFIX = "postfix";
    public static final String VALUE_UNKNOWN = "NULL";
    private static final Log LOGGER = LogFactory.getLog(OperatorDictionary.class);
    private static Map<String, String[][]> dictionary;
    private static boolean isDictionaryRead;
    private static OperatorDictionary instance;
    private static final String[][] ATTRIBUTE_DEFAULT_VALUES;

    OperatorDictionary() throws DictionaryException {
        this.initialize();
    }

    private void initialize() throws DictionaryException {
        try {
            InputStream dictInput = OperatorDictionary.class.getResourceAsStream(DICTIONARY_FILE);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(new DictionaryReader());
            reader.parse(new InputSource(dictInput));
        }
        catch (ParserConfigurationException e) {
            throw new DictionaryException("Cannot get SAXParser:" + e.getMessage());
        }
        catch (SAXException e) {
            throw new DictionaryException("SAXException while parsing dictionary:" + e.getMessage());
        }
        catch (IOException e) {
            throw new DictionaryException("Read error while accessing XML dictionary", e);
        }
    }

    public static String getDefaultAttributeValue(String operator, String form, String attributeName) throws UnknownAttributeException {
        int intForm = FORM_INFIX.equalsIgnoreCase(form) ? 101 : (FORM_POSTFIX.equalsIgnoreCase(form) ? 102 : (FORM_PREFIX.equalsIgnoreCase(form) ? 100 : 101));
        return OperatorDictionary.getDefaultAttributeValue(operator, intForm, attributeName);
    }

    public static String getDefaultAttributeValue(String operator, int form, String attributeName) throws UnknownAttributeException {
        OperatorDictionary.loadDictIfNeeded();
        String retVal = null;
        if (instance != null) {
            retVal = OperatorDictionary.getAttrFromDict(operator, form, attributeName);
        }
        if (retVal == null) {
            retVal = OperatorDictionary.getDefaultValue(attributeName);
        }
        if (retVal != null) {
            return retVal;
        }
        throw new UnknownAttributeException(attributeName);
    }

    private static String getAttrFromDict(String operator, int form, String attributeName) {
        String retVal = null;
        String[][] attribute = OperatorDictionary.readDictValueWithForm(operator, form);
        if (attribute == null) {
            retVal = VALUE_UNKNOWN;
        } else {
            for (String[] element : attribute) {
                if (!element[0].equals(attributeName)) continue;
                retVal = element[1];
                break;
            }
        }
        return retVal;
    }

    private static String[][] readDictValueWithForm(String operator, int form) {
        String[][] attr = dictionary.get(operator + form);
        if (attr == null && form != 101) {
            attr = dictionary.get(operator + 101);
        }
        if (attr == null && form != 102) {
            attr = dictionary.get(operator + 102);
        }
        if (attr == null && form != 100) {
            attr = dictionary.get(operator + 100);
        }
        return attr;
    }

    private static void loadDictIfNeeded() {
        if (!isDictionaryRead) {
            try {
                isDictionaryRead = true;
                instance = new OperatorDictionary();
            }
            catch (DictionaryException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String getDefaultValue(String attributeName) {
        for (String[] element : ATTRIBUTE_DEFAULT_VALUES) {
            if (!attributeName.equalsIgnoreCase(element[0])) continue;
            return element[1];
        }
        return null;
    }

    static {
        ATTRIBUTE_DEFAULT_VALUES = new String[][]{{"form", FORM_INFIX}, {"fence", MathBase.FALSE}, {"separator", MathBase.FALSE}, {"lspace", NAME_THICKMATHSPACE}, {"rspace", NAME_THICKMATHSPACE}, {"stretchy", MathBase.FALSE}, {"symmetric", MathBase.TRUE}, {"maxsize", NAME_INFINITY}, {"minsize", "1"}, {"largeop", MathBase.FALSE}, {"movablelimits", MathBase.FALSE}, {"accent", MathBase.FALSE}};
    }

    private static class DictionaryReader
    extends DefaultHandler {
        private static final String ELEMENT_ELEMENT = "element";
        private static final Log LOGGER = LogFactory.getLog(DictionaryReader.class);
        private String currentOperator;
        private int currentFormIndex;
        private int currentLength;
        private String[][] currentEntry;

        public void startDocument() throws SAXException {
            dictionary = new HashMap();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String rawName, Attributes attlist) throws SAXException {
            if (rawName.equals(ELEMENT_ELEMENT)) {
                this.currentLength = attlist.getLength() - 1;
                this.currentEntry = new String[this.currentLength][2];
                String form = attlist.getValue("form");
                if (form == null) {
                    LOGGER.fatal((Object)"Error in dictionary, attribute 'form' is required attribute for the dictionary");
                    this.currentFormIndex = 101;
                } else if (form.equals(OperatorDictionary.FORM_PREFIX)) {
                    this.currentFormIndex = 100;
                } else if (form.equals(OperatorDictionary.FORM_INFIX)) {
                    this.currentFormIndex = 101;
                } else if (form.equals(OperatorDictionary.FORM_POSTFIX)) {
                    this.currentFormIndex = 102;
                }
                int index = 0;
                for (int i = 0; i < this.currentLength + 1; ++i) {
                    String attName = attlist.getQName(i);
                    String attValue = attlist.getValue(i);
                    if (attName.equals("form")) continue;
                    this.currentEntry[index][0] = attName;
                    this.currentEntry[index][1] = attValue;
                    ++index;
                }
            }
        }

        public void endElement(String uri, String localName, String rawName) throws SAXException {
            if (rawName.equals(ELEMENT_ELEMENT)) {
                String key = this.currentOperator + this.currentFormIndex;
                Object existedEntry = dictionary.get(key);
                if (existedEntry == null) {
                    dictionary.put(key, this.currentEntry);
                } else {
                    LOGGER.error((Object)("Objects " + key + " exists twice in operator dictionary!"));
                }
            }
            this.currentEntry = null;
            this.currentOperator = null;
        }

        public void characters(char[] data, int start, int length) throws SAXException {
            if (this.currentEntry != null) {
                char[] temp = new char[length];
                System.arraycopy(data, start, temp, 0, length);
                this.currentOperator = this.currentOperator == null ? new String(temp) : this.currentOperator + new String(temp);
                this.currentOperator = this.currentOperator.trim();
            }
        }
    }
}

