/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.general.AbstractRowLike;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.mathml.MathMLStyleElement;

public class Mstyle
extends AbstractRowLike
implements MathMLStyleElement {
    public static final String ATTR_SCRIPTMINSIZE = "scriptminsize";
    public static final String ATTR_SCRIPTLEVEL = "scriptlevel";
    public static final String ATTR_SCRIPTSIZEMULTIPLIER = "scriptsizemultiplier";
    public static final String ATTR_DISPLAYSTYLE = "displaystyle";
    public static final String ELEMENT = "mstyle";
    private static final Log LOGGER = LogFactory.getLog(Mstyle.class);

    public Mstyle(MathBase base) {
        super(base);
        this.setDefaultMathAttribute(ATTR_DISPLAYSTYLE, "");
    }

    public String getScriptlevel() {
        return this.getMathAttribute(ATTR_SCRIPTLEVEL);
    }

    public void setScriptlevel(String scriptlevel) {
        this.setAttribute(ATTR_SCRIPTLEVEL, scriptlevel);
    }

    public String getScriptminsize() {
        return this.getMathAttribute(ATTR_SCRIPTMINSIZE);
    }

    public void setScriptminsize(String scriptminsize) {
        this.setAttribute(ATTR_SCRIPTMINSIZE, scriptminsize);
    }

    protected int getAbsoluteScriptLevel() {
        int theLevel;
        try {
            String attr = this.getScriptlevel();
            if (attr == null) {
                attr = "";
            }
            if ((attr = attr.trim()).length() == 0) {
                theLevel = this.getInheritedScriptlevel();
            } else {
                char firstchar = attr.charAt(0);
                boolean relative = false;
                if (firstchar == '+') {
                    relative = true;
                    attr = attr.substring(1);
                } else if (firstchar == '-') {
                    relative = true;
                }
                int iValue = Integer.parseInt(attr);
                theLevel = relative ? this.getInheritedScriptlevel() + iValue : iValue;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn((Object)("Error in scriptlevel attribute for mstyle: " + this.getScriptlevel()));
            theLevel = this.getInheritedScriptlevel();
        }
        return theLevel;
    }

    public boolean isChildBlock(JEuclidElement child) {
        String displayStyle = this.getDisplaystyle();
        if (displayStyle.length() > 0) {
            boolean dValue = Boolean.parseBoolean(displayStyle);
            return dValue;
        }
        return super.isChildBlock(child);
    }

    public String getTagName() {
        return ELEMENT;
    }

    public String getBackground() {
        return this.getMathbackground();
    }

    public String getColor() {
        return this.getMathcolor();
    }

    public String getDisplaystyle() {
        return this.getMathAttribute(ATTR_DISPLAYSTYLE);
    }

    public String getScriptsizemultiplier() {
        return this.getMathAttribute(ATTR_SCRIPTSIZEMULTIPLIER);
    }

    public void setBackground(String background) {
        this.setMathbackground(background);
    }

    public void setColor(String color) {
        this.setMathcolor(color);
    }

    public void setDisplaystyle(String displaystyle) {
        this.setAttribute(ATTR_DISPLAYSTYLE, displaystyle);
    }

    public void setScriptsizemultiplier(String scriptsizemultiplier) {
        this.setAttribute(ATTR_SCRIPTSIZEMULTIPLIER, scriptsizemultiplier);
    }

    public String getMediummathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativemediummathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativethickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativethinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativeverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativeverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativeveryverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getNegativeveryverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getThickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getThinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getVerythickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getVerythinmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getVeryverythickmathspace() {
        throw new UnsupportedOperationException();
    }

    public String getVeryverythinmathspace() {
        throw new UnsupportedOperationException();
    }

    public void setMediummathspace(String mediummathspace) {
        throw new UnsupportedOperationException();
    }

    public void setNegativemediummathspace(String negativemediummathspace) {
        throw new UnsupportedOperationException();
    }

    public void setNegativethickmathspace(String negativethickmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setNegativethinmathspace(String negativethinmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setNegativeverythickmathspace(String negativeverythickmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setNegativeverythinmathspace(String negativeverythinmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setNegativeveryverythickmathspace(String negativeveryverythickmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setNegativeveryverythinmathspace(String negativeveryverythinmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setThickmathspace(String thickmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setThinmathspace(String thinmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setVerythickmathspace(String verythickmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setVerythinmathspace(String verythinmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setVeryverythickmathspace(String veryverythickmathspace) {
        throw new UnsupportedOperationException();
    }

    public void setVeryverythinmathspace(String veryverythinmathspace) {
        throw new UnsupportedOperationException();
    }
}

