/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.generic;

import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.dom.AbstractPartialDocumentImpl;
import net.sourceforge.jeuclid.dom.ChangeTrackingInterface;
import net.sourceforge.jeuclid.elements.DisplayableNode;
import net.sourceforge.jeuclid.elements.JEuclidNode;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import org.w3c.dom.mathml.MathMLDocument;

public class DocumentElement
extends AbstractPartialDocumentImpl
implements MathMLDocument,
JEuclidNode,
ChangeTrackingInterface,
DisplayableNode {
    private MathBase mathbase;
    private final Set<ChangeTrackingInterface> listeners = new HashSet<ChangeTrackingInterface>();
    private float lastX;
    private float lastY;

    public DocumentElement(MathBase base) {
        this.mathbase = base;
    }

    public String getDomain() {
        throw new UnsupportedOperationException();
    }

    public String getReferrer() {
        throw new UnsupportedOperationException();
    }

    public String getURI() {
        throw new UnsupportedOperationException();
    }

    public void paint(Graphics2D g, float posX, float posY) {
        ElementListSupport.paint(g, posX, posY, ElementListSupport.createListOfChildren(this));
        this.lastX = posX;
        this.lastY = posY;
    }

    public float getWidth(Graphics2D g) {
        return ElementListSupport.getWidth(g, ElementListSupport.createListOfChildren(this));
    }

    public float getAscentHeight(Graphics2D g) {
        return ElementListSupport.getAscentHeight(g, ElementListSupport.createListOfChildren(this));
    }

    public float getDescentHeight(Graphics2D g) {
        return ElementListSupport.getDescentHeight(g, ElementListSupport.createListOfChildren(this));
    }

    public void setMathBase(MathBase base) {
        this.mathbase = base;
    }

    public float getMathsizeInPoint() {
        return this.mathbase.getFontSize();
    }

    public float getFontsizeInPoint() {
        return this.mathbase.getFontSize();
    }

    public void addListener(ChangeTrackingInterface listener) {
        this.listeners.add(listener);
    }

    public void fireChanged(boolean propagate) {
        if (propagate) {
            for (ChangeTrackingInterface listener : this.listeners) {
                listener.fireChanged(false);
            }
        }
    }

    public void fireChangeForSubTree() {
        ElementListSupport.fireChangeForSubTree(ElementListSupport.createListOfChildren(this));
    }

    public float getHeight(Graphics2D g) {
        return this.getAscentHeight(g) + this.getDescentHeight(g);
    }

    public float getPaintedPosX() {
        return this.lastX;
    }

    public float getPaintedPosY() {
        return this.lastY;
    }

    public float getXCenter(Graphics2D g) {
        return this.getWidth(g) / 2.0f;
    }
}

