/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.app;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.sourceforge.jeuclid.Converter;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.ParameterKey;
import net.sourceforge.jeuclid.app.support.CommandLineParser;

public final class Mml2xxx {
    private static final String COLON = ": ";
    private static final String SPACE = " ";

    private Mml2xxx() {
    }

    public static void main(String[] args) {
        try {
            CommandLineParser.ParseResults parseResults = CommandLineParser.parseCommandLine(args);
            File source = parseResults.getSource();
            File target = parseResults.getTarget();
            Map<ParameterKey, String> params = MathBase.getDefaultParameters();
            boolean mimeTypeIsSet = parseResults.getParams().containsKey((Object)ParameterKey.OutFileType);
            params.putAll(parseResults.getParams());
            if (source == null) {
                throw new IllegalArgumentException("No source given");
            }
            if (target == null) {
                throw new IllegalArgumentException("No target given");
            }
            if (!source.isFile()) {
                throw new IllegalArgumentException("Source is not a file");
            }
            if (!mimeTypeIsSet) {
                String fileName = target.getName();
                String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
                String mimetype = Converter.getMimeTypeForSuffix(extension);
                params.put(ParameterKey.OutFileType, mimetype);
            }
            Converter.convert(source, target, params);
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            Mml2xxx.showUsage();
            System.out.println(aiobe.getClass().toString() + COLON + aiobe.getMessage());
        }
        catch (IllegalArgumentException ia) {
            Mml2xxx.showUsage();
            System.out.println(ia.getClass().toString() + COLON + ia.getMessage());
        }
        catch (IOException e) {
            Mml2xxx.showUsage();
            System.out.println(e.getClass().toString() + COLON + e.getMessage());
        }
    }

    private static void showUsage() {
        System.out.println("JEuclid BasicConverter");
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("mml2xxx source target (option value)*");
        System.out.println("");
        System.out.println("where:");
        System.out.println(" source is the path to the source file (MathML or ODF format)");
        System.out.println(" target is the path to the target file");
        System.out.println("Possible options (with default value):");
        ParameterKey[] options = ParameterKey.values();
        for (int i = 0; i < options.length; ++i) {
            ParameterKey param = options[i];
            String name = param.name();
            System.out.print(" -" + name);
            System.out.print(SPACE);
            System.out.println(MathBase.getDefaultParameters().get((Object)param));
        }
        System.out.println("The following output types are supported:");
        System.out.print("   ");
        for (String type : Converter.getAvailableOutfileTypes()) {
            System.out.print(SPACE + type);
        }
        System.out.println();
        System.out.println("Example: ");
        System.out.println("  mml2xxx a.mml a.png -BackgroundColor white");
        System.out.println();
        System.out.println();
    }
}

