/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.classloader.translations.TranslationKey;
import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.notification.search.SearchTagExternalDispatcher;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionManager;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.InetcoreServerPlugin;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.FieldDisplayNameProvider;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.CoreStringUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.EmailUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.StringUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UF_Visibility;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.fields.FieldEmail;
import com.inet.usersandgroups.api.user.fields.FieldFirstName;
import com.inet.usersandgroups.api.user.fields.FieldLastName;
import com.inet.usersandgroups.api.user.fields.FieldNote;
import com.inet.usersandgroups.api.user.fields.FieldTelephone;
import com.inet.usersandgroups.api.user.fields.FieldUserBlockingNotice;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class UsersAndGroups {
    public static final Permission PERMISSION_USERS_AND_GROUPS_MANAGER = SystemPermissionManager.add("userManager", "administration", null, 6400, false, InetcoreServerPlugin.class);
    public static final Permission PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS = SystemPermissionManager.add("userManagerCreateUsers", "administration", "userManager", 6405, false, InetcoreServerPlugin.class);
    public static final Permission PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN = SystemPermissionManager.add("userManagerAdmin", "administration", "userManagerCreateUsers", 6410, false, InetcoreServerPlugin.class);
    public static final Logger LOGGER = LogManager.getLogger("Users And Groups");
    public static final I18nMessages MSG = new I18nMessages("com.inet.usersandgroups.i18n.ConfigStructure", UsersAndGroups.class);
    @Nonnull
    public static final GroupType GROUPTYPE_ALLUSERS = GroupType.of("*");
    @Nonnull
    public static final GroupType GROUPTYPE_ADMIN = GroupType.of("administration");
    @Nonnull
    public static final GroupType GROUPTYPE_AUTH = GroupType.of("authentication");
    @Nonnull
    public static final GroupType GROUPTYPE_STANDARD = GroupType.of("standard");
    @Nonnull
    public static final GUID GROUPID_ALLUSERS = GUID.valueOf("sys00paaukvarqba17x9hxc09");
    @Nonnull
    public static final GUID GROUPID_ADMIN = GUID.valueOf("sys01og8a626ajrepb47rblh0");
    public static final GroupTypeDef GROUPTYPEDEF_ALLUSERS = new GroupTypeDef(10, GROUPTYPE_ALLUSERS, new GroupTypeDef.GroupTypeRestrictions[]{GroupTypeDef.GroupTypeRestrictions.PreventCreation, GroupTypeDef.GroupTypeRestrictions.PreventMembershipEditing, GroupTypeDef.GroupTypeRestrictions.PreventRenaming, GroupTypeDef.GroupTypeRestrictions.PreventRemoval}){

        @Override
        public String getDisplayName() {
            return MSG.getMsg("grouptype." + this.getGroupType().getName(), new Object[0]);
        }

        @Override
        public String getDescription() {
            return MSG.getMsg("grouptype." + this.getGroupType().getName() + ".description", new Object[0]);
        }

        @Override
        public URL getIconURL(int size) {
            if (size <= 32) {
                return this.getClass().getResource("/com/inet/usersandgroups/images/allusers_32.png");
            }
            return this.getClass().getResource("/com/inet/usersandgroups/images/allusers_96.png");
        }

        @Override
        public boolean isSystemGroup() {
            return true;
        }
    };
    public static final GroupTypeDef GROUPTYPEDEF_ADMIN = new GroupTypeDef(20, GROUPTYPE_ADMIN, new GroupTypeDef.GroupTypeRestrictions[]{GroupTypeDef.GroupTypeRestrictions.PreventCreation, GroupTypeDef.GroupTypeRestrictions.PreventPermissionEditing, GroupTypeDef.GroupTypeRestrictions.PreventRenaming, GroupTypeDef.GroupTypeRestrictions.PreventRemoval, GroupTypeDef.GroupTypeRestrictions.PreventDeactivation}){

        @Override
        public String getDisplayName() {
            return MSG.getMsg("grouptype." + this.getGroupType().getName(), new Object[0]);
        }

        @Override
        public String getDescription() {
            return MSG.getMsg("grouptype." + this.getGroupType().getName() + ".description", new Object[0]);
        }

        @Override
        public URL getIconURL(int size) {
            if (size <= 32) {
                return this.getClass().getResource("/com/inet/usersandgroups/images/admingroups_32.png");
            }
            return this.getClass().getResource("/com/inet/usersandgroups/images/admingroups_96.png");
        }

        @Override
        public boolean isSystemGroup() {
            return true;
        }
    };
    public static final GroupTypeDef GROUPTYPEDEF_AUTH = new GroupTypeDef(200, GROUPTYPE_AUTH, new GroupTypeDef.GroupTypeRestrictions[]{GroupTypeDef.GroupTypeRestrictions.PreventMembershipEditing, GroupTypeDef.GroupTypeRestrictions.PreventDeactivation}){

        @Override
        public String getDisplayName() {
            return MSG.getMsg("grouptype." + this.getGroupType().getName(), new Object[0]);
        }

        @Override
        public String getDescription() {
            return MSG.getMsg("grouptype." + this.getGroupType().getName() + ".description", new Object[0]);
        }

        @Override
        public String getCreateLabel() {
            return MSG.getMsg("grouptype." + this.getGroupType().getName() + ".createlabel", new Object[0]);
        }

        @Override
        public URL getIconURL(int size) {
            if (size <= 32) {
                return this.getClass().getResource("/com/inet/usersandgroups/images/authgroups_32.png");
            }
            return this.getClass().getResource("/com/inet/usersandgroups/images/authgroups_96.png");
        }
    };
    public static final GroupTypeDef GROUPTYPEDEF_STANDARD = new GroupTypeDef(100, GROUPTYPE_STANDARD, new GroupTypeDef.GroupTypeRestrictions[]{GroupTypeDef.GroupTypeRestrictions.PreventDeactivation}){

        @Override
        public String getDisplayName() {
            ApplicationDescription applicationDescription = ApplicationDescription.get();
            String string = applicationDescription.getRemoteGuiInformation().getProductTitle();
            return MSG.getMsg("grouptype." + this.getGroupType().getName(), string);
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getCreateLabel() {
            ApplicationDescription applicationDescription = ApplicationDescription.get();
            String string = applicationDescription.getRemoteGuiInformation().getProductTitle();
            return MSG.getMsg("grouptype." + this.getGroupType().getName() + ".createlabel", string);
        }

        @Override
        public URL getIconURL(int size) {
            if (size <= 32) {
                return this.getClass().getResource("/com/inet/usersandgroups/images/usergroups_32.png");
            }
            return this.getClass().getResource("/com/inet/usersandgroups/images/usergroups_96.png");
        }
    };
    @Nonnull
    public static final UserGroupKey GROUP_ALLUSERS = UserGroupKey.of("*", GROUPTYPE_ALLUSERS);
    @Nonnull
    public static final UserGroupKey GROUP_ADMINISTRATORS = UserGroupKey.of("Administrators", GROUPTYPE_ADMIN);
    @Nonnull
    public static final FieldFirstName FIELD_FIRSTNAME = new FieldFirstName();
    @Nonnull
    public static final FieldLastName FIELD_LASTNAME = new FieldLastName();
    @Nonnull
    public static final FieldEmail FIELD_EMAIL = new FieldEmail();
    @Nonnull
    public static final FieldNote FIELD_NOTE = new FieldNote();
    @Nonnull
    public static final FieldTelephone FIELD_TELEPHONE = new FieldTelephone();
    @Nonnull
    public static final FieldUserBlockingNotice FIELD_USER_LOCKED = new FieldUserBlockingNotice();
    @Nonnull
    public static final UserField<String> USERFIELD_CONFIG_VIEWCONFIG = new UserField<String>("config_viewconfig", FieldTypeFactory.auto().withoutSearchTag()){};
    public static final UserField<String> FIELD_NOTIFICATIONSETTINGS = new UserField<String>("notificationsettings", FieldTypeFactory.custom()){

        @Override
        @Nonnull
        public FieldType<String> createFieldType() {
            return new FieldTypeString(this.getKey(), () -> this.getLabel()){

                @Override
                public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory fieldTypeFactory) {
                    return new SearchTagExternalDispatcher();
                }
            };
        }
    };
    public static final StringUserFieldDefinition FIELD_DEF_FIRSTNAME = new CoreStringUserFieldDefinition("user.masterdata", 100, FIELD_FIRSTNAME);
    public static final StringUserFieldDefinition FIELD_DEF_LASTNAME = new CoreStringUserFieldDefinition("user.masterdata", 110, FIELD_LASTNAME);
    public static final EmailUserFieldDefinition FIELD_DEF_EMAIL = new EmailUserFieldDefinition("user.masterdata", FIELD_EMAIL.getKey(), 160);
    public static final StringUserFieldDefinition FIELD_DEF_NOTE = new CoreStringUserFieldDefinition("user.masterdata", 300, (UserField)FIELD_NOTE){
        {
            this.setVisibility(UF_Visibility.VISIBLE_ONLY_FOR_USER_MANAGER);
        }

        @Override
        public boolean isBatchEditable() {
            return true;
        }

        @Override
        public String getDisplayType() {
            return "fieldtype_multiline";
        }
    };
    public static final StringUserFieldDefinition FIELD_DEF_TELEPHONE = new CoreStringUserFieldDefinition("user.masterdata", 130, (UserField)FIELD_TELEPHONE){

        @Override
        public boolean isBatchEditable() {
            return true;
        }
    };

    @Nonnull
    public static List<UserField<?>> getFieldsForRegistration() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(FIELD_FIRSTNAME);
        arrayList.add(FIELD_LASTNAME);
        arrayList.add(FIELD_EMAIL);
        arrayList.add(FIELD_NOTE);
        arrayList.add(FIELD_TELEPHONE);
        arrayList.add(FIELD_USER_LOCKED);
        arrayList.add(USERFIELD_CONFIG_VIEWCONFIG);
        arrayList.add(FIELD_NOTIFICATIONSETTINGS);
        return arrayList;
    }

    public static Set<GroupTypeDef> getGroupTypeDefinitionsForRegistration() {
        HashSet<GroupTypeDef> hashSet = new HashSet<GroupTypeDef>();
        hashSet.add(GROUPTYPEDEF_ALLUSERS);
        hashSet.add(GROUPTYPEDEF_ADMIN);
        hashSet.add(GROUPTYPEDEF_AUTH);
        hashSet.add(GROUPTYPEDEF_STANDARD);
        return hashSet;
    }

    public static Set<PredefinedUserGroup> getPredefinedUserGroupsForRegistration() {
        HashSet<PredefinedUserGroup> hashSet = new HashSet<PredefinedUserGroup>();
        hashSet.add(new PredefinedUserGroup(GROUP_ALLUSERS, GROUPID_ALLUSERS, new MutableUserGroupData()){

            @Override
            @Nonnull
            public String getDisplayName() {
                return MSG.getMsg("group.allusers", new Object[0]);
            }
        });
        hashSet.add(new PredefinedUserGroup(GROUP_ADMINISTRATORS, GROUPID_ADMIN, new MutableUserGroupData()){

            @Override
            @Nonnull
            public String getDisplayName() {
                return MSG.getMsg("group.administrators", new Object[0]);
            }
        });
        return hashSet;
    }

    public static String getFieldDisplayName(String fieldKey) {
        return FieldDisplayNameProvider.getDisplayNameFor(MSG, fieldKey);
    }

    public static TranslationKey getFieldDisplayNameKey(String fieldKey) {
        return new TranslationKey("inetcore", MSG.getBundle().getBaseBundleName(), ClientLocale.getThreadLocale().getLanguage(), "field." + fieldKey);
    }

    public static String getFieldDisplayDescription(String fieldKey) {
        return MSG.getMsg_(ClientLocale.getThreadLocale(), "field." + fieldKey + ".description", true, new Object[0]);
    }

    public static <T extends Field> void throwIfRegisteredFieldsHaveNonUniqueKeys(List<T> registeredFields, Class<T> fieldType) {
        List list = registeredFields.stream().map(Field::getKey).collect(Collectors.toList());
        long l2 = list.stream().distinct().count();
        if ((long)list.size() != l2) {
            String string = String.format("Fields registered for type %s must have unique keys: %s", fieldType.getSimpleName(), list);
            throw new IllegalArgumentException(string);
        }
    }

    public static <T extends Field> void throwIfKeysOfRegisteredFieldsCollideWithReservedKeys(List<String> reservedFieldKeys, List<String> registeredFields, Class<T> fieldType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = registeredFields;
        for (String string : reservedFieldKeys) {
            if (!list.contains(string.toLowerCase())) continue;
            arrayList.add(string);
        }
        if (!arrayList.isEmpty()) {
            String string = String.format("Fields registered for type %s may not have keys that are reserved: %s", fieldType.getSimpleName(), arrayList);
            throw new IllegalArgumentException(string);
        }
    }

    public static <T> void throwIfNullOrContainsNull(Collection<T> toCheck, String name) {
        if (toCheck == null) {
            throw new IllegalArgumentException(String.format("%s must not be null", name));
        }
        try {
            if (toCheck.contains(null)) {
                throw new IllegalArgumentException(String.format("%s must not contain null", name));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static <T> UserField<T> getFieldByKey(String key) {
        for (UserField userField : DynamicExtensionManager.getInstance().get(UserField.class)) {
            if (!userField.getKey().equals(key)) continue;
            return userField;
        }
        return null;
    }

    public static <T> UserGroupField<T> getGroupFieldByKey(String key) {
        for (UserGroupField userGroupField : DynamicExtensionManager.getInstance().get(UserGroupField.class)) {
            if (!userGroupField.getKey().equals(key)) continue;
            return userGroupField;
        }
        return null;
    }

    public static <T> UserFieldDefinition<T> getUserFieldDefinitionByKey(String key) {
        for (FieldDefinition fieldDefinition : DynamicExtensionManager.getInstance().get(FieldDefinition.class)) {
            if (fieldDefinition.getGroupingType() != Type.user || !key.equals(fieldDefinition.getFieldKey())) continue;
            return (UserFieldDefinition)fieldDefinition;
        }
        return null;
    }

    public static <T> GroupFieldDefinition<T> getUserGroupFieldDefinitionByKey(String key) {
        for (FieldDefinition fieldDefinition : DynamicExtensionManager.getInstance().get(FieldDefinition.class)) {
            if (fieldDefinition.getGroupingType() != Type.group || !key.equals(fieldDefinition.getFieldKey())) continue;
            return (GroupFieldDefinition)fieldDefinition;
        }
        return null;
    }

    public static String getFullGroupDisplayName(@Nonnull UserGroupInfo group) {
        UserGroupInfo userGroupInfo;
        UserGroupManager userGroupManager = UserGroupManager.getInstance();
        Object object = group.getDisplayName();
        GUID gUID = group.getParentID();
        while (gUID != null && (userGroupInfo = userGroupManager.getGroup(gUID)) != null) {
            object = userGroupInfo.getDisplayName() + "/" + (String)object;
            gUID = userGroupInfo.getParentID();
        }
        return object;
    }
}

