/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.logging.LogManager;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class MemoryStream
extends OutputStream
implements DataOutput,
Serializable {
    private static final long serialVersionUID = 7189591723356190571L;
    private static final byte[] a = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] b = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final char[] c = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private byte @Nonnull [] d;
    private int e;

    public MemoryStream() {
        this(512);
    }

    public MemoryStream(int size) {
        this.d = new byte[size];
    }

    @Override
    public void writeBoolean(boolean b2) {
        this.write(b2 ? 1 : 0);
    }

    public void writeUTF8Boolean(boolean b2) {
        this.writeUTF8Int(b2 ? 1 : 0);
    }

    @Override
    public void writeByte(int b2) {
        this.write(b2);
    }

    @Override
    public void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    @Override
    public void write(int b2) {
        if (this.e >= this.d.length) {
            this.a(this.e + 1);
        }
        this.d[this.e++] = (byte)b2;
    }

    @Override
    public void writeUTF(String str) {
        int n2 = this.e;
        this.a(this.e + 2);
        this.e += 2;
        this.writeUTF8(str);
        int n3 = this.e - n2 - 2;
        if (n3 > 65535) {
            this.e = n2;
            throw new IllegalStateException("Max UFT Length reached");
        }
        this.patchShort(n2, n3);
    }

    public void writeUTF8(String str) {
        int n2 = str.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = str.charAt(i2);
            if (n3 != 0) {
                n4 = ((n3 & 0x3FF) << 10 | n4 & 0x3FF) + 65536;
                n3 = 0;
                this.writeCharUtf8(n4);
                continue;
            }
            if (n4 >= 55296 && n4 <= 56319) {
                n3 = n4;
                continue;
            }
            this.writeCharUtf8(n4);
        }
        if (n3 != 0) {
            this.writeCharUtf8(n3);
        }
    }

    public void writeASCII(String str) {
        int n2 = str.length();
        this.a(this.e + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.d[this.e++] = (byte)str.charAt(i2);
        }
    }

    @Override
    public void write(byte @Nonnull [] bytes, int off, int len) {
        int n2 = this.e + len;
        this.a(n2);
        System.arraycopy(bytes, off, this.d, this.e, len);
        this.e = n2;
    }

    private void a(int n2) {
        if (n2 > this.d.length) {
            this.b(n2);
        }
    }

    private void b(int n2) {
        byte[] byArray;
        int n3 = this.e > 1000000 ? n2 + 1000000 : (this.d.length << 1 > n2 ? this.d.length << 1 : n2);
        try {
            byArray = new byte[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            try {
                if (LogManager.getApplicationLogger().isDebug()) {
                    LogManager.getApplicationLogger().debug("OutOfMemoryError in MemoryStream:" + n3);
                }
                Thread.yield();
                byArray = new byte[n2];
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                throw new OutOfMemoryError("OutOfMemoryError in MemoryStream:" + n3);
            }
        }
        System.arraycopy(this.d, 0, byArray, 0, this.e);
        this.d = byArray;
    }

    @Override
    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.d, 0, this.e);
    }

    public void writeTo(MemoryStream out) {
        out.write(this.d, 0, this.e);
    }

    public void writeTo(OutputStream out, int offset, int len) throws IOException {
        if (offset + len > this.e) {
            throw new ArrayIndexOutOfBoundsException("index=" + (offset + len) + " size=" + this.e);
        }
        out.write(this.d, offset, len);
    }

    public void writeTo(MemoryStream out, int offset, int len) {
        if (offset + len > this.e) {
            throw new ArrayIndexOutOfBoundsException("index=" + (offset + len) + " size=" + this.e);
        }
        out.write(this.d, offset, len);
    }

    public void reset() {
        this.e = 0;
    }

    public byte @Nonnull [] toByteArray() {
        int n2 = this.e;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.d, 0, byArray, 0, n2);
        return byArray;
    }

    public int size() {
        return this.e;
    }

    @Nonnull
    public String toString() {
        return new String(this.d, 0, this.e);
    }

    @Override
    public void writeShort(int value) {
        this.a(this.e + 2);
        this.d[this.e++] = (byte)(value >> 8);
        this.d[this.e++] = (byte)value;
    }

    @Override
    public void writeInt(int value) {
        this.a(this.e + 4);
        this.d[this.e++] = (byte)(value >> 24);
        this.d[this.e++] = (byte)(value >> 16);
        this.d[this.e++] = (byte)(value >> 8);
        this.d[this.e++] = (byte)value;
    }

    @Override
    public void writeLong(long value) {
        this.writeInt((int)(value >> 32));
        this.writeInt((int)value);
    }

    public void writeInversShort(int value) {
        this.a(this.e + 2);
        this.d[this.e++] = (byte)value;
        this.d[this.e++] = (byte)(value >> 8);
    }

    public void writeInverseInt(int value) {
        this.a(this.e + 4);
        this.d[this.e++] = (byte)value;
        this.d[this.e++] = (byte)(value >> 8);
        this.d[this.e++] = (byte)(value >> 16);
        this.d[this.e++] = (byte)(value >> 24);
    }

    public void writeInverseLong(long value) {
        this.writeInverseInt((int)value);
        this.writeInverseInt((int)(value >> 32));
    }

    public void writeInverseDouble(double value) {
        long l2 = Double.doubleToLongBits(value);
        this.writeInverseLong(l2);
    }

    @Override
    public void writeDouble(double value) {
        long l2 = Double.doubleToLongBits(value);
        this.writeLong(l2);
    }

    public void replaceDWord(int value, int position) {
        this.d[position++] = (byte)(value & 0xFF);
        this.d[position++] = (byte)(value >> 8 & 0xFF);
        this.d[position++] = (byte)(value >> 16 & 0xFF);
        this.d[position] = (byte)(value >> 24 & 0xFF);
    }

    public void replaceInt(int value, int position) {
        this.d[position++] = (byte)(value >> 24);
        this.d[position++] = (byte)(value >> 16);
        this.d[position++] = (byte)(value >> 8);
        this.d[position] = (byte)value;
    }

    public void replaceWord(int value, int position) {
        this.d[position++] = (byte)(value & 0xFF);
        this.d[position] = (byte)(value >> 8 & 0xFF);
    }

    public void replaceByte(int value, int position) {
        if (position < 0 || position > this.e) {
            return;
        }
        this.d[position] = (byte)(value & 0xFF);
    }

    public void replaceBytes(byte[] byteArray, int byteArrayPosition, int bufferPosition, int length) {
        if (byteArrayPosition + length > byteArray.length) {
            length = byteArray.length - byteArrayPosition;
        }
        if (length <= 0) {
            return;
        }
        int n2 = bufferPosition + length;
        if (n2 > this.e) {
            if (n2 > this.d.length) {
                byte[] byArray = new byte[Math.max(this.d.length << 1, n2)];
                System.arraycopy(this.d, 0, byArray, 0, this.e);
                this.d = byArray;
            }
            this.e = n2;
        }
        System.arraycopy(byteArray, byteArrayPosition, this.d, bufferPosition, length);
    }

    @Deprecated
    public void writeString(String str) {
        this.writeASCII(str);
    }

    public void writeStringJava2(CharSequence str) {
        if (str == null) {
            this.writeUTF8Int(-1);
            return;
        }
        int n2 = str.length();
        this.writeUTF8Int(n2);
        int n3 = this.e + n2 * 2;
        this.a(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = str.charAt(i2);
            this.d[this.e++] = (byte)(c2 >> 8);
            this.d[this.e++] = (byte)c2;
        }
    }

    public void setLength(int length) {
        if (length < 0) {
            return;
        }
        if (length > this.e) {
            if (length > this.d.length) {
                byte[] byArray = new byte[length];
                System.arraycopy(this.d, 0, byArray, 0, this.e);
                this.d = byArray;
            }
            for (int i2 = this.e; i2 < length; ++i2) {
                this.d[i2] = 0;
            }
        }
        this.e = length;
    }

    public int getLength() {
        return this.e;
    }

    public void writeIntAsString(int i2) {
        if (i2 == 0) {
            this.write(48);
            return;
        }
        if (i2 < 0) {
            this.write(45);
            i2 = -i2;
        }
        int n2 = 0;
        int n3 = i2;
        while (n3 > 99) {
            n3 /= 100;
            n2 += 2;
        }
        if (n3 > 0) {
            ++n2;
        }
        if (n3 > 9) {
            ++n2;
        }
        if ((n2 += this.e) > this.d.length) {
            this.a(n2);
        }
        this.e = n2;
        while (i2 > 99) {
            int n4 = i2 - (i2 /= 100) * 100;
            this.d[--n2] = a[n4];
            this.d[--n2] = b[n4];
        }
        if (i2 > 0) {
            this.d[--n2] = a[i2];
        }
        if (i2 > 9) {
            this.d[--n2] = b[i2];
        }
    }

    public void writeTwipsAsPoints(int twips) {
        if (twips < 0) {
            twips = -twips;
            this.write(45);
        }
        this.writeIntAsString(twips / 20);
        int n2 = twips % 20;
        if (n2 != 0) {
            this.write(46);
            this.write(a[n2 >> 1]);
            if ((n2 & 1) != 0) {
                this.write(a[5]);
            }
        }
    }

    public void writeFloatAsString(float f2) {
        if (f2 < 0.0f) {
            f2 = -f2;
            this.write(45);
        }
        int n2 = (int)f2;
        int n3 = -1 * this.e;
        this.writeIntAsString(n2);
        if ((f2 -= (float)n2) == 0.0f || (n3 += this.e) == 8) {
            return;
        }
        int n4 = this.e;
        this.write(46);
        while (n3 < 8) {
            if (f2 == 0.0f) {
                return;
            }
            n2 = (int)(f2 *= 10.0f);
            f2 -= (float)n2;
            this.write(a[n2]);
            if (n2 != 0) {
                n4 = this.e;
            }
            ++n3;
        }
        this.e = n4;
    }

    public void writeDoubleAsString(double value, int decimalCount) {
        this.writeDoubleAsString(value, decimalCount, false);
    }

    public void writeDoubleAsString(double value, int decimalCount, boolean fixNumberOfDecimalPoints) {
        if (value < 0.0) {
            value = -value;
            this.write(45);
        }
        int n2 = (int)value;
        int n3 = -this.e;
        this.writeIntAsString(n2);
        if ((value -= (double)n2) == 0.0) {
            return;
        }
        n3 = fixNumberOfDecimalPoints ? 0 : (n3 += this.e);
        int n4 = this.e;
        this.write(46);
        while (n3 < decimalCount) {
            if (value == 0.0) {
                return;
            }
            n2 = (int)(value *= 10.0);
            value -= (double)n2;
            this.write(a[n2]);
            if (n2 != 0) {
                n4 = this.e;
            }
            ++n3;
        }
        this.e = n4;
    }

    public void writeByteAsHexString(int byteValue) {
        this.write(c[byteValue >> 4 & 0xF]);
        this.write(c[byteValue & 0xF]);
    }

    public void writeShortAsHex(int shortValue) {
        this.writeByteAsHexString(shortValue >> 8);
        this.writeByteAsHexString(shortValue);
    }

    public void writeBytesAsHexString(byte[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            this.writeByteAsHexString(array[i2]);
        }
    }

    public byte[] getBuffer() {
        return this.d;
    }

    public void insertBytes(int pos, MemoryStream stream) {
        this.a(pos, stream.d, 0, stream.e);
    }

    void a(int n2, byte @Nonnull [] byArray, int n3, int n4) {
        if (n2 > this.e) {
            throw new IllegalArgumentException("Insert(" + n2 + ") after end(" + this.e + ") of stream.");
        }
        if (n4 == 0) {
            return;
        }
        int n5 = this.e + n4;
        this.a(n5);
        System.arraycopy(this.d, n2, this.d, n2 + n4, this.e - n2);
        System.arraycopy(byArray, n3, this.d, n2, n4);
        this.e = n5;
    }

    public void moveBytes(int from, int to) {
        this.a(from, this.e - from, to);
    }

    void a(int n2, int n3, int n4) {
        this.a(this.e + n3);
        System.arraycopy(this.d, n2, this.d, this.e, n3);
        System.arraycopy(this.d, n4, this.d, n4 + n3, this.e - n4 - n3);
        System.arraycopy(this.d, this.e, this.d, n4, n3);
    }

    public void patchInt(int offset, int value) {
        this.d[offset++] = (byte)(value >> 24);
        this.d[offset++] = (byte)(value >> 16);
        this.d[offset++] = (byte)(value >> 8);
        this.d[offset++] = (byte)value;
    }

    public void patchShort(int offset, int value) {
        this.d[offset++] = (byte)(value >> 8);
        this.d[offset++] = (byte)value;
    }

    public String toHexDump() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.e; ++i2) {
            stringBuffer.append(Integer.toHexString(this.d[i2] & 0xFF)).append(" ");
        }
        return stringBuffer.toString();
    }

    public int skipInt() {
        int n2 = this.e;
        int n3 = n2 + 4;
        this.a(n3);
        this.e = n3;
        return n2;
    }

    public void writeCharUtf8(int c2) throws IllegalStateException {
        if (c2 < 128) {
            this.write(c2);
        } else if (c2 < 2048) {
            this.write(0xC0 | c2 >> 6 & 0x1F);
            this.write(0x80 | c2 >> 0 & 0x3F);
        } else if (c2 < 65536) {
            this.write(0xE0 | c2 >> 12 & 0x1F);
            this.write(0x80 | c2 >> 6 & 0x3F);
            this.write(0x80 | c2 >> 0 & 0x3F);
        } else {
            this.write(0xF0 | c2 >> 18 & 7);
            this.write(0x80 | c2 >> 12 & 0x3F);
            this.write(0x80 | c2 >> 6 & 0x3F);
            this.write(0x80 | c2 & 0x3F);
        }
    }

    public void writeUTF8Int(int v) {
        if (this.e + 5 > this.d.length) {
            this.b(this.e + 5);
        }
        if (v < 0) {
            if (v >= -8) {
                this.d[this.e++] = (byte)(v & 0xF);
                return;
            }
            if (v >= -1024) {
                this.d[this.e++] = (byte)(v >> 8 & 7);
                this.d[this.e++] = (byte)v;
                return;
            }
            if (v >= -131072) {
                this.d[this.e++] = (byte)(v >> 16 & 3);
                this.d[this.e++] = (byte)(v >> 8);
                this.d[this.e++] = (byte)v;
                return;
            }
            if (v >= -16777216) {
                this.d[this.e++] = 1;
                this.d[this.e++] = (byte)(v >> 16);
                this.d[this.e++] = (byte)(v >> 8);
                this.d[this.e++] = (byte)v;
                return;
            }
            this.d[this.e++] = 1;
            this.d[this.e++] = 0;
            this.d[this.e++] = 0;
            this.d[this.e++] = 0;
            return;
        }
        if (v <= 127) {
            this.d[this.e++] = (byte)(0x80 | v);
            return;
        }
        if (v <= 16383) {
            this.d[this.e++] = (byte)(0x40 | v >> 8);
            this.d[this.e++] = (byte)v;
            return;
        }
        if (v <= 0x1FFFFF) {
            this.d[this.e++] = (byte)(0x20 | v >> 16);
            this.d[this.e++] = (byte)(v >> 8);
            this.d[this.e++] = (byte)v;
            return;
        }
        if (v <= 0xFFFFFFF) {
            this.d[this.e++] = (byte)(0x10 | v >> 24);
            this.d[this.e++] = (byte)(v >> 16);
            this.d[this.e++] = (byte)(v >> 8);
            this.d[this.e++] = (byte)v;
            return;
        }
        this.d[this.e++] = 31;
        this.d[this.e++] = -1;
        this.d[this.e++] = -1;
        this.d[this.e++] = -1;
    }

    public void insertUTF8Int(int pos, int v) {
        int n2 = this.e;
        this.writeUTF8Int(v);
        this.moveBytes(n2, pos);
    }

    public boolean equalsBytes(byte[] byteArray) {
        if (byteArray.length != this.e) {
            return false;
        }
        int n2 = byteArray.length;
        while (n2-- != 0) {
            if (byteArray[n2] == this.d[n2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writeBytes(String s) {
        this.writeASCII(s);
    }

    @Override
    public void writeChar(int v) {
        this.writeShort(v);
    }

    @Override
    public void writeChars(String s) {
        int n2 = s.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.writeChar(s.charAt(i2));
        }
    }

    public void writeInt(int val, int size) {
        this.a(this.e + size);
        for (int i2 = size - 1; i2 >= 0; --i2) {
            this.d[this.e++] = (byte)(val >> 8 * i2);
        }
    }
}

