/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns.record;

import com.inet.mdns.MDNSInputStream;
import com.inet.mdns.MDNSOutputStream;
import com.inet.mdns.record.AAAARecord;
import com.inet.mdns.record.ARecord;
import com.inet.mdns.record.PtrRecord;
import com.inet.mdns.record.SrvRecord;
import com.inet.mdns.record.TxtRecord;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import javax.annotation.Nullable;

public abstract class Record {
    public static final int TYPE_A = 1;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_TXT = 16;
    public static final int TYPE_AAAA = 28;
    public static final int TYPE_SRV = 33;
    public static final int TYPE_ANY = 255;
    public static final int CLASS_INTERNET = 1;
    public static final int TTL = 30;
    private String a;

    @Nullable
    public static Record read(MDNSInputStream in) throws IOException {
        String string = in.readName();
        int n2 = in.readUnsignedShort();
        in.readUnsignedShort();
        in.readInt();
        int n3 = in.readUnsignedShort();
        switch (n2) {
            case 1: {
                if (n3 != 4) {
                    throw new IOException("IPv4 address length != 4");
                }
                return new ARecord(string, (Inet4Address)InetAddress.getByAddress(in.readBytes(4)));
            }
            case 28: {
                if (n3 != 16) {
                    throw new IOException("IPv6 address length != 16");
                }
                return new AAAARecord(string, (Inet6Address)InetAddress.getByAddress(in.readBytes(16)));
            }
            case 12: {
                return new PtrRecord(string, in.readName());
            }
            case 16: {
                return new TxtRecord(string, in.readUTF(in.read()));
            }
            case 33: {
                return new SrvRecord(string, in.readUnsignedShort(), in.readUnsignedShort(), in.readUnsignedShort(), in.readName());
            }
        }
        in.skip(n3);
        return null;
    }

    protected Record(String name) {
        this.a = name;
    }

    public void writeTo(MDNSOutputStream out) {
        out.writeName(this.a);
        out.writeShort(this.getType());
        out.writeShort(32769);
        out.writeInt(30);
        MDNSOutputStream mDNSOutputStream = new MDNSOutputStream();
        this.a(mDNSOutputStream);
        byte[] byArray = mDNSOutputStream.toByteArray();
        out.writeShort(byArray.length);
        out.write(byArray, 0, byArray.length);
    }

    public String getName() {
        return this.a;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.a + "]";
    }

    public abstract int getType();

    abstract void a(MDNSOutputStream var1);
}

