/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.layout;

import com.inet.font.layout.FontLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import javax.annotation.Nullable;

public class FontMetricsFromLayout
extends FontMetrics {
    private final FontLayout a;

    public FontMetricsFromLayout(FontLayout layout) {
        this(layout, null);
    }

    public FontMetricsFromLayout(FontLayout layout, @Nullable Font font) {
        super(font);
        this.a = layout;
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            this.font = this.a.getJavaFont();
        }
        return this.font;
    }

    @Override
    public int getLeading() {
        return (int)Math.ceil((float)this.a.getLeading() / 15.0f);
    }

    @Override
    public int getAscent() {
        return (int)Math.ceil((float)this.a.getAscent() / 15.0f);
    }

    @Override
    public int getDescent() {
        return (int)Math.ceil((float)this.a.getDescent() / 15.0f);
    }

    @Override
    public int getHeight() {
        return (int)Math.ceil((double)(this.a.getDescent() + this.a.getAscent() + this.a.getLeading()) / 15.0);
    }

    @Override
    public int stringWidth(String str) {
        int n2 = (int)Math.ceil((float)this.a.stringWidth(str) / 15.0f);
        return n2;
    }

    @Override
    public int charWidth(char ch) {
        return (int)Math.ceil((float)this.a.charWidth(ch) / 15.0f);
    }

    @Override
    public boolean hasUniformLineMetrics() {
        return true;
    }

    @Override
    public Rectangle2D getStringBounds(char[] chars, int beginIndex, int limit, Graphics context) {
        int n2 = this.charsWidth(chars, beginIndex, limit - beginIndex);
        return new Rectangle2D.Float(0.0f, -this.getAscent(), n2, this.getAscent() + this.getDescent() + this.getLeading());
    }

    @Override
    public Rectangle2D getStringBounds(CharacterIterator ci, int beginIndex, int limit, Graphics context) {
        int n2 = ci.getBeginIndex();
        int n3 = ci.getEndIndex();
        if (beginIndex < n2) {
            throw new IndexOutOfBoundsException("beginIndex: " + beginIndex);
        }
        if (limit > n3) {
            throw new IndexOutOfBoundsException("limit: " + limit);
        }
        if (beginIndex > limit) {
            throw new IndexOutOfBoundsException("range length: " + (limit - beginIndex));
        }
        char[] cArray = new char[limit - beginIndex];
        ci.setIndex(beginIndex);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = ci.current();
            ci.next();
        }
        return this.getStringBounds(cArray, 0, cArray.length, context);
    }

    @Override
    public Rectangle2D getStringBounds(String str, Graphics context) {
        return this.getStringBounds(str.toCharArray(), 0, str.length(), context);
    }

    @Override
    public Rectangle2D getStringBounds(String str, int beginIndex, int limit, Graphics context) {
        return this.getStringBounds(str.toCharArray(), beginIndex, limit, context);
    }

    @Override
    public LineMetrics getLineMetrics(char[] chars, int beginIndex, int limit, Graphics context) {
        this.getFont();
        return new a(super.getLineMetrics(chars, beginIndex, limit, context));
    }

    @Override
    public LineMetrics getLineMetrics(CharacterIterator ci, int beginIndex, int limit, Graphics context) {
        this.getFont();
        return new a(super.getLineMetrics(ci, beginIndex, limit, context));
    }

    @Override
    public LineMetrics getLineMetrics(String str, Graphics context) {
        this.getFont();
        return new a(super.getLineMetrics(str, context));
    }

    @Override
    public LineMetrics getLineMetrics(String str, int beginIndex, int limit, Graphics context) {
        this.getFont();
        return new a(super.getLineMetrics(str, beginIndex, limit, context));
    }

    private class a
    extends LineMetrics {
        private LineMetrics b;

        public a(LineMetrics lineMetrics) {
            this.b = lineMetrics;
        }

        @Override
        public int getNumChars() {
            return this.b.getNumChars();
        }

        @Override
        public float getAscent() {
            return FontMetricsFromLayout.this.getAscent();
        }

        @Override
        public float getDescent() {
            return FontMetricsFromLayout.this.getDescent();
        }

        @Override
        public float getLeading() {
            return FontMetricsFromLayout.this.getLeading();
        }

        @Override
        public float getHeight() {
            return FontMetricsFromLayout.this.getHeight();
        }

        @Override
        public int getBaselineIndex() {
            return this.b.getBaselineIndex();
        }

        @Override
        public float[] getBaselineOffsets() {
            return this.b.getBaselineOffsets();
        }

        @Override
        public float getStrikethroughOffset() {
            return this.b.getStrikethroughOffset();
        }

        @Override
        public float getStrikethroughThickness() {
            return this.b.getStrikethroughThickness();
        }

        @Override
        public float getUnderlineOffset() {
            return this.b.getUnderlineOffset();
        }

        @Override
        public float getUnderlineThickness() {
            return this.b.getUnderlineThickness();
        }
    }
}

