/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.provider;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.FileConfigProperty;
import com.inet.config.structure.model.FileOrUploadConfigProperty;
import com.inet.config.structure.model.FileUploadConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.SliderConfigProperty;
import com.inet.config.structure.model.TableConfigProperty;
import com.inet.config.structure.model.TreeConfigProperty;
import com.inet.config.structure.model.TreeConfigPropertyNode;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.lib.list.PairList;
import com.inet.logging.LogManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class AbstractStructureProvider
implements ConfigStructureProvider {
    private static final Object[] a = new Object[0];
    public static boolean IS_DESIGNER;
    protected static final String CATEGORY_GROUP_SYSTEM = "categorygroup.system";
    protected static final String CATEGORY_GROUP_COMMUNICATION = "categorygroup.communication";
    protected static final String CATEGORY_GROUP_SECURITY = "categorygroup.security";
    protected static final String CATEGORY_GROUP_COMPONENTS = "categorygroup.components";
    private final String b;

    protected AbstractStructureProvider() {
        this(null);
    }

    protected AbstractStructureProvider(@Nullable String bundleName) {
        if (bundleName == null) {
            bundleName = this.getClass().getName();
            bundleName = ((String)bundleName).substring(0, ((String)bundleName).lastIndexOf(46) + 1) + "i18n.ConfigStructure";
        }
        this.b = bundleName;
    }

    public static boolean isDesigner() {
        return IS_DESIGNER;
    }

    @Override
    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
    }

    @Override
    public void action(@Nonnull String actionKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ConfigStructureSettings settings) {
    }

    @Override
    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        return ConfigStructure.SaveState.NONE;
    }

    @Override
    @Nullable
    public List<LocalizedKey> getSelectValues(@Nonnull String key, String filter, ConfigStructureSettings settings) {
        return null;
    }

    @Nonnull
    public String translate(@Nonnull ConfigStructureSettings settings, String key, Object ... params) {
        return this.translate(settings.getLocale(), key, params);
    }

    @Nonnull
    public String translate(@Nonnull Locale locale, String key, Object ... params) {
        ResourceBundle resourceBundle = LoaderUtils.getBundle(this.b, locale, this);
        try {
            return MessageFormat.format(resourceBundle.getString(key), params);
        }
        catch (IllegalArgumentException | MissingResourceException runtimeException) {
            return "$" + key + "$";
        }
    }

    @Nonnull
    protected String getDefaultType(ConfigKey key) {
        String string;
        switch (string = key.getType().getName()) {
            case "java.lang.String": {
                return "SimpleText";
            }
            case "java.lang.Integer": {
                return "FixNumber";
            }
            case "java.lang.Long": {
                return "FixNumber";
            }
            case "java.lang.Double": {
                return "FloatNumber";
            }
            case "java.lang.Boolean": {
                return "Boolean";
            }
        }
        return string;
    }

    protected void addTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings) {
        String string = this.getDefaultType(configKey);
        this.a(configProperties, configKey, string, settings, null, null);
    }

    protected void addBitMaskTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, int bitMask) {
        Object object = settings.getValue(configKey);
        try {
            int n2 = Integer.parseInt((String)object);
            object = "" + ((n2 & bitMask) > 0);
        }
        catch (NumberFormatException numberFormatException) {
            LogManager.getConfigLogger().error(numberFormatException);
        }
        this.a(configProperties, configKey.getKey() + "." + bitMask, object, "Boolean", settings, null, null, null, null, null, null, null);
    }

    protected void addFlippedBitMaskTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, int bitMask) {
        Object object = settings.getValue(configKey);
        try {
            Integer n2 = Integer.valueOf((String)object);
            object = "" + ((n2 & bitMask) == 0);
        }
        catch (NumberFormatException numberFormatException) {
            LogManager.getConfigLogger().error(numberFormatException);
        }
        this.a(configProperties, configKey.getKey() + "." + bitMask, object, "Boolean", settings, null, null, null, null, null, null, null);
    }

    protected void addTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, String placeholder) {
        String string = this.getDefaultType(configKey);
        this.a(configProperties, configKey.getKey(), settings.getValue(configKey), string, settings, null, null, null, null, null, placeholder, null);
    }

    protected void addTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull String type, @Nonnull ConfigStructureSettings settings) {
        this.a(configProperties, configKey, type, settings, null, null);
    }

    protected void addTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull String type, @Nonnull ConfigStructureSettings settings, String placeholder) {
        this.a(configProperties, configKey.getKey(), settings.getValue(configKey), type, settings, null, null, null, null, null, placeholder, null);
    }

    protected void addTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, @Nonnull String type, @Nonnull ConfigStructureSettings settings) {
        this.addTo(configProperties, key, type, null, settings, null);
    }

    protected void addTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, @Nonnull String type, String value, @Nonnull ConfigStructureSettings settings) {
        this.a(configProperties, key, value, type, settings, null, null, null, null, null, null, null);
    }

    protected void addTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, @Nonnull String type, String value, @Nonnull ConfigStructureSettings settings, String placeholder) {
        this.a(configProperties, key, value, type, settings, null, null, null, null, null, placeholder, null);
    }

    protected void addPasswordTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull String value, @Nonnull ConfigStructureSettings settings) {
        this.a(configProperties, configKey.getKey(), value, "Password", settings, null, null, null, null, null, null, null);
    }

    protected void addUnitTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, @Nonnull List<UnitConfigProperty.Unit> units) {
        this.addUnitTo(configProperties, configKey, settings, units, null);
    }

    protected void addUnitTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, @Nonnull List<UnitConfigProperty.Unit> units, String placeholder) {
        String string = this.getDefaultType(configKey);
        this.a(configProperties, configKey.getKey(), settings.getValue(configKey), string, settings, units, null, null, null, null, null, placeholder, null, null);
    }

    protected void addUnitTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, String value, @Nonnull String type, @Nonnull ConfigStructureSettings settings, @Nonnull List<UnitConfigProperty.Unit> units) {
        this.a(configProperties, key, value, type, settings, units, null, null, null, null, null, null);
    }

    protected void addUnitTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, String value, @Nonnull String type, @Nonnull ConfigStructureSettings settings, @Nonnull List<UnitConfigProperty.Unit> units, String placeholder) {
        this.a(configProperties, key, value, type, settings, units, null, null, null, null, placeholder, null);
    }

    protected void addSelectTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, String value, @Nonnull ConfigStructureSettings settings, @Nonnull List<LocalizedKey> options) {
        String string = this.getDefaultType(configKey);
        this.a(configProperties, configKey.getKey(), value, string, settings, null, options, null, null, null, null, null);
    }

    protected void addSelectTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, String value, @Nonnull String type, @Nonnull ConfigStructureSettings settings, @Nonnull List<LocalizedKey> options) {
        this.a(configProperties, key, value, type, settings, null, options, null, null, null, null, null);
    }

    protected void addSelectTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, @Nonnull List<LocalizedKey> options) {
        String string = this.getDefaultType(configKey);
        this.a(configProperties, configKey, string, settings, null, options);
    }

    protected void addFileTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, String defaultPath, String basePath, String[] filter) {
        this.addFileTo(configProperties, configKey.getKey(), settings, defaultPath, basePath, filter);
    }

    protected void addFileTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String configKey, @Nonnull ConfigStructureSettings settings, String defaultPath, String basePath, String[] filter) {
        this.addFileTo(configProperties, configKey, settings, defaultPath, basePath, filter, settings.getValue(configKey));
    }

    protected void addFileTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String configKey, @Nonnull ConfigStructureSettings settings, String defaultPath, String basePath, String[] filter, String value) {
        configProperties.add(new FileConfigProperty(configProperties.size() * 100, configKey, false, this.translate(settings, configKey, new Object[0]), value, this.translate(settings, configKey + ".tooltip", new Object[0]), null, filter, defaultPath, basePath));
    }

    protected void addFileUploadTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, String fileNamePattern) {
        this.addFileUploadTo(configProperties, configKey.getKey(), settings, fileNamePattern, settings.getValue(configKey));
    }

    protected void addFileUploadTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String configKey, @Nonnull ConfigStructureSettings settings, String fileNamePattern) {
        this.addFileUploadTo(configProperties, configKey, settings, fileNamePattern, settings.getValue(configKey));
    }

    protected void addFileUploadTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String configKey, @Nonnull ConfigStructureSettings settings, String fileNamePattern, String value) {
        configProperties.add(new FileUploadConfigProperty(configProperties.size() * 100, configKey, value, this.translate(settings, configKey, new Object[0]), this.translate(settings, configKey + ".button", new Object[0]), this.translate(settings, configKey + ".tooltip", new Object[0]), fileNamePattern));
    }

    protected void addFileOrUploadTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, String fileNamePattern, String[] filter) {
        this.addFileOrUploadTo(configProperties, configKey.getKey(), settings, fileNamePattern, filter, settings.getValue(configKey));
    }

    protected void addFileOrUploadTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String configKey, @Nonnull ConfigStructureSettings settings, String fileNamePattern, String[] filter) {
        this.addFileOrUploadTo(configProperties, configKey, settings, fileNamePattern, filter, settings.getValue(configKey));
    }

    protected void addFileOrUploadTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String configKey, @Nonnull ConfigStructureSettings settings, String fileNamePattern, String[] filter, String value) {
        configProperties.add(new FileOrUploadConfigProperty(configProperties.size() * 100, configKey, value, this.translate(settings, configKey, new Object[0]), null, null, fileNamePattern, filter));
    }

    protected void addDirectoryTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String configKey, @Nonnull ConfigStructureSettings settings, String defaultPath, String basePath, String value) {
        configProperties.add(new FileConfigProperty(configProperties.size() * 100, configKey, true, this.translate(settings, configKey, new Object[0]), value, this.translate(settings, configKey + ".tooltip", new Object[0]), null, null, defaultPath, basePath));
    }

    protected void addTableTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull String type, @Nonnull ConfigStructureSettings settings, List<String[]> rows, ConfigAction[] actions, ConfigProperty ... columns) {
        this.addTableTo(configProperties, configKey.getKey(), type, settings, rows, actions, (int[])null, columns);
    }

    protected void addTableTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull String type, @Nonnull ConfigStructureSettings settings, List<String[]> rows, ConfigAction[] actions, int[] columnSizes, ConfigProperty ... columns) {
        this.addTableTo(configProperties, configKey.getKey(), type, settings, rows, actions, columnSizes, columns);
    }

    protected void addTableTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, @Nonnull String type, @Nonnull ConfigStructureSettings settings, List<String[]> rows, ConfigAction[] actions, ConfigProperty ... columns) {
        int[] nArray = new int[columns.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = 100 / nArray.length;
        }
        this.a(configProperties, key, null, type, settings, null, null, rows, columns, nArray, actions, null, null, null);
    }

    protected void addTableTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, @Nonnull String type, @Nonnull ConfigStructureSettings settings, List<String[]> rows, ConfigAction[] actions, int[] columnSizes, ConfigProperty ... columns) {
        this.a(configProperties, key, null, type, settings, null, null, rows, columns, columnSizes, actions, null, null, null);
    }

    protected void addTableTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull String key, @Nonnull String type, @Nonnull ConfigStructureSettings settings, List<String[]> rows, ConfigAction[] actions, String configActionsLabel, ConfigProperty ... columns) {
        this.a(configProperties, key, null, type, settings, null, null, rows, columns, actions, configActionsLabel, null);
    }

    protected void addTreeTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull String type, @Nonnull ConfigStructureSettings settings, TreeConfigPropertyNode root) {
        this.a(configProperties, configKey.getKey(), null, type, settings, null, null, null, null, null, null, root);
    }

    protected void addListTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull String type, @Nonnull ConfigStructureSettings settings, Object value) {
        this.a(configProperties, configKey.getKey(), value, type, settings, null, null, null, null, null, null, null);
    }

    protected void addBooleanTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings) {
        this.a(configProperties, configKey.getKey(), settings.getValue(configKey), "Boolean", settings, null, null, null, null, null, null, "", null, null);
    }

    protected void addSliderTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, SliderConfigProperty.SliderBound lowerBound, SliderConfigProperty.SliderBound upperBound, boolean showValue) {
        configProperties.add(new SliderConfigProperty(configProperties.size() * 100, configKey.getKey(), this.translate(settings, configKey.getKey(), new Object[0]), settings.getValue(configKey), this.translate(settings, configKey.getKey() + ".tooltip", new Object[0]), lowerBound, upperBound, showValue));
    }

    protected void addSliderTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, String value, @Nonnull ConfigStructureSettings settings, SliderConfigProperty.SliderBound lowerBound, SliderConfigProperty.SliderBound upperBound, boolean showValue) {
        configProperties.add(new SliderConfigProperty(configProperties.size() * 100, configKey.getKey(), this.translate(settings, configKey.getKey(), new Object[0]), value, this.translate(settings, configKey.getKey() + ".tooltip", new Object[0]), lowerBound, upperBound, showValue));
    }

    protected void addSliderTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, SliderConfigProperty.SliderBound lowerBound, SliderConfigProperty.SliderBound upperBound, boolean showValue, String tooltip) {
        configProperties.add(new SliderConfigProperty(configProperties.size() * 100, configKey.getKey(), this.translate(settings, configKey.getKey(), new Object[0]), settings.getValue(configKey), tooltip, lowerBound, upperBound, showValue));
    }

    private void a(@Nonnull Collection<ConfigProperty> collection, @Nonnull ConfigKey configKey, @Nonnull String string, @Nonnull ConfigStructureSettings configStructureSettings, List<UnitConfigProperty.Unit> list, List<LocalizedKey> list2) {
        this.a(collection, configKey.getKey(), configStructureSettings.getValue(configKey), string, configStructureSettings, list, list2, null, null, null, null, null);
    }

    private void a(@Nonnull Collection<ConfigProperty> collection, @Nonnull String string, Object object, @Nonnull String string2, @Nonnull ConfigStructureSettings configStructureSettings, List<UnitConfigProperty.Unit> list, List<LocalizedKey> list2, List<String[]> list3, ConfigProperty[] configPropertyArray, ConfigAction[] configActionArray, String string3, TreeConfigPropertyNode treeConfigPropertyNode) {
        this.a(collection, string, object, string2, configStructureSettings, list, list2, list3, configPropertyArray, null, configActionArray, string3, treeConfigPropertyNode, null);
    }

    protected void addTo(@Nonnull Collection<ConfigProperty> configProperties, @Nonnull ConfigKey configKey, @Nonnull ConfigStructureSettings settings, String placeholder, String tooltip) {
        String string = this.getDefaultType(configKey);
        this.a(configProperties, configKey.getKey(), settings.getValue(configKey), string, settings, null, null, null, null, null, null, placeholder, null, tooltip);
    }

    private void a(@Nonnull Collection<ConfigProperty> collection, @Nonnull String string, Object object, @Nonnull String string2, @Nonnull ConfigStructureSettings configStructureSettings, List<UnitConfigProperty.Unit> list, List<LocalizedKey> list2, List<String[]> list3, ConfigProperty[] configPropertyArray, int[] nArray, ConfigAction[] configActionArray, String string3, TreeConfigPropertyNode treeConfigPropertyNode, String string4) {
        String string5;
        int n2 = collection.size() * 100;
        ResourceBundle resourceBundle = LoaderUtils.getBundle(this.b, configStructureSettings.getLocale(), this);
        try {
            string5 = string2 == "Hidden" ? null : MessageFormat.format(resourceBundle.getString(string), a);
        }
        catch (MissingResourceException missingResourceException) {
            string5 = "$" + string + "$";
        }
        if (string4 == null) {
            try {
                string4 = MessageFormat.format(resourceBundle.getString(string + ".tooltip"), a);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (string3 == null) {
            try {
                string3 = MessageFormat.format(resourceBundle.getString(string + ".placeholder"), a);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        ConfigProperty configProperty = list != null ? new UnitConfigProperty(n2, string, string2, string5, object, string4, list, string3) : (list2 != null ? new SelectConfigProperty(n2, string, string2, string5, object, string4, list2) : (list3 != null ? new TableConfigProperty(n2, string, string2, string5, string4, list3, configPropertyArray, nArray, configActionArray, string3) : (treeConfigPropertyNode != null ? new TreeConfigProperty(n2, string, string2, string5, string4, treeConfigPropertyNode) : ("Boolean".equals(string2) ? (string3 == null ? new BooleanConfigProperty(n2, string, string5, null, string4, object) : new BooleanConfigProperty(n2, string, null, string5, string4, object)) : new ConfigProperty(n2, string, string2, string5, object, string4, string3)))));
        collection.add(configProperty);
    }

    protected List<ConfigConditionAction> getConditions(@Nonnull String categoryKey, @Nonnull ConfigStructureSettings settings) {
        @Nonnull ArrayList<ConfigConditionAction> arrayList = new ArrayList<ConfigConditionAction>();
        this.addConditionsTo(arrayList, categoryKey, true, settings);
        return arrayList;
    }

    @Override
    public PairList<String, String> getCategoryVetoes(boolean advanced, ConfigStructureSettings settings) {
        return new PairList<String, String>();
    }

    @Override
    @Nonnull
    public PairList<String, String> getPropertyGroupVetoes(boolean advanced, ConfigStructureSettings settings) {
        return new PairList<String, String>();
    }

    @Override
    public String getApplicationKey() {
        return null;
    }

    @Nonnull
    protected ConfigGroup getCommunicationGroup(@Nonnull ConfigStructureSettings settings) {
        return new ConfigGroup(140, CATEGORY_GROUP_COMMUNICATION, CoreSystemStructureProvider.INSTANCE.translate(settings, CATEGORY_GROUP_COMMUNICATION, new Object[0]), AbstractStructureProvider.class.getResource("server_categorygroup_communication_48.png"));
    }
}

