/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.base;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.LoginRoles;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class TempLoginProcessor
extends LoginProcessor
implements LoginRoles {
    private final String a;
    private GUID b;
    private final Set<String> c;
    @Nonnull
    private String d;

    TempLoginProcessor(@Nonnull String loginID, @Nonnull String userDisplayName, Permission ... permissions) {
        this(loginID, userDisplayName, Set.of(permissions), null);
    }

    public TempLoginProcessor(@Nonnull String loginID, @Nonnull String userDisplayName, @Nonnull Set<Permission> permissions, @Nullable Set<String> roles) {
        super(null);
        this.d = userDisplayName;
        this.a = loginID;
        this.c = roles;
        UserAccount userAccount = this.getOrCreateUserAccount(loginID);
        if (userAccount == null) {
            throw new ClientMessageException("User Account could not be created.");
        }
        this.b = userAccount.getID();
        UserManager.getInstance().updateUserPermissions(this.b, permissions, Collections.emptySet());
    }

    @Override
    @Nonnull
    protected MutableUserData createNewUserData() {
        MutableUserData mutableUserData = super.createNewUserData();
        CharSequence[] charSequenceArray = this.d.split(" ");
        if (charSequenceArray.length == 1) {
            mutableUserData.put(UsersAndGroups.FIELD_FIRSTNAME, this.d);
        } else {
            mutableUserData.put(UsersAndGroups.FIELD_LASTNAME, charSequenceArray[charSequenceArray.length - 1]);
            charSequenceArray[charSequenceArray.length - 1] = "";
            mutableUserData.put(UsersAndGroups.FIELD_FIRSTNAME, String.join((CharSequence)" ", charSequenceArray).trim());
        }
        return mutableUserData;
    }

    @Override
    @Nonnull
    public String getLoginSource() {
        return "temp";
    }

    @Override
    @Nullable
    public String getLoginID() {
        return this.a;
    }

    @Override
    @Nonnull
    public UserAccountType getUserAccountType() {
        return UserAccountType.Temp;
    }

    @Override
    public boolean supportsRoles() {
        return this.c != null;
    }

    @Override
    public boolean isWebUserInRole(String role) {
        return this.c != null && this.c.contains(role);
    }

    @Override
    @Nonnull
    public Set<String> getRoles() {
        return this.c != null ? this.c : Collections.emptySet();
    }

    @Override
    protected boolean isCreateUserAccountSupported() {
        return true;
    }

    @Override
    public GUID getUserAccountID() {
        return this.b;
    }
}

