/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.base;

import com.inet.authentication.LoginListener;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.http.ExpandableHttpSessionListener;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.veto.VetoType;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.thread.timer.DefaultTimer;
import com.inet.thread.timer.DefaultTimerTask;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TempAccountCleaner
implements LoginListener,
ServerPluginManagerListener,
HttpSessionListener {
    @Override
    public void vetoFinished(@Nullable VetoType type) {
        if (type == null) {
            this.a();
        }
    }

    private void a() {
        DefaultTimerTask defaultTimerTask = new DefaultTimerTask(){

            @Override
            public void runImpl() throws Throwable {
                ForkJoinPool.commonPool().execute(() -> {
                    UserManager userManager = UserManager.getInstance();
                    SearchCommand searchCommand = new SearchCommand("useraccounttype", SearchCondition.SearchTermOperator.Equals, UserAccountType.Temp.name());
                    Set<GUID> set = userManager.getSearchEngine().simpleSearch(searchCommand);
                    HashSet<GUID> hashSet = null;
                    for (GUID gUID : set) {
                        UserAccount userAccount = userManager.getUserAccount(gUID);
                        if (userAccount == null) continue;
                        if (hashSet == null) {
                            hashSet = new HashSet<GUID>();
                            for (HttpSession httpSession : ExpandableHttpSessionListener.getActiveSessions()) {
                                GUID gUID2;
                                LoginProcessor loginProcessor = LoginManager.getLoginProcessor(httpSession);
                                if (loginProcessor == null || (gUID2 = loginProcessor.getUserAccountID()) == null) continue;
                                hashSet.add(gUID2);
                            }
                        }
                        if (hashSet.contains(gUID)) continue;
                        TempAccountCleaner.a(userAccount);
                    }
                });
            }
        };
        DefaultTimer.getInstance().schedule(defaultTimerTask, 60000L);
    }

    @Override
    public void sessionCreated(HttpSessionEvent evt) {
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent evt) {
        GUID gUID;
        HttpSession httpSession = evt.getSession();
        LoginProcessor loginProcessor = LoginManager.getLoginProcessor(httpSession);
        if (loginProcessor != null && (gUID = loginProcessor.getUserAccountID()) != null) {
            String string = httpSession.getId();
            for (HttpSession httpSession2 : ExpandableHttpSessionListener.getActiveSessions()) {
                GUID gUID2;
                if (Objects.equals(string, httpSession2.getId()) || (loginProcessor = LoginManager.getLoginProcessor(httpSession2)) == null || !Objects.equals(gUID, gUID2 = loginProcessor.getUserAccountID())) continue;
                return;
            }
            UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
            TempAccountCleaner.a(userAccount);
        }
    }

    private static void a(@Nullable UserAccount userAccount) {
        if (userAccount == null || userAccount.getAccountType() != UserAccountType.Temp) {
            return;
        }
        GUID gUID = userAccount.getID();
        try {
            LoginProcessor.LOGGER.info("Destroying Temp User ID: " + String.valueOf(gUID) + "; Username: " + userAccount.getDisplayName());
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                UserManager userManager = UserManager.getInstance();
                userManager.deleteUserAccount(gUID);
            }
        }
        catch (Exception exception) {
            LoginProcessor.LOGGER.error(exception);
        }
    }

    @Override
    public void userLoggedIn(@Nonnull UserAccount userAccount, @Nonnull LoginProcessor login) {
    }

    @Override
    public void userLoggedOut(@Nonnull UserAccount userAccount) {
        TempAccountCleaner.a(userAccount);
    }
}

