/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.junit.impl;

import com.inet.pdfc.junit.impl.ByteBufferInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class PdfData {
    private File file;
    private String name;
    private ByteBuffer content;
    private URL url;
    private InputStream input;

    public PdfData(@Nonnull File file) {
        this.file = file;
        this.name = file.getName();
    }

    public PdfData(@Nonnull URL url) {
        this.url = url;
        this.name = url.getPath();
    }

    public PdfData(@Nullable String name, @Nonnull InputStream input) {
        this.name = name;
        this.input = input;
    }

    public PdfData(@Nullable String name, @Nonnull ByteBuffer content) {
        this.name = name;
        this.content = content;
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="client site code, library user must check")
    private InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        if (this.content != null) {
            return new ByteBufferInputStream(this.content);
        }
        if (this.url != null) {
            return this.url.openStream();
        }
        if (this.input != null) {
            return this.input;
        }
        throw new IOException("No file content available");
    }

    @Nonnull
    public String getFileName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return this.name != null ? this.name : "document.pdf";
    }

    @Nullable
    public HttpRequest.BodyPublisher toPublisher() throws FileNotFoundException {
        if (this.file != null) {
            return HttpRequest.BodyPublishers.ofFile(this.file.toPath());
        }
        if (this.content != null) {
            return HttpRequest.BodyPublishers.ofByteArray(this.content.array());
        }
        if (this.input != null) {
            return HttpRequest.BodyPublishers.ofInputStream(() -> this.input);
        }
        if (this.url != null) {
            return HttpRequest.BodyPublishers.ofString(this.url.toString());
        }
        return null;
    }
}

