/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user.persistence;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.user.persistence.BinaryDataSyncObject;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@InternalApi
public class UserPersistenceWithCache
implements UserPersistence {
    private final MemoryStoreMap<GUID, UserAccount> a;
    private final UserPersistence b;

    public UserPersistenceWithCache(UserPersistence persistence) {
        this(persistence, 3600);
    }

    private UserPersistenceWithCache(UserPersistence persistence, int cacheTimeout) {
        if (persistence == null) {
            throw new IllegalArgumentException("persistence must not be null");
        }
        if (persistence instanceof UserPersistenceWithCache) {
            throw new IllegalArgumentException("duplicate persistence cache");
        }
        this.b = persistence;
        this.a = new MemoryStoreMap(cacheTimeout, true);
        DynamicExtensionManager.getInstance().registerListener(UserField.class, list -> this.hardReset());
    }

    @Override
    public void init() {
        this.b.init();
    }

    @Override
    public UserAccount saveNew(GUID accountID, UserAccountType type, long lastModified, long lastAccess, boolean active, MutableUserData userData) {
        UserAccount userAccount = this.b.saveNew(accountID, type, lastModified, lastAccess, active, userData);
        this.a.put(userAccount.getID(), userAccount);
        return userAccount;
    }

    @Override
    public UserAccount updateData(GUID userID, long lastModified, MutableUserData userData) {
        UserAccount userAccount = this.b.updateData(userID, lastModified, userData);
        this.a.put(userID, userAccount);
        return userAccount;
    }

    @Override
    public void removeData(GUID accountID, List<UserField<?>> fields) {
        this.b.removeData(accountID, fields);
        this.a.remove(accountID);
    }

    @Override
    public UserAccount updateLoginSettings(GUID accountID, long lastModified, List<LoginSettings> settingsToAdd, List<LoginSettings> settingsToRemove) {
        UserAccount userAccount = this.b.updateLoginSettings(accountID, lastModified, settingsToAdd, settingsToRemove);
        this.a.put(accountID, userAccount);
        return userAccount;
    }

    @Override
    public UserAccount updatePermissions(GUID accountID, long lastModified, Set<String> permissionsToAdd, Set<String> permissionsToRemove) {
        UserAccount userAccount = this.b.updatePermissions(accountID, lastModified, permissionsToAdd, permissionsToRemove);
        this.a.put(accountID, userAccount);
        return userAccount;
    }

    @Override
    public UserAccount setAccountActive(GUID accountID, long lastModified, boolean active) {
        UserAccount userAccount = this.b.setAccountActive(accountID, lastModified, active);
        this.a.put(accountID, userAccount);
        return userAccount;
    }

    @Override
    public UserAccount setLastModified(GUID accountID, long lastModified) {
        UserAccount userAccount = this.b.setLastModified(accountID, lastModified);
        this.a.put(accountID, userAccount);
        return userAccount;
    }

    @Override
    public UserAccount setLastAccess(GUID accountID, long lastAccess) {
        UserAccount userAccount = this.b.setLastAccess(accountID, lastAccess);
        this.a.put(accountID, userAccount);
        return userAccount;
    }

    @Override
    public void delete(GUID accountID) {
        this.b.delete(accountID);
        this.a.remove(accountID);
    }

    @Override
    public void deleteAll() {
        this.b.deleteAll();
        this.a.clear();
    }

    @Override
    public UserAccount load(GUID accountID) {
        UserAccount userAccount = (UserAccount)this.a.get(accountID);
        if (userAccount != null) {
            return userAccount;
        }
        UserAccount userAccount2 = this.b.load(accountID);
        if (userAccount2 != null) {
            this.a.put(accountID, userAccount2);
        }
        return userAccount2;
    }

    @Override
    public List<UserAccount> load(List<GUID> accountIDs, int limit) {
        Object object;
        List<UserAccount> list;
        HashMap<Object, UserAccount> hashMap = new HashMap<Object, UserAccount>();
        ArrayList<GUID> arrayList = new ArrayList<GUID>();
        for (GUID iterator : accountIDs) {
            if (hashMap.size() == limit) break;
            UserAccount userAccount = (UserAccount)this.a.get(iterator);
            if (userAccount != null) {
                hashMap.put(iterator, userAccount);
                continue;
            }
            arrayList.add(iterator);
        }
        if (!arrayList.isEmpty() && (limit -= hashMap.size()) > 0) {
            list = this.b.load(arrayList, limit);
            for (UserAccount userAccount : list) {
                object = userAccount.getID();
                hashMap.put(object, userAccount);
                this.a.put((GUID)object, userAccount);
            }
        }
        list = new ArrayList();
        for (GUID gUID : accountIDs) {
            object = (UserAccount)hashMap.get(gUID);
            if (object == null) continue;
            list.add((UserAccount)object);
        }
        return list;
    }

    @Override
    public Iterator<GUID> getUserAccountIdIterator(@Nullable String key) {
        return this.b.getUserAccountIdIterator(key);
    }

    @Override
    public boolean hasUserDataFor(GUID accountID) {
        return this.a.containsKey(accountID) ? true : this.b.hasUserDataFor(accountID);
    }

    @Override
    public InputStream loadBinaryData(GUID accountID, String key) {
        InputStream inputStream;
        final ServerLock serverLock = ThreadUtils.getLock(BinaryDataSyncObject.of(accountID, key));
        try {
            inputStream = this.b.loadBinaryData(accountID, key);
        }
        catch (Throwable throwable) {
            serverLock.close();
            throw throwable;
        }
        if (inputStream == null) {
            serverLock.close();
            return null;
        }
        return new FilterInputStream(inputStream){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    serverLock.close();
                }
            }
        };
    }

    @Override
    public void saveBinaryData(GUID accountID, String key, InputStream in, int length) {
        try (ServerLock serverLock = ThreadUtils.getLock(BinaryDataSyncObject.of(accountID, key));){
            this.b.saveBinaryData(accountID, key, in, -1);
        }
    }

    @Override
    public void deleteBinaryData(GUID accountID, String key) {
        try (ServerLock serverLock = ThreadUtils.getLock(BinaryDataSyncObject.of(accountID, key));){
            this.b.deleteBinaryData(accountID, key);
        }
    }

    void a(GUID gUID) {
        this.a.remove(gUID);
    }

    public void hardReset() {
        this.a.clear();
    }

    @Override
    public long getAccountFileSize(GUID accountId) {
        return this.b.getAccountFileSize(accountId);
    }

    @Override
    public Iterator<Map.Entry<String, InputStream>> getBinaryDataIterator(GUID accountID) {
        return this.b.getBinaryDataIterator(accountID);
    }
}

