/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.config.ConfigurationManager;
import com.inet.field.FieldManager;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchTag;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.search.veto.UserSearchIndexVetoPower;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.SessionLocal;
import com.inet.usersandgroups.api.BaseUserManagerFactory;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserManagerFactory;
import com.inet.usersandgroups.api.user.AuthGroupMembersProvider;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserSearchFilter;
import com.inet.usersandgroups.user.search.SearchTagActive;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class UserManager
implements FieldManager<GUID>,
AuthGroupMembersProvider {
    private static boolean a;
    public static final GUID PRIVILEGED_ACCOUNT_ID;
    public static final GUID MASTER_ACCOUNT_ID;
    public static final GUID RECOVERY_ACCOUNT_ID;
    private static final SessionLocal<GUID> b;
    private static final ThreadLocal<GUID> c;
    private static GUID d;
    private static SearchIndexVeto e;
    private static UserSearchIndexVetoPower f;
    private static final DynamicExtension<UserField> g;

    public static UserSearchIndexVetoPower getVetoPower() {
        return f;
    }

    private static void a() {
        if (a) {
            return;
        }
        ServerPluginManager.getInstance().getOptionalInstance(UserManagerFactory.class);
        a = true;
    }

    @Nonnull
    public static UserManager getInstance() {
        UserManager.a();
        return com.inet.usersandgroups.api.user.UserManager$a.a;
    }

    @Nonnull
    public static UserManager getRecoveryEnabledInstance() {
        UserManager.a();
        return com.inet.usersandgroups.api.user.UserManager$a.b;
    }

    public abstract UserAccount createUserAccount(UserAccountType var1, MutableUserData var2);

    public UserAccount createUserAccount(@Nonnull UserAccountType accountType, @Nonnull MutableUserData userData, @Nonnull LoginSettings settings) {
        UserAccount userAccount = this.createUserAccount(accountType, userData);
        try {
            ArrayList<LoginSettings> arrayList = new ArrayList<LoginSettings>();
            arrayList.add(settings);
            this.updateLoginSettings(userAccount.getID(), arrayList, Collections.emptyList());
        }
        catch (RuntimeException runtimeException) {
            block4: {
                try {
                    this.deleteUserAccount(userAccount.getID());
                }
                catch (Exception exception) {
                    if (runtimeException == exception) break block4;
                    runtimeException.addSuppressed(exception);
                }
            }
            throw runtimeException;
        }
        return this.getUserAccount(userAccount.getID());
    }

    public abstract void updateUserData(GUID var1, MutableUserData var2);

    public abstract <VALUE> void updateUserData(GUID var1, UserField<VALUE> var2, Function<VALUE, VALUE> var3);

    public void updateLoginSettings(GUID accountID, List<LoginSettings> settingsToAdd, List<LoginSettings> settingsToRemove) {
        this.updateLoginSettings(accountID, settingsToAdd, settingsToRemove, true);
    }

    public abstract void updateLoginSettings(GUID var1, List<LoginSettings> var2, List<LoginSettings> var3, boolean var4);

    public abstract void updateUserPermissions(GUID var1, Set<Permission> var2, Set<Permission> var3);

    public abstract void deleteValuesOfRemovedCustomFields(List<UserField<?>> var1);

    public abstract void deleteUserAccount(GUID var1);

    public abstract void setUserAccountActive(GUID var1);

    public void activateUserAccount(GUID accountID) {
        this.setUserAccountActive(accountID);
    }

    public abstract void setUserAccountInactive(GUID var1);

    public void deactivateUserAccount(GUID accountID) {
        this.setUserAccountInactive(accountID);
    }

    public abstract InputStream getBinaryData(GUID var1, BinaryDataKey var2);

    public abstract void storeBinaryData(GUID var1, BinaryDataKey var2, InputStream var3, int var4);

    public abstract void deleteBinaryData(GUID var1, BinaryDataKey var2);

    @Nonnull
    public LoginProcessor getNonSessionLoginProcessor(GUID accountID) {
        return this.getNonSessionLoginProcessor(accountID, null, null);
    }

    @Nonnull
    public abstract LoginProcessor getNonSessionLoginProcessor(GUID var1, String var2, String var3);

    @Nullable
    public abstract UserAccount getUserAccount(@Nonnull GUID var1);

    @Deprecated
    public UserAccount getUserAccount(GUID accountID, boolean fromSessionCache) {
        return this.getUserAccount(accountID);
    }

    public abstract List<UserAccount> getUserAccounts(List<GUID> var1);

    public Iterator<GUID> getIteratorOverUserAccountIDs() {
        return this.getIteratorOverUserAccountIDs(null);
    }

    public abstract Iterator<GUID> getIteratorOverUserAccountIDs(BinaryDataKey var1);

    public abstract Iterator<Map.Entry<String, InputStream>> getBinaryDataIterator(GUID var1);

    public abstract void registerListener(UserEventListener var1);

    public abstract void unregisterListener(UserEventListener var1);

    public static <VALUE> List<UserField<VALUE>> getAllFields() {
        return g.get();
    }

    public abstract <T> UserField<T> getField(String var1);

    public abstract SearchResult<GUID> search(String var1, List<SearchExpression> var2, List<SearchExpression> var3, int var4, @Nullable SearchID var5);

    public abstract SearchResult<GUID> search(String var1, List<SearchExpression> var2, List<SearchExpression> var3, int var4, @Nullable SearchID var5, @Nonnull Set<SearchTag> var6, @Nullable List<TokenMatcher<GUID>> var7);

    public abstract SearchResult<GUID> searchAsUser(String var1, List<SearchExpression> var2, List<SearchExpression> var3, int var4, @Nullable SearchID var5);

    public abstract SearchResult<GUID> searchAsUser(SearchCommand var1);

    public abstract UserAccount findActiveUserAccount(String var1, String var2);

    @Override
    public abstract IndexSearchEngine<GUID> getSearchEngine();

    public abstract List<LoginSettings> findConflictingLoginSettings(GUID var1);

    public int getIndexCount() {
        IndexSearchEngine<GUID> indexSearchEngine = this.getSearchEngine();
        return indexSearchEngine.getIndexCountOfIDs();
    }

    public int getActiveIndexCount() {
        IndexSearchEngine<GUID> indexSearchEngine = this.getSearchEngine();
        SearchCommand searchCommand = new SearchCommand("active", SearchCondition.SearchTermOperator.Equals, SearchTagActive.valueAsString(true));
        return indexSearchEngine.simpleSearch(searchCommand).size();
    }

    public void setCurrentUserAccountID(@Nullable GUID current) {
        if (c.get() != null) {
            throw new IllegalStateException("Login inside of an UserAcountScope block is forbidden.");
        }
        b.set(current);
    }

    @Nullable
    GUID b(@Nullable GUID gUID) {
        GUID gUID2 = c.get();
        c.set(gUID);
        return gUID2;
    }

    @Nullable
    public GUID getCurrentUserAccountID() {
        GUID gUID = c.get();
        if (gUID == null && (gUID = b.get()) == null) {
            gUID = d;
        }
        return gUID == UserAccountScope.a ? null : gUID;
    }

    @Nullable
    public GUID getCurrentUserAccountID(@Nullable BaseRunnableSession session) {
        if (d != null) {
            return d;
        }
        return session != null ? session.getSessionValue(b) : b.get();
    }

    public void setCurrentUserAccountID(BaseRunnableSession session, @Nullable GUID accountID) {
        session.setSessionValue(b, accountID);
    }

    @Nullable
    public UserAccount getCurrentUserAccount() {
        GUID gUID = this.getCurrentUserAccountID();
        if (gUID != null) {
            UserAccount userAccount = this.getUserAccount(gUID);
            if (userAccount != null) {
                if (userAccount.isActive()) {
                    return userAccount;
                }
                if (c.get() != null) {
                    return userAccount;
                }
            }
            if (c.get() == null) {
                this.setCurrentUserAccountID(null);
                LoginManager.userLoggedOut(null, null);
            }
            if (this != com.inet.usersandgroups.api.user.UserManager$a.a) {
                throw new UnsupportedOperationException();
            }
        }
        return null;
    }

    public void setCurrentUserAccountIDForAllThreads(@Nullable GUID accountID) {
        d = accountID;
    }

    public void hardReset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract long getAccountFileSize(GUID var1);

    public abstract void clearUserAuthGroupNames(GUID var1);

    public UserAccount getUserAccountAsUser(GUID accountId) {
        UserAccount userAccount = this.getUserAccount(accountId);
        if (userAccount == null) {
            return null;
        }
        DynamicExtensionManager.getInstance().get(UserSearchFilter.class).forEach(userSearchFilter -> userSearchFilter.checkCanSeeUserDetails(userAccount));
        return userAccount;
    }

    static {
        PRIVILEGED_ACCOUNT_ID = GUID.valueOf("privilegedxdp8fp4k2oym5pv");
        MASTER_ACCOUNT_ID = GUID.valueOf("sys06h5v2a7d2o4ca4vgxwj2l");
        RECOVERY_ACCOUNT_ID = GUID.valueOf("sys09vx03y1xv4fnvrp23ixzl");
        b = new SessionLocal();
        c = new ThreadLocal();
        e = new SearchIndexVeto("User Account Search Index");
        f = new UserSearchIndexVetoPower(e, () -> {
            UserManager.getInstance();
            UserManager.getRecoveryEnabledInstance();
        });
        g = new DynamicExtension<UserField>(UserField.class);
    }

    private static class a {
        @Nonnull
        private static UserManager a = com.inet.usersandgroups.api.user.UserManager$a.a(false);
        @Nonnull
        private static UserManager b = com.inet.usersandgroups.api.user.UserManager$a.a(true);

        @Nonnull
        private static UserManager a(boolean bl) {
            if (ConfigurationManager.isHelpCenterMode()) {
                return bl ? a : com.inet.usersandgroups.api.user.UserManager$a.a();
            }
            if (ConfigurationManager.isRecoveryMode()) {
                if (bl) {
                    return com.inet.usersandgroups.api.user.UserManager$a.b(bl);
                }
                return com.inet.usersandgroups.api.user.UserManager$a.a();
            }
            return bl ? a : com.inet.usersandgroups.api.user.UserManager$a.b(bl);
        }

        @Nonnull
        private static UserManager a() {
            return new BaseUserManagerFactory().createManager(false, null);
        }

        @Nonnull
        private static UserManager b(boolean bl) {
            UserManagerFactory userManagerFactory = ServerPluginManager.getInstance().getOptionalInstance(UserManagerFactory.class);
            if (userManagerFactory == null) {
                userManagerFactory = new BaseUserManagerFactory();
            }
            return userManagerFactory.createManager(bl, e);
        }
    }
}

