/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.annotations.InternalApi;
import com.inet.cache.MemorySize;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccountType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@InternalApi
public class UserAccount
implements MemorySize {
    private final GUID a;
    private final UserAccountType b;
    private final boolean c;
    private final long d;
    private final long e;
    private final MutableUserData f;
    private final Set<Permission> g;
    private final Set<Permission> h;
    private final List<LoginSettings> i;

    public static UserAccount create(@Nonnull GUID accountID, UserAccountType accountType, long lastModified, long lastAccess, @Nonnull MutableUserData userData, @Nonnull List<LoginSettings> loginSettings, @Nonnull Set<Permission> permissions, boolean active) {
        return new UserAccount(accountID, accountType, lastModified, lastAccess, userData, loginSettings, permissions, active);
    }

    public static UserAccount createForActiveUser(@Nonnull GUID accountID, UserAccountType accountType, long lastModified, long lastAccess, @Nonnull MutableUserData userData, @Nonnull List<LoginSettings> loginSettings, @Nonnull Set<Permission> permissions) {
        return new UserAccount(accountID, accountType, lastModified, lastAccess, userData, loginSettings, permissions, true);
    }

    public static UserAccount createForInactiveUser(@Nonnull GUID accountID, UserAccountType accountType, long lastModified, long lastAccess, @Nonnull MutableUserData userData, @Nonnull List<LoginSettings> loginSettings, @Nonnull Set<Permission> permissions) {
        return new UserAccount(accountID, accountType, lastModified, lastAccess, userData, loginSettings, permissions, false);
    }

    private UserAccount(@Nonnull GUID accountID, UserAccountType accountType, long lastModified, long lastAccess, @Nonnull MutableUserData userData, @Nonnull List<LoginSettings> loginSettings, @Nonnull Set<Permission> permissions, boolean active) {
        this.a = accountID;
        this.b = accountType;
        this.d = lastModified;
        this.e = lastAccess;
        this.f = userData.copy();
        this.i = Collections.unmodifiableList(new ArrayList<LoginSettings>(loginSettings));
        this.g = Collections.unmodifiableSet(new HashSet<Permission>(permissions));
        this.h = Collections.unmodifiableSet(permissions.stream().filter(permission -> {
            try {
                Permission.valueOf(permission.getKey());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }).collect(Collectors.toSet()));
        this.c = active;
    }

    @Nonnull
    public String getDisplayName() {
        boolean bl;
        String string = this.getValue(UsersAndGroups.FIELD_LASTNAME);
        String string2 = this.getValue(UsersAndGroups.FIELD_FIRSTNAME);
        boolean bl2 = string != null && string.length() > 0;
        boolean bl3 = bl = string2 != null && string2.length() > 0;
        if (bl2) {
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2).append(' ').append(string);
                if (stringBuilder.length() > 50) {
                    return string;
                }
                return stringBuilder.toString();
            }
            return string;
        }
        if (bl) {
            return string2;
        }
        String string3 = this.getValue(UsersAndGroups.FIELD_EMAIL);
        String string4 = EmailAddressHelper.get().getFirstEmailAddress(string3);
        if (string4 != null) {
            return string4;
        }
        if (!this.i.isEmpty()) {
            return this.i.get(0).getDisplayName();
        }
        return this.a.toString();
    }

    @Nonnull
    public GUID getID() {
        return this.a;
    }

    public UserAccountType getAccountType() {
        return this.b;
    }

    public boolean isActive() {
        return this.c;
    }

    public long getLastModified() {
        return this.d;
    }

    public long getLastAccess() {
        return this.e;
    }

    public Set<Permission> getPermissions() {
        return this.h;
    }

    public Set<Permission> getPermissionsIncludingInactive() {
        return this.g;
    }

    public List<LoginSettings> getLoginSettings() {
        return this.i;
    }

    public List<LoginSettings> getLoginSettingsFor(String loginSource) {
        return this.i.stream().filter(loginSettings -> loginSettings.getLoginSource().equals(loginSource)).collect(Collectors.toList());
    }

    public <VALUE> VALUE getValue(UserField<VALUE> field) {
        VALUE VALUE = this.f.get(field);
        return VALUE == null ? null : (VALUE)field.copyValue(VALUE);
    }

    public Set<UserField<Object>> getIncludedFields() {
        return this.f.getIncludedFields();
    }

    public UserAccount copyWith(long lastModified) {
        return UserAccount.create(this.a, this.b, lastModified, this.e, this.f, this.i, this.g, this.c);
    }

    public UserAccount copyWith(boolean active, long lastModified) {
        return UserAccount.create(this.a, this.b, lastModified, this.e, this.f, this.i, this.g, active);
    }

    @Override
    public long getSizeInMemory() {
        return 328L + this.f.getSizeInMemory();
    }
}

