/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.user;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.stayloggedin.StayLoggedInHandler;
import com.inet.authentication.stayloggedin.StayLoggedInSession;
import com.inet.http.ExpandableHttpSessionListener;
import com.inet.http.servlet.SessionStore;
import com.inet.http.utils.UserAgent;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.ui.fields.UserUpdateData;
import com.inet.usersandgroups.api.ui.fields.user.CoreUserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.StayLoggedInSessionDefinition;
import com.inet.usersandgroups.api.ui.fields.user.StayLoggedInSessionDescription;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class StayLoggedInSessionsUserFieldDefinition
extends UserFieldDefinition<StayLoggedInSessionDefinition>
implements CoreUserFieldDefinition {
    public StayLoggedInSessionsUserFieldDefinition(String groupKey, String fieldKey, int prio) {
        super(groupKey, fieldKey, "fieldtype_stayloggedinsessions", prio);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressFBWarnings(value={"UNSAFE_HASH_EQUALS"}, justification="Double for loop make a timeing attack inpossible.")
    public FieldValue getFieldValue(@Nullable UserAccount userAccount) {
        Object object;
        String string;
        Object object2;
        Object object3;
        List<Object> list = userAccount != null ? StayLoggedInHandler.getSessions(userAccount.getID()) : new ArrayList();
        String string2 = SessionStore.getHttpSessionId();
        long l2 = System.currentTimeMillis() - 180000L;
        HashSet<HttpSession> hashSet = new HashSet<HttpSession>(ExpandableHttpSessionListener.getActiveSessions());
        ArrayList<AuthenticationDescription> arrayList = new ArrayList<AuthenticationDescription>(LoginManager.getAllAuthenticationDescriptions());
        ArrayList<StayLoggedInSessionDescription> arrayList2 = new ArrayList<StayLoggedInSessionDescription>();
        for (Object object5 : list) {
            void var15_17;
            String object6 = ((StayLoggedInSession)object5).getBrowser().getDisplayName();
            object3 = ((StayLoggedInSession)object5).getOS().getDisplayName();
            long l3 = ((StayLoggedInSession)object5).getLastUse();
            String string3 = ((StayLoggedInSession)object5).getProvider();
            object2 = ((StayLoggedInSession)object5).getClientID();
            string = ((StayLoggedInSession)object5).getHashToken();
            boolean bl = false;
            boolean bl2 = false;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                HttpSession httpSession = (HttpSession)iterator.next();
                try {
                    StayLoggedInSession stayLoggedInSession = (StayLoggedInSession)httpSession.getAttribute(StayLoggedInSession.class.getName());
                    if (stayLoggedInSession == null || !stayLoggedInSession.getClientID().equals(object2) || !stayLoggedInSession.getHashToken().equals(string)) continue;
                    bl = httpSession.getId().equals(string2);
                    if (!bl && httpSession.getLastAccessedTime() >= l2) {
                        bl2 = true;
                    }
                    iterator.remove();
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                }
            }
            for (AuthenticationDescription authenticationDescription : arrayList) {
                if (!authenticationDescription.getProvider().name().equals(string3)) continue;
                String string4 = authenticationDescription.getDisplayName();
                break;
            }
            arrayList2.add(new StayLoggedInSessionDescription(string, (String)object2, (String)var15_17, (String)object3, ((StayLoggedInSession)object5).getOS().name().toLowerCase(), object6, ((StayLoggedInSession)object5).getBrowser().name(), l3, bl, bl2, false));
        }
        if (userAccount != null) {
            object = userAccount.getID();
            for (HttpSession httpSession : hashSet) {
                try {
                    void var15_26;
                    Object object4;
                    object3 = LoginManager.getLoginProcessor(httpSession);
                    if (object3 == null || !((GUID)object).equals(((LoginProcessor)object3).getUserAccountID())) continue;
                    String string5 = ((LoginProcessor)object3).getLoginSource();
                    for (AuthenticationDescription authenticationDescription : arrayList) {
                        object2 = authenticationDescription.getProvider();
                        if ("system".equals(string5)) {
                            if (!string5.equals(authenticationDescription.getSettings().get("provider"))) continue;
                            string5 = authenticationDescription.getDisplayName();
                            break;
                        }
                        if (!string5.equals(object2.name())) continue;
                        string5 = authenticationDescription.getDisplayName();
                        break;
                    }
                    UserAgent userAgent = (UserAgent)httpSession.getAttribute(UserAgent.class.getName());
                    StayLoggedInSession stayLoggedInSession = (StayLoggedInSession)httpSession.getAttribute(StayLoggedInSession.class.getName());
                    if (userAgent != null) {
                        object4 = userAgent.os.getDisplayName();
                        String string6 = userAgent.os.name().toLowerCase();
                        object2 = userAgent.browser.getDisplayName();
                        string = userAgent.browser.name();
                    } else if (stayLoggedInSession != null) {
                        object4 = stayLoggedInSession.getOS().getDisplayName();
                        String string7 = stayLoggedInSession.getOS().name().toLowerCase();
                        object2 = stayLoggedInSession.getBrowser().getDisplayName();
                        string = stayLoggedInSession.getBrowser().name();
                    } else {
                        string = null;
                        object2 = null;
                        Object var15_25 = null;
                        object4 = null;
                    }
                    boolean bl = httpSession.getId().equals(string2);
                    boolean bl3 = !bl && httpSession.getLastAccessedTime() >= l2;
                    arrayList2.add(new StayLoggedInSessionDescription(null, httpSession.getId(), string5, (String)object4, (String)var15_26, (String)object2, string, httpSession.getLastAccessedTime(), bl, bl3, true));
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        object = new FieldValue(new Json().toJson(new StayLoggedInSessionDefinition(arrayList2)));
        ((FieldValue)object).setVisibleInPreview(!arrayList2.isEmpty());
        ((FieldValue)object).setEnabled(this.isEnabled());
        return object;
    }

    @Override
    public StayLoggedInSessionDefinition convertFromString(String value) {
        if (StringFunctions.isEmpty(value)) {
            return new StayLoggedInSessionDefinition(new ArrayList<StayLoggedInSessionDescription>());
        }
        return new Json().fromJson(value, StayLoggedInSessionDefinition.class);
    }

    @Override
    public void save(UserAccount userAccount, UserUpdateData userUpdateData, Object value) {
        StayLoggedInSessionDefinition stayLoggedInSessionDefinition = (StayLoggedInSessionDefinition)value;
        ArrayList<StayLoggedInSessionDescription> arrayList = stayLoggedInSessionDefinition.getDeleted();
        ArrayList<StayLoggedInSession> arrayList2 = new ArrayList<StayLoggedInSession>();
        if (userAccount != null) {
            List<Object> list = new ArrayList();
            list = StayLoggedInHandler.getSessions(userAccount.getID());
            block2: for (StayLoggedInSessionDescription stayLoggedInSessionDescription : arrayList) {
                Object object2;
                String string = stayLoggedInSessionDescription.getClientID();
                for (Object object2 : list) {
                    if (!Objects.equals(((StayLoggedInSession)object2).getClientID(), string) || !Objects.equals(((StayLoggedInSession)object2).getHashToken(), stayLoggedInSessionDescription.getHashToken())) continue;
                    arrayList2.add((StayLoggedInSession)object2);
                    continue block2;
                }
                Collection<HttpSession> collection = ExpandableHttpSessionListener.getActiveSessions();
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    HttpSession httpSession = (HttpSession)object2.next();
                    if (!httpSession.getId().equals(string)) continue;
                    try {
                        httpSession.invalidate();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            StayLoggedInHandler.deleteSessions(userAccount.getID(), arrayList2);
        }
    }

    @Override
    public String getLabel() {
        return null;
    }
}

