/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.http.ClientMessageException;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;

public class GroupNameFieldDefinition
extends GroupFieldDefinition<String> {
    public GroupNameFieldDefinition(String groupKey, int prio) {
        super(groupKey, "groupname", "fieldtype_string", prio);
    }

    public GroupNameFieldDefinition(String groupKey, String fieldKey, String displayType, int prio) {
        super(groupKey, fieldKey, displayType, prio);
    }

    @Override
    public FieldValue getFieldValue(UserGroupInfo userGroup) {
        String string = "";
        if (userGroup != null) {
            string = userGroup.getName();
        }
        FieldValue fieldValue = new FieldValue(string);
        fieldValue.setVisibleInPreview(string != null && !string.isEmpty());
        return fieldValue;
    }

    @Override
    public String convertFromString(String value) {
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    @Override
    public String getLabel() {
        return UsersAndGroups.getFieldDisplayName("groupname");
    }

    @Override
    public void validate(Object value) throws ClientMessageException {
        super.validate(value);
        if (value == null || ((String)value).trim().isEmpty()) {
            throw new ClientMessageException(UsersAndGroups.MSG.getMsg("usersandgroupsmanager.validation.namenotset", new Object[0]));
        }
        try {
            BasicFieldValidation.throwIfLengthExceedsLimit((String)value, 100);
        }
        catch (Throwable throwable) {
            throw new ClientMessageException(throwable.getMessage());
        }
    }

    @Override
    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        userGroupUpdateData.setName((String)value);
    }

    @Override
    public boolean isAvailable(UserGroupInfo userGroup) {
        return true;
    }
}

