/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UserGroupTreeUtils {
    public static DescendantGroups findDescendantGroups(UserGroupInfo rootGroup, Set<UserGroupInfo> allGroups) {
        Map<GUID, List<UserGroupInfo>> map = UserGroupTreeUtils.a(allGroups);
        return UserGroupTreeUtils.a(rootGroup, map, true);
    }

    public static Set<DescendantGroups> findDescendantGroups(Set<UserGroupInfo> rootGroups, Set<UserGroupInfo> allGroups, boolean sortGroups) {
        Map<GUID, List<UserGroupInfo>> map = UserGroupTreeUtils.a(allGroups);
        return rootGroups.stream().map(userGroupInfo -> UserGroupTreeUtils.a(userGroupInfo, map, sortGroups)).collect(Collectors.toSet());
    }

    private static DescendantGroups a(UserGroupInfo userGroupInfo, Map<GUID, List<UserGroupInfo>> map, boolean bl) {
        ArrayList<UserGroupInfo> arrayList = new ArrayList<UserGroupInfo>();
        int n2 = 1;
        List list = map.getOrDefault(userGroupInfo.getID(), Collections.emptyList());
        while (!list.isEmpty()) {
            ArrayList arrayList2 = new ArrayList();
            for (UserGroupInfo userGroupInfo2 : list) {
                List<UserGroupInfo> list2 = map.get(userGroupInfo2.getID());
                if (list2 == null || list2.isEmpty()) continue;
                arrayList2.addAll(list2);
            }
            arrayList.addAll(list);
            list = arrayList2;
            ++n2;
        }
        if (bl) {
            Collections.reverse(arrayList);
        }
        return new DescendantGroups(userGroupInfo, arrayList, n2);
    }

    public static int checkTreeLevel(GUID groupID, Set<UserGroupInfo> allGroups) {
        Map<GUID, List<UserGroupInfo>> map = UserGroupTreeUtils.a(allGroups);
        return UserGroupTreeUtils.a(groupID, map);
    }

    private static Map<GUID, List<UserGroupInfo>> a(Set<UserGroupInfo> set) {
        HashMap<GUID, List<UserGroupInfo>> hashMap = new HashMap<GUID, List<UserGroupInfo>>();
        for (UserGroupInfo userGroupInfo : set) {
            GUID gUID = userGroupInfo.getParentID();
            if (gUID == null) continue;
            ArrayList<UserGroupInfo> arrayList = (ArrayList<UserGroupInfo>)hashMap.get(gUID);
            if (arrayList == null) {
                arrayList = new ArrayList<UserGroupInfo>();
                hashMap.put(gUID, arrayList);
            }
            arrayList.add(userGroupInfo);
        }
        return hashMap;
    }

    private static int a(GUID gUID, Map<GUID, List<UserGroupInfo>> map) {
        int n2 = 1;
        List list = map.getOrDefault(gUID, Collections.emptyList());
        while (!list.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            boolean bl = false;
            for (UserGroupInfo userGroupInfo : list) {
                if (!userGroupInfo.isActive()) continue;
                bl = true;
                List<UserGroupInfo> list2 = map.get(userGroupInfo.getID());
                if (list2 == null || list2.isEmpty()) continue;
                arrayList.addAll(list2);
            }
            if (!bl) {
                return n2;
            }
            list = arrayList;
            ++n2;
        }
        return n2;
    }

    public static class DescendantGroups {
        private UserGroupInfo a;
        private List<UserGroupInfo> b;
        private int c;

        public DescendantGroups(UserGroupInfo rootGroup, List<UserGroupInfo> descendantGroups, int treeLevel) {
            this.a = rootGroup;
            this.b = descendantGroups;
            this.c = treeLevel;
        }

        public UserGroupInfo getRootGroup() {
            return this.a;
        }

        public List<UserGroupInfo> getDescendantGroups() {
            return this.b;
        }

        public int getTreeLevel() {
            return this.c;
        }
    }
}

