/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.groups;

import com.inet.annotations.InternalApi;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

@InternalApi
public abstract class GroupTypeDef {
    private final GroupType a;
    private final Set<MembershipType> b;
    private final MemberToTypeCardinality c;
    private final Set<GroupTypeRestrictions> d;
    private final int e;

    public GroupTypeDef(int priority, GroupType groupType, GroupTypeRestrictions ... restrictions) {
        this(priority, groupType, Collections.emptySet(), MemberToTypeCardinality.Zero, restrictions);
    }

    public GroupTypeDef(int priority, GroupType groupType, Set<MembershipType> membershipTypes, MemberToTypeCardinality cardinality, GroupTypeRestrictions ... restrictions) {
        if (groupType == null) {
            throw new IllegalArgumentException("group type must not be null");
        }
        if (membershipTypes == null) {
            throw new IllegalArgumentException("set of membership types must not be null");
        }
        if (membershipTypes.contains(null)) {
            throw new IllegalArgumentException("set of membership types must not contain null");
        }
        if (cardinality == null) {
            throw new IllegalArgumentException("cardinality must not be null");
        }
        if (restrictions == null) {
            throw new IllegalArgumentException("restrictions must not be null");
        }
        if (MemberToTypeCardinality.Zero.equals((Object)cardinality) && !membershipTypes.isEmpty()) {
            String string = String.format("set of membership types must be empty if cardinality is set to \"Zero\": groupType=\"%s\", membershipTypes=\"%s\"", groupType.getName(), membershipTypes);
            throw new IllegalArgumentException(string);
        }
        this.e = priority;
        this.a = groupType;
        this.b = Collections.unmodifiableSet(new HashSet<MembershipType>(membershipTypes));
        this.c = cardinality;
        this.d = Collections.unmodifiableSet(new HashSet<GroupTypeRestrictions>(Arrays.asList(restrictions)));
    }

    public final GroupType getGroupType() {
        return this.a;
    }

    public final Set<MembershipType> getMembershipTypes() {
        return this.b;
    }

    public final MemberToTypeCardinality getMemberToTypeCardinality() {
        return this.c;
    }

    public final Set<GroupTypeRestrictions> getRestrictions() {
        return this.d;
    }

    public final boolean isRestrictedBy(GroupTypeRestrictions restriction) {
        return this.d.contains((Object)restriction);
    }

    public boolean isSystemGroup() {
        return false;
    }

    public boolean allowsNonUniqueNames() {
        return false;
    }

    public int getPriority() {
        return this.e;
    }

    public int getMaxTreeLevel() {
        return 1;
    }

    public boolean inheritsMembershipsFromParent() {
        return false;
    }

    public abstract String getDisplayName();

    public String getCreateLabel() {
        return this.getDisplayName();
    }

    public abstract String getDescription();

    @Nullable
    public abstract URL getIconURL(int var1);

    public static final class GroupTypeRestrictions
    extends Enum<GroupTypeRestrictions> {
        public static final /* enum */ GroupTypeRestrictions PreventCreation = new GroupTypeRestrictions();
        public static final /* enum */ GroupTypeRestrictions PreventRenaming = new GroupTypeRestrictions();
        public static final /* enum */ GroupTypeRestrictions PreventRemoval = new GroupTypeRestrictions();
        public static final /* enum */ GroupTypeRestrictions PreventDataEditing = new GroupTypeRestrictions();
        public static final /* enum */ GroupTypeRestrictions PreventMembershipEditing = new GroupTypeRestrictions();
        public static final /* enum */ GroupTypeRestrictions PreventPermissionEditing = new GroupTypeRestrictions();
        public static final /* enum */ GroupTypeRestrictions PreventDeactivation = new GroupTypeRestrictions();
        private static final /* synthetic */ GroupTypeRestrictions[] a;

        public static GroupTypeRestrictions[] values() {
            return (GroupTypeRestrictions[])a.clone();
        }

        public static GroupTypeRestrictions valueOf(String name) {
            return Enum.valueOf(GroupTypeRestrictions.class, name);
        }

        private static /* synthetic */ GroupTypeRestrictions[] a() {
            return new GroupTypeRestrictions[]{PreventCreation, PreventRenaming, PreventRemoval, PreventDataEditing, PreventMembershipEditing, PreventPermissionEditing, PreventDeactivation};
        }

        static {
            a = GroupTypeRestrictions.a();
        }
    }
}

