/*
 * Decompiled with CFR 0.152.
 */
package com.inet.thread;

import com.inet.error.ErrorCode;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CountedReadWriteLock {
    private static final HashMap<Object, CountedReadWriteLock> a = new HashMap();
    private Object b;
    private Thread c;
    private int d;
    private int e;

    private CountedReadWriteLock(Object key) {
        this.b = key;
    }

    @Nonnull
    public static CountedReadWriteLock getReadWriteLock(Object key, boolean write) {
        return CountedReadWriteLock.getReadWriteLock(key, write, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static CountedReadWriteLock getReadWriteLock(Object key, boolean write, long timeout) {
        long l2 = timeout > 0L ? System.currentTimeMillis() + timeout : 0L;
        HashMap<Object, CountedReadWriteLock> hashMap = a;
        synchronized (hashMap) {
            CountedReadWriteLock countedReadWriteLock;
            while ((countedReadWriteLock = CountedReadWriteLock.tryReadWriteLockInstance(key, write)) == null) {
                try {
                    long l3;
                    if (timeout > 0L) {
                        l3 = l2 - System.currentTimeMillis();
                        if (l3 <= 0L) {
                            Thread thread;
                            countedReadWriteLock = a.get(key);
                            TimeoutException timeoutException = new TimeoutException("Timeout while waiting for " + (write ? "write" : "read") + " lock: " + String.valueOf(key) + ", timeout: " + timeout + ", current state: " + String.valueOf(countedReadWriteLock));
                            if (countedReadWriteLock != null && (thread = countedReadWriteLock.c) != null) {
                                @Nonnull Exception exception = new Exception(thread.getName());
                                exception.setStackTrace(thread.getStackTrace());
                                timeoutException.addSuppressed(exception);
                            }
                            throw timeoutException;
                        }
                    } else {
                        l3 = 0L;
                    }
                    a.wait(l3);
                }
                catch (Exception exception) {
                    throw (RuntimeException)ErrorCode.throwAny(exception);
                }
            }
            return countedReadWriteLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CountedReadWriteLock tryReadWriteLockInstance(Object key, boolean write) {
        CountedReadWriteLock countedReadWriteLock;
        HashMap<Object, CountedReadWriteLock> hashMap = a;
        synchronized (hashMap) {
            countedReadWriteLock = a.get(key);
            if (countedReadWriteLock == null) {
                countedReadWriteLock = new CountedReadWriteLock(key);
                a.put(key, countedReadWriteLock);
            }
            if (write) {
                Thread thread = Thread.currentThread();
                if (countedReadWriteLock.e > 0 || countedReadWriteLock.c != null && countedReadWriteLock.c != thread) {
                    return null;
                }
                countedReadWriteLock.c = thread;
                ++countedReadWriteLock.d;
            } else {
                if (countedReadWriteLock.d > 0) {
                    return null;
                }
                ++countedReadWriteLock.e;
            }
        }
        return countedReadWriteLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(boolean write) {
        HashMap<Object, CountedReadWriteLock> hashMap = a;
        synchronized (hashMap) {
            if (write) {
                --this.d;
            } else {
                --this.e;
            }
            if (this.d <= 0 && this.e <= 0) {
                a.remove(this.b);
                a.notifyAll();
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.b) + " " + this.e + "/" + this.d + " " + String.valueOf(this.c);
    }
}

