/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.annotations.InternalApi;
import com.inet.logging.LogManager;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.GraphicLayer;
import com.inet.shared.utils.GraphicLayerNormal;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nonnull;

@InternalApi
public class LayerGraphics2D
extends Graphics2D {
    private Graphics2D a;
    private boolean b = true;
    private Rectangle2D c;
    private BufferedImage d;
    private Graphics2D e;
    private Color f;
    private AffineTransform g = new AffineTransform();
    private final LinkedList<GraphicLayer> h = new LinkedList();
    private boolean i;
    public static int MAXSIZE = 2048;

    private Graphics2D a(boolean bl) throws UnsupportedOperationException {
        if (this.h.isEmpty()) {
            if (this.a == null) {
                throw new UnsupportedOperationException("Target graphic not set!");
            }
            return this.a;
        }
        return this.h.peekLast().a(bl);
    }

    public boolean hasGraphics() {
        return this.a != null;
    }

    public void setGraphics(@Nonnull Graphics2D graphics2D) {
        this.a = graphics2D;
        this.b = false;
        if (this.e != null) {
            LayerGraphics2D.setGraphicSettings(LayerGraphics2D.getGraphicSettings(graphics2D), this.e);
        }
    }

    public Graphics2D getRootGraphics() {
        return this.a;
    }

    public void setInitialInformation(@Nonnull Rectangle2D imgBound, AffineTransform initialTransformation) throws UnsupportedOperationException {
        if (imgBound == null) {
            throw new UnsupportedOperationException("Image size can not be null!");
        }
        if (this.a != null) {
            imgBound = new Rectangle2D.Double(imgBound.getX(), imgBound.getY(), Math.abs(imgBound.getWidth() * this.a.getTransform().getScaleX()), Math.abs(imgBound.getHeight() * this.a.getTransform().getScaleY()));
        }
        if (this.i) {
            if (imgBound.equals(this.c)) {
                return;
            }
            if (LogManager.getApplicationLogger().isDebug()) {
                LogManager.getApplicationLogger().debug("Layergraphic can only on time initalize.\nCurrent bounds = " + String.valueOf(this.c) + "\tTransform = " + String.valueOf(this.g) + "\nBounds = " + String.valueOf(imgBound) + "\tTransform = " + String.valueOf(initialTransformation));
            }
            return;
        }
        this.c = imgBound;
        this.g = initialTransformation;
        this.d = this.b();
        this.i = true;
        this.e = this.d.createGraphics();
        if (this.a != null) {
            LayerGraphics2D.setGraphicSettings(LayerGraphics2D.getGraphicSettings(this.a), this.e);
        }
    }

    public int getNumOfLayers() {
        return this.h.size();
    }

    public void addLayer(boolean knockout, boolean isolate, BlendComposite composite) throws UnsupportedOperationException {
        if (!this.i) {
            throw new UnsupportedOperationException("Layergraphic must correct initialize for work with more layers.");
        }
        GraphicLayer graphicLayer = null;
        if (composite.getMode() == BlendComposite.BlendingMode.NORMAL && composite.getAlpha() >= 1.0f && composite.getMask() == null && !isolate && !knockout) {
            Graphics2D graphics2D = (Graphics2D)this.a(true).create();
            if (this.h.isEmpty()) {
                graphicLayer = new GraphicLayerNormal(graphics2D, (Graphics2D)this.e.create());
            } else {
                GraphicLayerNormal graphicLayerNormal;
                GraphicLayer graphicLayer2 = this.h.getLast();
                if (graphicLayer2 instanceof GraphicLayerNormal && (graphicLayerNormal = (GraphicLayerNormal)graphicLayer2).getBackdropGraphics() != null) {
                    graphicLayer = new GraphicLayerNormal(graphics2D, (Graphics2D)graphicLayerNormal.getBackdropGraphics().create());
                }
            }
            if (graphicLayer == null) {
                graphicLayer = new GraphicLayerNormal(graphics2D);
            }
        } else {
            BufferedImage bufferedImage;
            if (isolate) {
                bufferedImage = new BufferedImage(this.d.getWidth(), this.d.getHeight(), 2);
            } else {
                bufferedImage = null;
                for (int i2 = this.h.size() - 1; i2 >= 0; --i2) {
                    GraphicLayer graphicLayer3 = this.h.get(i2);
                    if (graphicLayer3 instanceof GraphicLayerNormal) continue;
                    bufferedImage = graphicLayer3.b();
                    break;
                }
                if (bufferedImage == null) {
                    bufferedImage = this.d;
                }
            }
            graphicLayer = new GraphicLayer(bufferedImage, composite, this.a(true), new Rectangle2D.Double(0.0, 0.0, this.d.getWidth(), this.d.getHeight()), knockout, isolate, this.g);
        }
        this.h.add(graphicLayer);
    }

    public void paintLastLayer() throws IllegalStateException, UnsupportedOperationException {
        if (!this.i) {
            throw new UnsupportedOperationException("Layergraphic must correct initialize for work with more layers.");
        }
        if (this.h.isEmpty()) {
            throw new IllegalStateException("No more layer exist!");
        }
        GraphicLayer graphicLayer = this.h.pollLast();
        if (graphicLayer instanceof GraphicLayerNormal) {
            return;
        }
        if (this.h.isEmpty()) {
            BufferedImage bufferedImage = graphicLayer.a();
            graphicLayer.getComposite().setBackdrop(this.d);
            this.a(this.a, bufferedImage, graphicLayer.getComposite());
            this.a(this.e, bufferedImage, graphicLayer.getComposite());
        } else {
            this.h.peekLast().a(graphicLayer);
        }
    }

    private void a(Graphics2D graphics2D, BufferedImage bufferedImage, BlendComposite blendComposite) throws IllegalStateException {
        graphics2D = (Graphics2D)graphics2D.create();
        try {
            graphics2D.transform(graphics2D.getTransform().createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        graphics2D.setComposite(blendComposite);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
    }

    public BufferedImage getBaseLayer() {
        return this.d;
    }

    public BufferedImage getCurrentState() {
        BufferedImage bufferedImage = new BufferedImage(this.d.getWidth(), this.d.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.d, 0, 0, null);
        for (GraphicLayer graphicLayer : this.h) {
            if (graphicLayer instanceof GraphicLayerNormal) continue;
            graphics2D.setComposite(graphicLayer.getComposite());
            graphics2D.drawImage((Image)graphicLayer.a(), 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void draw(Shape s) {
        AffineTransform affineTransform = this.getTransform();
        if (s instanceof Path2D) {
            Stroke stroke;
            boolean bl = false;
            if (this.getRenderingHint(RenderingHints.KEY_ANTIALIASING) != RenderingHints.VALUE_ANTIALIAS_OFF) {
                if (affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0) {
                    bl = true;
                } else {
                    double d2;
                    double d3 = affineTransform.getScaleX();
                    if (d3 != (d2 = affineTransform.getScaleY()) && Math.abs(d3) != Math.abs(d2)) {
                        if (Math.abs(Math.abs(d3) - Math.abs(d2)) < 0.005) {
                            double d4 = Math.signum(d3);
                            double d5 = Math.signum(d2);
                            double d6 = (Math.abs(d3) + Math.abs(d2)) / 2.0;
                            d3 = d4 > 0.0 ? d6 : -d6;
                            d2 = d5 > 0.0 ? d6 : -d6;
                            affineTransform = new AffineTransform(d3, 0.0, 0.0, d2, affineTransform.getTranslateX(), affineTransform.getTranslateY());
                            this.setTransform(affineTransform);
                        } else {
                            bl = true;
                        }
                    }
                }
            }
            if (bl && (stroke = this.getStroke()) != null) {
                this.fill(stroke.createStrokedShape(s));
                return;
            }
        }
        if (this.h.isEmpty() && this.e != null) {
            this.e.draw(s);
        }
        this.a(true).draw(s);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawImage(this.a(img, this.e), xform, obs);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), xform, obs);
    }

    private Image a(Image image, Graphics2D graphics2D) {
        try {
            if (graphics2D.getDeviceConfiguration().getDevice().getType() != 2) {
                return image;
            }
        }
        catch (Exception exception) {
            return image;
        }
        if (image instanceof BufferedImage && ((BufferedImage)image).getType() == 0) {
            return Toolkit.getDefaultToolkit().createImage(image.getSource());
        }
        return image;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawImage(img, op, x, y);
        }
        this.a(true).drawImage(img, op, x, y);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawRenderedImage(img, xform);
        }
        this.a(true).drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawRenderableImage(img, xform);
        }
        this.a(true).drawRenderableImage(img, xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawString(str, x, y);
        }
        this.a(true).drawString(str, x, y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawString(str, x, y);
        }
        this.a(true).drawString(str, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawString(iterator, x, y);
        }
        this.a(true).drawString(iterator, x, y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawImage(this.a(img, this.e), x, y, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawImage(this.a(img, this.e), x, y, width, height, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawImage(this.a(img, this.e), x, y, bgcolor, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), x, y, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawImage(this.a(img, this.e), x, y, width, height, bgcolor, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawImage(this.a(img, this.e), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawImage(this.a(img, this.e), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        }
        return this.a(true).drawImage(this.a(img, this.a(true)), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public void dispose() {
        if (this.h.isEmpty() && this.e != null) {
            this.e.dispose();
        }
        Graphics2D graphics2D = this.a(false);
        if (this.b || graphics2D != this.a) {
            graphics2D.dispose();
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawString(iterator, x, y);
        }
        this.a(true).drawString(iterator, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g2, float x, float y) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawGlyphVector(g2, x, y);
        }
        this.a(true).drawGlyphVector(g2, x, y);
    }

    @Override
    public void fill(Shape s) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.fill(s);
        }
        Composite composite = this.a(false).getComposite();
        this.a();
        this.a(true).fill(s);
        this.a(false).setComposite(composite);
    }

    private void a() {
        Composite composite = this.a(false).getComposite();
        if (composite instanceof BlendComposite) {
            BlendComposite blendComposite = (BlendComposite)composite;
            if (this.c != null && blendComposite.getMask() != null) {
                BufferedImage bufferedImage = new BufferedImage((int)Math.round(this.c.getWidth()), (int)Math.round(this.c.getHeight()), 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                LayerGraphics2D.copyGraphicSettingsForMask(this.a(false), graphics2D);
                graphics2D.transform(this.g);
                graphics2D.drawImage((Image)blendComposite.getMask(), 0, 0, null);
                graphics2D.dispose();
                int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                int n2 = Color.BLACK.getRGB();
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    if (nArray[i2] != 0) continue;
                    nArray[i2] = n2;
                }
                BlendComposite blendComposite2 = new BlendComposite(blendComposite.getMode(), blendComposite.getAlpha(), bufferedImage);
                blendComposite2.setBackdrop(blendComposite.getBackdrop());
                this.a(false).setComposite(blendComposite2);
            }
        }
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.hit(rect, s, onStroke);
        }
        return this.a(false).hit(rect, s, onStroke);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.a(false).getDeviceConfiguration();
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setRenderingHint(hintKey, hintValue);
        }
        this.a(false).setRenderingHint(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.a(false).getRenderingHint(hintKey);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.addRenderingHints(hints);
        }
        this.a(false).addRenderingHints(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.a(false).getRenderingHints();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setRenderingHints(hints);
        }
        this.a(false).setRenderingHints(hints);
    }

    @Override
    public Graphics create() {
        LayerGraphics2D layerGraphics2D = new LayerGraphics2D();
        layerGraphics2D.a = (Graphics2D)this.a.create();
        layerGraphics2D.c = this.c;
        layerGraphics2D.g = this.g;
        for (GraphicLayer graphicLayer : this.h) {
            layerGraphics2D.h.add(graphicLayer.c());
        }
        for (GraphicLayer graphicLayer : layerGraphics2D.h) {
            graphicLayer.d();
        }
        layerGraphics2D.d = this.d;
        if (this.e != null) {
            layerGraphics2D.e = (Graphics2D)this.e.create();
        }
        layerGraphics2D.i = this.i;
        return layerGraphics2D;
    }

    @Override
    public void translate(int x, int y) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.translate(x, y);
        }
        this.a(false).translate(x, y);
    }

    @Override
    public Color getColor() {
        return this.a(false).getColor();
    }

    @Override
    public void setColor(Color c2) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setColor(c2);
        }
        this.a(false).setColor(c2);
    }

    @Override
    public void setPaintMode() {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setPaintMode();
        }
        this.a(false).setPaintMode();
    }

    @Override
    public void setXORMode(Color c1) {
        this.f = c1;
        if (this.h.isEmpty() && this.e != null) {
            this.e.setXORMode(c1);
        }
        this.a(false).setXORMode(c1);
    }

    @Override
    public Font getFont() {
        return this.a(false).getFont();
    }

    @Override
    public void setFont(Font font) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setFont(font);
        }
        this.a(false).setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f2) {
        return this.a(false).getFontMetrics();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.a(false).getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.a(false).clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.a(false).clipRect(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.a(false).getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.a(false).setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.copyArea(x, y, width, height, dx, dy);
        }
        this.a(false).copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawLine(x1, y1, x2, y2);
        }
        this.a(true).drawLine(x1, y1, x2, y2);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.fillRect(x, y, width, height);
        }
        this.a(true).fillRect(x, y, width, height);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.clearRect(x, y, width, height);
        }
        this.a(true).clearRect(x, y, width, height);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
        this.a(true).drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
        this.a(true).fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawOval(x, y, width, height);
        }
        this.a(true).drawOval(x, y, width, height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.fillOval(x, y, width, height);
        }
        this.a(true).fillOval(x, y, width, height);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawArc(x, y, width, height, startAngle, arcAngle);
        }
        this.a(true).drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.fillArc(x, y, width, height, startAngle, arcAngle);
        }
        this.a(true).fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawPolyline(xPoints, yPoints, nPoints);
        }
        this.a(true).drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.drawPolygon(xPoints, yPoints, nPoints);
        }
        this.a(true).drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.fillPolygon(xPoints, yPoints, nPoints);
        }
        this.a(true).fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void translate(double tx, double ty) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.translate(tx, ty);
        }
        this.a(false).translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.rotate(theta);
        }
        this.a(false).rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.rotate(theta, x, y);
        }
        this.a(false).rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.scale(sx, sy);
        }
        this.a(false).scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.shear(shx, shy);
        }
        this.a(false).shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.transform(Tx);
        }
        this.a(false).transform(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        AffineTransform affineTransform = this.a(false).getTransform();
        if (!this.h.isEmpty()) {
            AffineTransform affineTransform2 = this.h.peekLast().getPreviousLayerTransformation();
            try {
                affineTransform.concatenate(affineTransform2.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return affineTransform;
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setTransform(Tx);
        }
        if (this.h.isEmpty()) {
            this.a(false).setTransform(Tx);
        } else {
            AffineTransform affineTransform = this.h.peekLast().getPreviousLayerTransformation();
            affineTransform.concatenate(Tx);
            this.a(false).setTransform(affineTransform);
        }
    }

    @Override
    public Paint getPaint() {
        return this.a(false).getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setPaint(paint);
        }
        this.a(false).setPaint(paint);
    }

    @Override
    public Composite getComposite() {
        return this.a(true).getComposite();
    }

    @Override
    public void setComposite(Composite comp) {
        GraphicLayer graphicLayer;
        BlendComposite blendComposite;
        if (comp instanceof BlendComposite && (blendComposite = (BlendComposite)comp).getMode() == BlendComposite.BlendingMode.NORMAL && blendComposite.getBackdrop() == null && blendComposite.getMask() == null && ((graphicLayer = this.h.peekLast()) == null || graphicLayer.getClass() == GraphicLayerNormal.class)) {
            comp = AlphaComposite.getInstance(3, blendComposite.getAlpha());
        }
        if (this.h.isEmpty() && this.e != null) {
            this.e.setComposite(comp);
        }
        if (this.h.peekLast() == null) {
            this.a(false).setComposite(comp);
        } else {
            this.h.peekLast().a(comp);
        }
    }

    @Override
    public Color getBackground() {
        return this.a(false).getBackground();
    }

    @Override
    public void setBackground(Color color) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setBackground(color);
        }
        this.a(false).setBackground(color);
    }

    @Override
    public Stroke getStroke() {
        return this.a(false).getStroke();
    }

    @Override
    public void setStroke(Stroke s) {
        if (this.h.isEmpty() && this.e != null) {
            this.e.setStroke(s);
        }
        this.a(false).setStroke(s);
    }

    @Override
    public void clip(Shape s) {
        this.a(false).clip(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.a(false).getFontRenderContext();
    }

    private BufferedImage b() {
        return new BufferedImage((int)Math.ceil(this.c.getWidth()), (int)Math.ceil(this.c.getHeight()), 2);
    }

    public static void copyGraphicSettingsForMask(Graphics2D from, Graphics2D to) {
        to.setFont(from.getFont());
        to.setColor(from.getColor());
        to.setTransform(new AffineTransform(from.getTransform()));
        to.setPaint(from.getPaint());
        if (from.getBackground() != null) {
            to.setBackground(from.getBackground());
        }
        to.setStroke(from.getStroke());
        to.setRenderingHints(from.getRenderingHints());
    }

    @Nonnull
    public static GraphicsState getGraphicSettings(@Nonnull Graphics2D from) {
        GraphicsState graphicsState = new GraphicsState();
        AffineTransform affineTransform = from.getTransform();
        if (affineTransform != null) {
            graphicsState.a(affineTransform);
        } else {
            graphicsState.a(new AffineTransform());
        }
        Shape shape = from.getClip();
        graphicsState.a(shape);
        graphicsState.a(from.getFont());
        graphicsState.c(from.getColor());
        graphicsState.b(from.getBackground());
        graphicsState.a(from.getPaint());
        if (from.getBackground() != null) {
            graphicsState.b(from.getBackground());
        }
        graphicsState.a(from.getStroke());
        graphicsState.a(from.getComposite());
        if (from instanceof LayerGraphics2D) {
            LayerGraphics2D layerGraphics2D = (LayerGraphics2D)from;
            graphicsState.a(layerGraphics2D.f);
            graphicsState.a(layerGraphics2D.i);
        }
        graphicsState.a(from.getRenderingHints());
        return graphicsState;
    }

    public static void setGraphicSettings(@Nonnull GraphicsState from, @Nonnull Graphics2D to) {
        Object object;
        try {
            to.setTransform(new AffineTransform());
            to.transform(new AffineTransform(from.a));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = new AffineTransform(from.a);
            try {
                object = ((AffineTransform)object).createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
            ((AffineTransform)object).concatenate(from.a);
            to.transform((AffineTransform)object);
        }
        Shape shape = from.k;
        to.setClip(shape);
        to.setFont(from.j);
        to.setColor(from.i);
        to.setPaint(from.g);
        if (from.h != null) {
            to.setBackground(from.h);
        }
        to.setStroke(from.f);
        to.setComposite(from.e);
        if (to instanceof LayerGraphics2D) {
            object = (LayerGraphics2D)to;
            if (from.c == null) {
                to.setPaintMode();
            } else {
                to.setXORMode(from.c);
            }
            if (from.b != null) {
                ((LayerGraphics2D)object).i = from.b;
            }
        }
        to.setRenderingHints(from.d);
    }

    @InternalApi
    public static class GraphicsState {
        @Nonnull
        private AffineTransform a;
        private Boolean b;
        private Color c;
        private RenderingHints d;
        private Composite e;
        private Stroke f;
        private Paint g;
        private Color h;
        private Color i;
        private Font j;
        private Shape k;

        private void a(@Nonnull AffineTransform affineTransform) {
            this.a = affineTransform;
        }

        private void a(boolean bl) {
            this.b = bl;
        }

        private void a(Color color) {
            this.c = color;
        }

        private void a(RenderingHints renderingHints) {
            this.d = renderingHints;
        }

        private void a(Composite composite) {
            this.e = composite;
        }

        private void a(Stroke stroke) {
            this.f = stroke;
        }

        private void a(Paint paint) {
            this.g = paint;
        }

        private void b(Color color) {
            this.h = color;
        }

        private void c(Color color) {
            this.i = color;
        }

        private void a(Font font) {
            this.j = font;
        }

        private void a(Shape shape) {
            this.k = shape;
        }
    }
}

