/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.servlet;

import com.inet.plugin.ServerPluginManager;
import java.io.IOException;
import java.net.ServerSocket;
import javax.annotation.SuppressFBWarnings;

public class PortChecker {
    public static final int MAX_PORT = 65535;
    public static final int MIN_PORT = 1;
    public static final String SERVER_PORTS = "ServerPorts";

    @SuppressFBWarnings(value={"UNENCRYPTED_SERVER_SOCKET"}, justification="No data transfer")
    public boolean isAvailable(int port) {
        boolean bl;
        ServerSocket serverSocket = new ServerSocket(port);
        try {
            serverSocket.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        serverSocket.close();
        return bl;
    }

    public boolean isSameAsPortThatServerIsListeningOn(int port) {
        String string = ServerPluginManager.getInstance().getStartProperties().getProperty(SERVER_PORTS);
        if (string == null) {
            return false;
        }
        for (String string2 : string.split(",")) {
            try {
                if (Integer.parseInt(string2) != port) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isValidPort(String intValue) {
        int n2;
        try {
            n2 = Integer.parseInt(intValue);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n2 >= 1 && n2 <= 65535;
    }
}

